/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.dml;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.Identifier;
import org.partiql.ast.Statement;
import org.partiql.ast.dml.SetClause;
import org.partiql.ast.expr.Expr;

public final class Update
extends Statement {
    @NotNull
    private final Identifier tableName;
    @NotNull
    private final List<SetClause> setClauses;
    @Nullable
    private final Expr condition;

    public Update(@NotNull Identifier tableName, @NotNull List<SetClause> setClauses, @Nullable Expr condition) {
        this.tableName = tableName;
        this.setClauses = setClauses;
        this.condition = condition;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.tableName);
        kids.addAll(this.setClauses);
        if (this.condition != null) {
            kids.add(this.condition);
        }
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitUpdate(this, ctx);
    }

    @NotNull
    public Identifier getTableName() {
        return this.tableName;
    }

    @NotNull
    public List<SetClause> getSetClauses() {
        return this.setClauses;
    }

    @Nullable
    public Expr getCondition() {
        return this.condition;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Update)) {
            return false;
        }
        Update other = (Update)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Identifier this$tableName = this.getTableName();
        Identifier other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !((Object)this$tableName).equals(other$tableName)) {
            return false;
        }
        List<SetClause> this$setClauses = this.getSetClauses();
        List<SetClause> other$setClauses = other.getSetClauses();
        if (this$setClauses == null ? other$setClauses != null : !((Object)this$setClauses).equals(other$setClauses)) {
            return false;
        }
        Expr this$condition = this.getCondition();
        Expr other$condition = other.getCondition();
        return !(this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Update;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Identifier $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : ((Object)$tableName).hashCode());
        List<SetClause> $setClauses = this.getSetClauses();
        result = result * 59 + ($setClauses == null ? 43 : ((Object)$setClauses).hashCode());
        Expr $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Identifier tableName;
        @Generated
        private List<SetClause> setClauses;
        @Generated
        private Expr condition;

        @Generated
        Builder() {
        }

        @Generated
        public Builder tableName(@NotNull Identifier tableName) {
            if (tableName == null) {
                throw new NullPointerException("tableName is marked non-null but is null");
            }
            this.tableName = tableName;
            return this;
        }

        @Generated
        public Builder setClauses(@NotNull List<SetClause> setClauses) {
            if (setClauses == null) {
                throw new NullPointerException("setClauses is marked non-null but is null");
            }
            this.setClauses = setClauses;
            return this;
        }

        @Generated
        public Builder condition(@Nullable Expr condition) {
            this.condition = condition;
            return this;
        }

        @Generated
        public Update build() {
            return new Update(this.tableName, this.setClauses, this.condition);
        }

        @Generated
        public String toString() {
            return "Update.Builder(tableName=" + this.tableName + ", setClauses=" + this.setClauses + ", condition=" + this.condition + ")";
        }
    }
}

