/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.dml;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.Identifier;
import org.partiql.ast.Statement;
import org.partiql.ast.dml.InsertSource;

public final class Upsert
extends Statement {
    @NotNull
    private final Identifier tableName;
    @Nullable
    private final Identifier.Simple asAlias;
    @NotNull
    private final InsertSource source;

    public Upsert(@NotNull Identifier tableName, @Nullable Identifier.Simple asAlias, @NotNull InsertSource source) {
        this.tableName = tableName;
        this.asAlias = asAlias;
        this.source = source;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.tableName);
        if (this.asAlias != null) {
            kids.add(this.asAlias);
        }
        kids.add(this.source);
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitUpsert(this, ctx);
    }

    @NotNull
    public Identifier getTableName() {
        return this.tableName;
    }

    @Nullable
    public Identifier.Simple getAsAlias() {
        return this.asAlias;
    }

    @NotNull
    public InsertSource getSource() {
        return this.source;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Upsert)) {
            return false;
        }
        Upsert other = (Upsert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Identifier this$tableName = this.getTableName();
        Identifier other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !((Object)this$tableName).equals(other$tableName)) {
            return false;
        }
        Identifier.Simple this$asAlias = this.getAsAlias();
        Identifier.Simple other$asAlias = other.getAsAlias();
        if (this$asAlias == null ? other$asAlias != null : !((Object)this$asAlias).equals(other$asAlias)) {
            return false;
        }
        InsertSource this$source = this.getSource();
        InsertSource other$source = other.getSource();
        return !(this$source == null ? other$source != null : !((Object)this$source).equals(other$source));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Upsert;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Identifier $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : ((Object)$tableName).hashCode());
        Identifier.Simple $asAlias = this.getAsAlias();
        result = result * 59 + ($asAlias == null ? 43 : ((Object)$asAlias).hashCode());
        InsertSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Identifier tableName;
        @Generated
        private Identifier.Simple asAlias;
        @Generated
        private InsertSource source;

        @Generated
        Builder() {
        }

        @Generated
        public Builder tableName(@NotNull Identifier tableName) {
            if (tableName == null) {
                throw new NullPointerException("tableName is marked non-null but is null");
            }
            this.tableName = tableName;
            return this;
        }

        @Generated
        public Builder asAlias(@Nullable Identifier.Simple asAlias) {
            this.asAlias = asAlias;
            return this;
        }

        @Generated
        public Builder source(@NotNull InsertSource source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.source = source;
            return this;
        }

        @Generated
        public Upsert build() {
            return new Upsert(this.tableName, this.asAlias, this.source);
        }

        @Generated
        public String toString() {
            return "Upsert.Builder(tableName=" + this.tableName + ", asAlias=" + this.asAlias + ", source=" + this.source + ")";
        }
    }
}

