/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.expr;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.expr.Expr;

public final class ExprBetween
extends Expr {
    @NotNull
    private final Expr value;
    @NotNull
    private final Expr from;
    @NotNull
    private final Expr to;
    private final boolean not;

    public ExprBetween(@NotNull Expr value, @NotNull Expr from, @NotNull Expr to, boolean not) {
        this.value = value;
        this.from = from;
        this.to = to;
        this.not = not;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.value);
        kids.add(this.from);
        kids.add(this.to);
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitExprBetween(this, ctx);
    }

    @NotNull
    public Expr getValue() {
        return this.value;
    }

    @NotNull
    public Expr getFrom() {
        return this.from;
    }

    @NotNull
    public Expr getTo() {
        return this.to;
    }

    public boolean isNot() {
        return this.not;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExprBetween)) {
            return false;
        }
        ExprBetween other = (ExprBetween)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNot() != other.isNot()) {
            return false;
        }
        Expr this$value = this.getValue();
        Expr other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Expr this$from = this.getFrom();
        Expr other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Expr this$to = this.getTo();
        Expr other$to = other.getTo();
        return !(this$to == null ? other$to != null : !((Object)this$to).equals(other$to));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExprBetween;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNot() ? 79 : 97);
        Expr $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Expr $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Expr $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Expr value;
        @Generated
        private Expr from;
        @Generated
        private Expr to;
        @Generated
        private boolean not;

        @Generated
        Builder() {
        }

        @Generated
        public Builder value(@NotNull Expr value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
            return this;
        }

        @Generated
        public Builder from(@NotNull Expr from) {
            if (from == null) {
                throw new NullPointerException("from is marked non-null but is null");
            }
            this.from = from;
            return this;
        }

        @Generated
        public Builder to(@NotNull Expr to) {
            if (to == null) {
                throw new NullPointerException("to is marked non-null but is null");
            }
            this.to = to;
            return this;
        }

        @Generated
        public Builder not(boolean not) {
            this.not = not;
            return this;
        }

        @Generated
        public ExprBetween build() {
            return new ExprBetween(this.value, this.from, this.to, this.not);
        }

        @Generated
        public String toString() {
            return "ExprBetween.Builder(value=" + this.value + ", from=" + this.from + ", to=" + this.to + ", not=" + this.not + ")";
        }
    }
}

