/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.expr;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.Identifier;
import org.partiql.ast.SetQuantifier;
import org.partiql.ast.expr.Expr;

public final class ExprCall
extends Expr {
    @NotNull
    private final Identifier function;
    @NotNull
    private final List<Expr> args;
    @Nullable
    private final SetQuantifier setq;

    public ExprCall(@NotNull Identifier function, @NotNull List<Expr> args, @Nullable SetQuantifier setq) {
        this.function = function;
        this.args = args;
        this.setq = setq;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.function);
        kids.addAll(this.args);
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitExprCall(this, ctx);
    }

    @NotNull
    public Identifier getFunction() {
        return this.function;
    }

    @NotNull
    public List<Expr> getArgs() {
        return this.args;
    }

    @Nullable
    public SetQuantifier getSetq() {
        return this.setq;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExprCall)) {
            return false;
        }
        ExprCall other = (ExprCall)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Identifier this$function = this.getFunction();
        Identifier other$function = other.getFunction();
        if (this$function == null ? other$function != null : !((Object)this$function).equals(other$function)) {
            return false;
        }
        List<Expr> this$args = this.getArgs();
        List<Expr> other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        SetQuantifier this$setq = this.getSetq();
        SetQuantifier other$setq = other.getSetq();
        return !(this$setq == null ? other$setq != null : !((Object)this$setq).equals(other$setq));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExprCall;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Identifier $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : ((Object)$function).hashCode());
        List<Expr> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        SetQuantifier $setq = this.getSetq();
        result = result * 59 + ($setq == null ? 43 : ((Object)$setq).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Identifier function;
        @Generated
        private List<Expr> args;
        @Generated
        private SetQuantifier setq;

        @Generated
        Builder() {
        }

        @Generated
        public Builder function(@NotNull Identifier function) {
            if (function == null) {
                throw new NullPointerException("function is marked non-null but is null");
            }
            this.function = function;
            return this;
        }

        @Generated
        public Builder args(@NotNull List<Expr> args) {
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            this.args = args;
            return this;
        }

        @Generated
        public Builder setq(@Nullable SetQuantifier setq) {
            this.setq = setq;
            return this;
        }

        @Generated
        public ExprCall build() {
            return new ExprCall(this.function, this.args, this.setq);
        }

        @Generated
        public String toString() {
            return "ExprCall.Builder(function=" + this.function + ", args=" + this.args + ", setq=" + this.setq + ")";
        }
    }
}

