/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.expr;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.expr.Expr;

public final class ExprCase
extends Expr {
    @Nullable
    private final Expr expr;
    @NotNull
    private final List<Branch> branches;
    @Nullable
    private final Expr defaultExpr;

    public ExprCase(@Nullable Expr expr, @NotNull List<Branch> branches, @Nullable Expr defaultExpr) {
        this.expr = expr;
        this.branches = branches;
        this.defaultExpr = defaultExpr;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        if (this.expr != null) {
            kids.add(this.expr);
        }
        kids.addAll(this.branches);
        if (this.defaultExpr != null) {
            kids.add(this.defaultExpr);
        }
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitExprCase(this, ctx);
    }

    @Nullable
    public Expr getExpr() {
        return this.expr;
    }

    @NotNull
    public List<Branch> getBranches() {
        return this.branches;
    }

    @Nullable
    public Expr getDefaultExpr() {
        return this.defaultExpr;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExprCase)) {
            return false;
        }
        ExprCase other = (ExprCase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expr this$expr = this.getExpr();
        Expr other$expr = other.getExpr();
        if (this$expr == null ? other$expr != null : !((Object)this$expr).equals(other$expr)) {
            return false;
        }
        List<Branch> this$branches = this.getBranches();
        List<Branch> other$branches = other.getBranches();
        if (this$branches == null ? other$branches != null : !((Object)this$branches).equals(other$branches)) {
            return false;
        }
        Expr this$defaultExpr = this.getDefaultExpr();
        Expr other$defaultExpr = other.getDefaultExpr();
        return !(this$defaultExpr == null ? other$defaultExpr != null : !((Object)this$defaultExpr).equals(other$defaultExpr));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExprCase;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expr $expr = this.getExpr();
        result = result * 59 + ($expr == null ? 43 : ((Object)$expr).hashCode());
        List<Branch> $branches = this.getBranches();
        result = result * 59 + ($branches == null ? 43 : ((Object)$branches).hashCode());
        Expr $defaultExpr = this.getDefaultExpr();
        result = result * 59 + ($defaultExpr == null ? 43 : ((Object)$defaultExpr).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Expr expr;
        @Generated
        private List<Branch> branches;
        @Generated
        private Expr defaultExpr;

        @Generated
        Builder() {
        }

        @Generated
        public Builder expr(@Nullable Expr expr) {
            this.expr = expr;
            return this;
        }

        @Generated
        public Builder branches(@NotNull List<Branch> branches) {
            if (branches == null) {
                throw new NullPointerException("branches is marked non-null but is null");
            }
            this.branches = branches;
            return this;
        }

        @Generated
        public Builder defaultExpr(@Nullable Expr defaultExpr) {
            this.defaultExpr = defaultExpr;
            return this;
        }

        @Generated
        public ExprCase build() {
            return new ExprCase(this.expr, this.branches, this.defaultExpr);
        }

        @Generated
        public String toString() {
            return "ExprCase.Builder(expr=" + this.expr + ", branches=" + this.branches + ", defaultExpr=" + this.defaultExpr + ")";
        }
    }

    public static class Branch
    extends AstNode {
        @NotNull
        private final Expr condition;
        @NotNull
        private final Expr expr;

        public Branch(@NotNull Expr condition, @NotNull Expr expr) {
            this.condition = condition;
            this.expr = expr;
        }

        @Override
        @NotNull
        public List<AstNode> getChildren() {
            ArrayList<AstNode> kids = new ArrayList<AstNode>();
            kids.add(this.condition);
            kids.add(this.expr);
            return kids;
        }

        @Override
        public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
            return visitor.visitExprCaseBranch(this, ctx);
        }

        @NotNull
        public Expr getCondition() {
            return this.condition;
        }

        @NotNull
        public Expr getExpr() {
            return this.expr;
        }

        @Generated
        public static Builder builder() {
            return new Builder();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Branch)) {
                return false;
            }
            Branch other = (Branch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Expr this$condition = this.getCondition();
            Expr other$condition = other.getCondition();
            if (this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition)) {
                return false;
            }
            Expr this$expr = this.getExpr();
            Expr other$expr = other.getExpr();
            return !(this$expr == null ? other$expr != null : !((Object)this$expr).equals(other$expr));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Branch;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Expr $condition = this.getCondition();
            result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
            Expr $expr = this.getExpr();
            result = result * 59 + ($expr == null ? 43 : ((Object)$expr).hashCode());
            return result;
        }

        @Generated
        public static class Builder {
            @Generated
            private Expr condition;
            @Generated
            private Expr expr;

            @Generated
            Builder() {
            }

            @Generated
            public Builder condition(@NotNull Expr condition) {
                if (condition == null) {
                    throw new NullPointerException("condition is marked non-null but is null");
                }
                this.condition = condition;
                return this;
            }

            @Generated
            public Builder expr(@NotNull Expr expr) {
                if (expr == null) {
                    throw new NullPointerException("expr is marked non-null but is null");
                }
                this.expr = expr;
                return this;
            }

            @Generated
            public Branch build() {
                return new Branch(this.condition, this.expr);
            }

            @Generated
            public String toString() {
                return "ExprCase.Branch.Builder(condition=" + this.condition + ", expr=" + this.expr + ")";
            }
        }
    }
}

