/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.expr;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.DataType;
import org.partiql.ast.expr.Expr;

public final class ExprCast
extends Expr {
    @NotNull
    private final Expr value;
    @NotNull
    private final DataType asType;

    public ExprCast(@NotNull Expr value, @NotNull DataType asType) {
        this.value = value;
        this.asType = asType;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.value);
        kids.add(this.asType);
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitExprCast(this, ctx);
    }

    @NotNull
    public Expr getValue() {
        return this.value;
    }

    @NotNull
    public DataType getAsType() {
        return this.asType;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExprCast)) {
            return false;
        }
        ExprCast other = (ExprCast)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expr this$value = this.getValue();
        Expr other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        DataType this$asType = this.getAsType();
        DataType other$asType = other.getAsType();
        return !(this$asType == null ? other$asType != null : !((Object)this$asType).equals(other$asType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExprCast;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expr $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        DataType $asType = this.getAsType();
        result = result * 59 + ($asType == null ? 43 : ((Object)$asType).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Expr value;
        @Generated
        private DataType asType;

        @Generated
        Builder() {
        }

        @Generated
        public Builder value(@NotNull Expr value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
            return this;
        }

        @Generated
        public Builder asType(@NotNull DataType asType) {
            if (asType == null) {
                throw new NullPointerException("asType is marked non-null but is null");
            }
            this.asType = asType;
            return this;
        }

        @Generated
        public ExprCast build() {
            return new ExprCast(this.value, this.asType);
        }

        @Generated
        public String toString() {
            return "ExprCast.Builder(value=" + this.value + ", asType=" + this.asType + ")";
        }
    }
}

