/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.expr;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.expr.Expr;

public final class ExprLike
extends Expr {
    @NotNull
    private final Expr value;
    @NotNull
    private final Expr pattern;
    @Nullable
    private final Expr escape;
    private final boolean not;

    public ExprLike(@NotNull Expr value, @NotNull Expr pattern, @Nullable Expr escape, boolean not) {
        this.value = value;
        this.pattern = pattern;
        this.escape = escape;
        this.not = not;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.value);
        kids.add(this.pattern);
        if (this.escape != null) {
            kids.add(this.escape);
        }
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitExprLike(this, ctx);
    }

    @NotNull
    public Expr getValue() {
        return this.value;
    }

    @NotNull
    public Expr getPattern() {
        return this.pattern;
    }

    @Nullable
    public Expr getEscape() {
        return this.escape;
    }

    public boolean isNot() {
        return this.not;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExprLike)) {
            return false;
        }
        ExprLike other = (ExprLike)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNot() != other.isNot()) {
            return false;
        }
        Expr this$value = this.getValue();
        Expr other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Expr this$pattern = this.getPattern();
        Expr other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !((Object)this$pattern).equals(other$pattern)) {
            return false;
        }
        Expr this$escape = this.getEscape();
        Expr other$escape = other.getEscape();
        return !(this$escape == null ? other$escape != null : !((Object)this$escape).equals(other$escape));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExprLike;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNot() ? 79 : 97);
        Expr $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Expr $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : ((Object)$pattern).hashCode());
        Expr $escape = this.getEscape();
        result = result * 59 + ($escape == null ? 43 : ((Object)$escape).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Expr value;
        @Generated
        private Expr pattern;
        @Generated
        private Expr escape;
        @Generated
        private boolean not;

        @Generated
        Builder() {
        }

        @Generated
        public Builder value(@NotNull Expr value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
            return this;
        }

        @Generated
        public Builder pattern(@NotNull Expr pattern) {
            if (pattern == null) {
                throw new NullPointerException("pattern is marked non-null but is null");
            }
            this.pattern = pattern;
            return this;
        }

        @Generated
        public Builder escape(@Nullable Expr escape) {
            this.escape = escape;
            return this;
        }

        @Generated
        public Builder not(boolean not) {
            this.not = not;
            return this;
        }

        @Generated
        public ExprLike build() {
            return new ExprLike(this.value, this.pattern, this.escape, this.not);
        }

        @Generated
        public String toString() {
            return "ExprLike.Builder(value=" + this.value + ", pattern=" + this.pattern + ", escape=" + this.escape + ", not=" + this.not + ")";
        }
    }
}

