/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.expr;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.expr.Expr;
import org.partiql.ast.graph.GraphMatch;

public final class ExprMatch
extends Expr {
    @NotNull
    private final Expr expr;
    @NotNull
    private final GraphMatch pattern;

    public ExprMatch(@NotNull Expr expr, @NotNull GraphMatch pattern) {
        this.expr = expr;
        this.pattern = pattern;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.expr);
        kids.add(this.pattern);
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitExprMatch(this, ctx);
    }

    @NotNull
    public Expr getExpr() {
        return this.expr;
    }

    @NotNull
    public GraphMatch getPattern() {
        return this.pattern;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExprMatch)) {
            return false;
        }
        ExprMatch other = (ExprMatch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expr this$expr = this.getExpr();
        Expr other$expr = other.getExpr();
        if (this$expr == null ? other$expr != null : !((Object)this$expr).equals(other$expr)) {
            return false;
        }
        GraphMatch this$pattern = this.getPattern();
        GraphMatch other$pattern = other.getPattern();
        return !(this$pattern == null ? other$pattern != null : !((Object)this$pattern).equals(other$pattern));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExprMatch;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expr $expr = this.getExpr();
        result = result * 59 + ($expr == null ? 43 : ((Object)$expr).hashCode());
        GraphMatch $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : ((Object)$pattern).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Expr expr;
        @Generated
        private GraphMatch pattern;

        @Generated
        Builder() {
        }

        @Generated
        public Builder expr(@NotNull Expr expr) {
            if (expr == null) {
                throw new NullPointerException("expr is marked non-null but is null");
            }
            this.expr = expr;
            return this;
        }

        @Generated
        public Builder pattern(@NotNull GraphMatch pattern) {
            if (pattern == null) {
                throw new NullPointerException("pattern is marked non-null but is null");
            }
            this.pattern = pattern;
            return this;
        }

        @Generated
        public ExprMatch build() {
            return new ExprMatch(this.expr, this.pattern);
        }

        @Generated
        public String toString() {
            return "ExprMatch.Builder(expr=" + this.expr + ", pattern=" + this.pattern + ")";
        }
    }
}

