/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.expr;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.expr.Expr;

public final class ExprOperator
extends Expr {
    @NotNull
    private final String symbol;
    @Nullable
    private final Expr lhs;
    @NotNull
    private final Expr rhs;

    public ExprOperator(@NotNull String symbol, @Nullable Expr lhs, @NotNull Expr rhs) {
        this.symbol = symbol;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        if (this.lhs != null) {
            kids.add(this.lhs);
        }
        kids.add(this.rhs);
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitExprOperator(this, ctx);
    }

    @NotNull
    public String getSymbol() {
        return this.symbol;
    }

    @Nullable
    public Expr getLhs() {
        return this.lhs;
    }

    @NotNull
    public Expr getRhs() {
        return this.rhs;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExprOperator)) {
            return false;
        }
        ExprOperator other = (ExprOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        Expr this$lhs = this.getLhs();
        Expr other$lhs = other.getLhs();
        if (this$lhs == null ? other$lhs != null : !((Object)this$lhs).equals(other$lhs)) {
            return false;
        }
        Expr this$rhs = this.getRhs();
        Expr other$rhs = other.getRhs();
        return !(this$rhs == null ? other$rhs != null : !((Object)this$rhs).equals(other$rhs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExprOperator;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        Expr $lhs = this.getLhs();
        result = result * 59 + ($lhs == null ? 43 : ((Object)$lhs).hashCode());
        Expr $rhs = this.getRhs();
        result = result * 59 + ($rhs == null ? 43 : ((Object)$rhs).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private String symbol;
        @Generated
        private Expr lhs;
        @Generated
        private Expr rhs;

        @Generated
        Builder() {
        }

        @Generated
        public Builder symbol(@NotNull String symbol) {
            if (symbol == null) {
                throw new NullPointerException("symbol is marked non-null but is null");
            }
            this.symbol = symbol;
            return this;
        }

        @Generated
        public Builder lhs(@Nullable Expr lhs) {
            this.lhs = lhs;
            return this;
        }

        @Generated
        public Builder rhs(@NotNull Expr rhs) {
            if (rhs == null) {
                throw new NullPointerException("rhs is marked non-null but is null");
            }
            this.rhs = rhs;
            return this;
        }

        @Generated
        public ExprOperator build() {
            return new ExprOperator(this.symbol, this.lhs, this.rhs);
        }

        @Generated
        public String toString() {
            return "ExprOperator.Builder(symbol=" + this.symbol + ", lhs=" + this.lhs + ", rhs=" + this.rhs + ")";
        }
    }
}

