/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.expr;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.expr.Expr;

public final class ExprOverlay
extends Expr {
    @NotNull
    private final Expr value;
    @NotNull
    private final Expr placing;
    @NotNull
    private final Expr from;
    @Nullable
    private final Expr forLength;

    public ExprOverlay(@NotNull Expr value, @NotNull Expr placing, @NotNull Expr from, @Nullable Expr forLength) {
        this.value = value;
        this.placing = placing;
        this.from = from;
        this.forLength = forLength;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.value);
        kids.add(this.placing);
        kids.add(this.from);
        if (this.forLength != null) {
            kids.add(this.forLength);
        }
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitExprOverlay(this, ctx);
    }

    @NotNull
    public Expr getValue() {
        return this.value;
    }

    @NotNull
    public Expr getPlacing() {
        return this.placing;
    }

    @NotNull
    public Expr getFrom() {
        return this.from;
    }

    @Nullable
    public Expr getForLength() {
        return this.forLength;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExprOverlay)) {
            return false;
        }
        ExprOverlay other = (ExprOverlay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expr this$value = this.getValue();
        Expr other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Expr this$placing = this.getPlacing();
        Expr other$placing = other.getPlacing();
        if (this$placing == null ? other$placing != null : !((Object)this$placing).equals(other$placing)) {
            return false;
        }
        Expr this$from = this.getFrom();
        Expr other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Expr this$forLength = this.getForLength();
        Expr other$forLength = other.getForLength();
        return !(this$forLength == null ? other$forLength != null : !((Object)this$forLength).equals(other$forLength));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExprOverlay;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expr $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Expr $placing = this.getPlacing();
        result = result * 59 + ($placing == null ? 43 : ((Object)$placing).hashCode());
        Expr $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Expr $forLength = this.getForLength();
        result = result * 59 + ($forLength == null ? 43 : ((Object)$forLength).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Expr value;
        @Generated
        private Expr placing;
        @Generated
        private Expr from;
        @Generated
        private Expr forLength;

        @Generated
        Builder() {
        }

        @Generated
        public Builder value(@NotNull Expr value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
            return this;
        }

        @Generated
        public Builder placing(@NotNull Expr placing) {
            if (placing == null) {
                throw new NullPointerException("placing is marked non-null but is null");
            }
            this.placing = placing;
            return this;
        }

        @Generated
        public Builder from(@NotNull Expr from) {
            if (from == null) {
                throw new NullPointerException("from is marked non-null but is null");
            }
            this.from = from;
            return this;
        }

        @Generated
        public Builder forLength(@Nullable Expr forLength) {
            this.forLength = forLength;
            return this;
        }

        @Generated
        public ExprOverlay build() {
            return new ExprOverlay(this.value, this.placing, this.from, this.forLength);
        }

        @Generated
        public String toString() {
            return "ExprOverlay.Builder(value=" + this.value + ", placing=" + this.placing + ", from=" + this.from + ", forLength=" + this.forLength + ")";
        }
    }
}

