/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.expr;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.expr.Expr;
import org.partiql.ast.expr.PathStep;

public final class ExprPath
extends Expr {
    @NotNull
    private final Expr root;
    @NotNull
    private final List<PathStep> steps;

    public ExprPath(@NotNull Expr root, @NotNull List<PathStep> steps) {
        this.root = root;
        this.steps = steps;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.root);
        kids.addAll(this.steps);
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitExprPath(this, ctx);
    }

    @NotNull
    public Expr getRoot() {
        return this.root;
    }

    @NotNull
    public List<PathStep> getSteps() {
        return this.steps;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExprPath)) {
            return false;
        }
        ExprPath other = (ExprPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expr this$root = this.getRoot();
        Expr other$root = other.getRoot();
        if (this$root == null ? other$root != null : !((Object)this$root).equals(other$root)) {
            return false;
        }
        List<PathStep> this$steps = this.getSteps();
        List<PathStep> other$steps = other.getSteps();
        return !(this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExprPath;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expr $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : ((Object)$root).hashCode());
        List<PathStep> $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Expr root;
        @Generated
        private List<PathStep> steps;

        @Generated
        Builder() {
        }

        @Generated
        public Builder root(@NotNull Expr root) {
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            this.root = root;
            return this;
        }

        @Generated
        public Builder steps(@NotNull List<PathStep> steps) {
            if (steps == null) {
                throw new NullPointerException("steps is marked non-null but is null");
            }
            this.steps = steps;
            return this;
        }

        @Generated
        public ExprPath build() {
            return new ExprPath(this.root, this.steps);
        }

        @Generated
        public String toString() {
            return "ExprPath.Builder(root=" + this.root + ", steps=" + this.steps + ")";
        }
    }
}

