/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.expr;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.OrderBy;
import org.partiql.ast.QueryBody;
import org.partiql.ast.With;
import org.partiql.ast.expr.Expr;

public final class ExprQuerySet
extends Expr {
    @NotNull
    private final QueryBody body;
    @Nullable
    private final OrderBy orderBy;
    @Nullable
    private final Expr limit;
    @Nullable
    private final Expr offset;
    @Nullable
    private final With with;

    public ExprQuerySet(@NotNull QueryBody body, @Nullable OrderBy orderBy, @Nullable Expr limit, @Nullable Expr offset) {
        this.body = body;
        this.orderBy = orderBy;
        this.limit = limit;
        this.offset = offset;
        this.with = null;
    }

    public ExprQuerySet(@NotNull QueryBody body, @Nullable OrderBy orderBy, @Nullable Expr limit, @Nullable Expr offset, @Nullable With with) {
        this.body = body;
        this.orderBy = orderBy;
        this.limit = limit;
        this.offset = offset;
        this.with = with;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.body);
        if (this.orderBy != null) {
            kids.add(this.orderBy);
        }
        if (this.limit != null) {
            kids.add(this.limit);
        }
        if (this.offset != null) {
            kids.add(this.offset);
        }
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitExprQuerySet(this, ctx);
    }

    @Nullable
    public With getWith() {
        return this.with;
    }

    @NotNull
    public QueryBody getBody() {
        return this.body;
    }

    @Nullable
    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    @Nullable
    public Expr getLimit() {
        return this.limit;
    }

    @Nullable
    public Expr getOffset() {
        return this.offset;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExprQuerySet)) {
            return false;
        }
        ExprQuerySet other = (ExprQuerySet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QueryBody this$body = this.getBody();
        QueryBody other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        OrderBy this$orderBy = this.getOrderBy();
        OrderBy other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !((Object)this$orderBy).equals(other$orderBy)) {
            return false;
        }
        Expr this$limit = this.getLimit();
        Expr other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Expr this$offset = this.getOffset();
        Expr other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        With this$with = this.getWith();
        With other$with = other.getWith();
        return !(this$with == null ? other$with != null : !((Object)this$with).equals(other$with));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExprQuerySet;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QueryBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        OrderBy $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : ((Object)$orderBy).hashCode());
        Expr $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Expr $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        With $with = this.getWith();
        result = result * 59 + ($with == null ? 43 : ((Object)$with).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private QueryBody body;
        @Generated
        private OrderBy orderBy;
        @Generated
        private Expr limit;
        @Generated
        private Expr offset;
        @Generated
        private With with;

        @Generated
        Builder() {
        }

        @Generated
        public Builder body(@NotNull QueryBody body) {
            if (body == null) {
                throw new NullPointerException("body is marked non-null but is null");
            }
            this.body = body;
            return this;
        }

        @Generated
        public Builder orderBy(@Nullable OrderBy orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Generated
        public Builder limit(@Nullable Expr limit) {
            this.limit = limit;
            return this;
        }

        @Generated
        public Builder offset(@Nullable Expr offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public Builder with(@Nullable With with) {
            this.with = with;
            return this;
        }

        @Generated
        public ExprQuerySet build() {
            return new ExprQuerySet(this.body, this.orderBy, this.limit, this.offset, this.with);
        }

        @Generated
        public String toString() {
            return "ExprQuerySet.Builder(body=" + this.body + ", orderBy=" + this.orderBy + ", limit=" + this.limit + ", offset=" + this.offset + ", with=" + this.with + ")";
        }
    }
}

