/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.expr;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.Sort;
import org.partiql.ast.expr.Expr;
import org.partiql.ast.expr.WindowFunction;

public final class ExprWindow
extends Expr {
    @NotNull
    private final WindowFunction windowFunction;
    @NotNull
    private final Expr expression;
    @Nullable
    private final Expr offset;
    @Nullable
    private final Expr defaultValue;
    @NotNull
    private final Over over;

    public ExprWindow(@NotNull WindowFunction windowFunction, @NotNull Expr expression, @Nullable Expr offset, @Nullable Expr defaultValue, @NotNull Over over) {
        this.windowFunction = windowFunction;
        this.expression = expression;
        this.offset = offset;
        this.defaultValue = defaultValue;
        this.over = over;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.expression);
        if (this.offset != null) {
            kids.add(this.offset);
        }
        if (this.defaultValue != null) {
            kids.add(this.defaultValue);
        }
        kids.add(this.over);
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitExprWindow(this, ctx);
    }

    @NotNull
    public WindowFunction getWindowFunction() {
        return this.windowFunction;
    }

    @NotNull
    public Expr getExpression() {
        return this.expression;
    }

    @Nullable
    public Expr getOffset() {
        return this.offset;
    }

    @Nullable
    public Expr getDefaultValue() {
        return this.defaultValue;
    }

    @NotNull
    public Over getOver() {
        return this.over;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExprWindow)) {
            return false;
        }
        ExprWindow other = (ExprWindow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WindowFunction this$windowFunction = this.getWindowFunction();
        WindowFunction other$windowFunction = other.getWindowFunction();
        if (this$windowFunction == null ? other$windowFunction != null : !((Object)this$windowFunction).equals(other$windowFunction)) {
            return false;
        }
        Expr this$expression = this.getExpression();
        Expr other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !((Object)this$expression).equals(other$expression)) {
            return false;
        }
        Expr this$offset = this.getOffset();
        Expr other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Expr this$defaultValue = this.getDefaultValue();
        Expr other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !((Object)this$defaultValue).equals(other$defaultValue)) {
            return false;
        }
        Over this$over = this.getOver();
        Over other$over = other.getOver();
        return !(this$over == null ? other$over != null : !((Object)this$over).equals(other$over));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExprWindow;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WindowFunction $windowFunction = this.getWindowFunction();
        result = result * 59 + ($windowFunction == null ? 43 : ((Object)$windowFunction).hashCode());
        Expr $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : ((Object)$expression).hashCode());
        Expr $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Expr $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : ((Object)$defaultValue).hashCode());
        Over $over = this.getOver();
        result = result * 59 + ($over == null ? 43 : ((Object)$over).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private WindowFunction windowFunction;
        @Generated
        private Expr expression;
        @Generated
        private Expr offset;
        @Generated
        private Expr defaultValue;
        @Generated
        private Over over;

        @Generated
        Builder() {
        }

        @Generated
        public Builder windowFunction(@NotNull WindowFunction windowFunction) {
            if (windowFunction == null) {
                throw new NullPointerException("windowFunction is marked non-null but is null");
            }
            this.windowFunction = windowFunction;
            return this;
        }

        @Generated
        public Builder expression(@NotNull Expr expression) {
            if (expression == null) {
                throw new NullPointerException("expression is marked non-null but is null");
            }
            this.expression = expression;
            return this;
        }

        @Generated
        public Builder offset(@Nullable Expr offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public Builder defaultValue(@Nullable Expr defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Generated
        public Builder over(@NotNull Over over) {
            if (over == null) {
                throw new NullPointerException("over is marked non-null but is null");
            }
            this.over = over;
            return this;
        }

        @Generated
        public ExprWindow build() {
            return new ExprWindow(this.windowFunction, this.expression, this.offset, this.defaultValue, this.over);
        }

        @Generated
        public String toString() {
            return "ExprWindow.Builder(windowFunction=" + this.windowFunction + ", expression=" + this.expression + ", offset=" + this.offset + ", defaultValue=" + this.defaultValue + ", over=" + this.over + ")";
        }
    }

    public static class Over
    extends AstNode {
        @NotNull
        private final List<Expr> partitions;
        @NotNull
        private final List<Sort> sorts;

        public Over(@NotNull List<Expr> partitions, @NotNull List<Sort> sorts) {
            this.partitions = partitions;
            this.sorts = sorts;
        }

        @Override
        @NotNull
        public List<AstNode> getChildren() {
            ArrayList<AstNode> kids = new ArrayList<AstNode>();
            kids.addAll(this.partitions);
            kids.addAll(this.sorts);
            return kids;
        }

        @Override
        public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
            return visitor.visitExprWindowOver(this, ctx);
        }

        @NotNull
        public List<Expr> getPartitions() {
            return this.partitions;
        }

        @NotNull
        public List<Sort> getSorts() {
            return this.sorts;
        }

        @Generated
        public static Builder builder() {
            return new Builder();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Over)) {
                return false;
            }
            Over other = (Over)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Expr> this$partitions = this.getPartitions();
            List<Expr> other$partitions = other.getPartitions();
            if (this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions)) {
                return false;
            }
            List<Sort> this$sorts = this.getSorts();
            List<Sort> other$sorts = other.getSorts();
            return !(this$sorts == null ? other$sorts != null : !((Object)this$sorts).equals(other$sorts));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Over;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Expr> $partitions = this.getPartitions();
            result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
            List<Sort> $sorts = this.getSorts();
            result = result * 59 + ($sorts == null ? 43 : ((Object)$sorts).hashCode());
            return result;
        }

        @Generated
        public static class Builder {
            @Generated
            private List<Expr> partitions;
            @Generated
            private List<Sort> sorts;

            @Generated
            Builder() {
            }

            @Generated
            public Builder partitions(@NotNull List<Expr> partitions) {
                if (partitions == null) {
                    throw new NullPointerException("partitions is marked non-null but is null");
                }
                this.partitions = partitions;
                return this;
            }

            @Generated
            public Builder sorts(@NotNull List<Sort> sorts) {
                if (sorts == null) {
                    throw new NullPointerException("sorts is marked non-null but is null");
                }
                this.sorts = sorts;
                return this;
            }

            @Generated
            public Over build() {
                return new Over(this.partitions, this.sorts);
            }

            @Generated
            public String toString() {
                return "ExprWindow.Over.Builder(partitions=" + this.partitions + ", sorts=" + this.sorts + ")";
            }
        }
    }
}

