/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.expr;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstEnum;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;

public final class TrimSpec
extends AstEnum {
    public static final int LEADING = 0;
    public static final int TRAILING = 1;
    public static final int BOTH = 2;
    private final int code;
    @NotNull
    private static final int[] codes = new int[]{0, 1, 2};

    public static TrimSpec LEADING() {
        return new TrimSpec(0);
    }

    public static TrimSpec TRAILING() {
        return new TrimSpec(1);
    }

    public static TrimSpec BOTH() {
        return new TrimSpec(2);
    }

    private TrimSpec(int code) {
        this.code = code;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    @NotNull
    public String name() {
        switch (this.code) {
            case 0: {
                return "LEADING";
            }
            case 1: {
                return "TRAILING";
            }
            case 2: {
                return "BOTH";
            }
        }
        throw new IllegalStateException("Invalid TrimSpec code: " + this.code);
    }

    @NotNull
    public static TrimSpec parse(@NotNull String value) {
        switch (value) {
            case "LEADING": {
                return TrimSpec.LEADING();
            }
            case "TRAILING": {
                return TrimSpec.TRAILING();
            }
            case "BOTH": {
                return TrimSpec.BOTH();
            }
        }
        throw new IllegalArgumentException("No enum constant TrimSpec." + value);
    }

    @NotNull
    public static int[] codes() {
        return codes;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrimSpec)) {
            return false;
        }
        TrimSpec other = (TrimSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.code == other.code;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TrimSpec;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code;
        return result;
    }
}

