/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.expr;

import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstEnum;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;

public final class TruthValue
extends AstEnum {
    public static final int TRUE = 0;
    public static final int FALSE = 1;
    public static final int UNKNOWN = 2;
    private final int code;

    public TruthValue(int code) {
        this.code = code;
    }

    public static TruthValue TRUE() {
        return new TruthValue(0);
    }

    public static TruthValue FALSE() {
        return new TruthValue(1);
    }

    public static TruthValue UNKNOWN() {
        return new TruthValue(2);
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    @NotNull
    public String name() {
        switch (this.code) {
            case 0: {
                return "TRUE";
            }
            case 1: {
                return "FALSE";
            }
            case 2: {
                return "UNKNOWN";
            }
        }
        throw new IllegalStateException("Invalid TruthValue code: " + this.code);
    }

    @NotNull
    public static TruthValue parse(@NotNull String value) {
        switch (value) {
            case "TRUE": {
                return TruthValue.TRUE();
            }
            case "FALSE": {
                return TruthValue.FALSE();
            }
            case "UNK": {
                return TruthValue.UNKNOWN();
            }
        }
        throw new IllegalArgumentException("No enum constant TruthValue." + value);
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        return List.of();
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TruthValue)) {
            return false;
        }
        TruthValue other = (TruthValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.code == other.code;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TruthValue;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code;
        return result;
    }
}

