/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.expr;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstEnum;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;

public final class WindowFunction
extends AstEnum {
    public static final int LAG = 0;
    public static final int LEAD = 1;
    private final int code;
    @NotNull
    private static final int[] codes = new int[]{0, 1};

    public static WindowFunction LAG() {
        return new WindowFunction(0);
    }

    public static WindowFunction LEAD() {
        return new WindowFunction(1);
    }

    public WindowFunction(int code) {
        this.code = code;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    @NotNull
    public String name() {
        switch (this.code) {
            case 0: {
                return "LAG";
            }
            case 1: {
                return "LEAD";
            }
        }
        throw new IllegalStateException("Invalid WindowFunction code: " + this.code);
    }

    @NotNull
    public static WindowFunction parse(@NotNull String value) {
        switch (value) {
            case "LAG": {
                return WindowFunction.LAG();
            }
            case "LEAD": {
                return WindowFunction.LEAD();
            }
        }
        throw new IllegalArgumentException("No enum constant WindowFunction." + value);
    }

    @NotNull
    public static int[] codes() {
        return codes;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WindowFunction)) {
            return false;
        }
        WindowFunction other = (WindowFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.code == other.code;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WindowFunction;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code;
        return result;
    }
}

