/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.graph;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstEnum;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;

public final class GraphDirection
extends AstEnum {
    public static final int LEFT = 0;
    public static final int UNDIRECTED = 1;
    public static final int RIGHT = 2;
    public static final int LEFT_OR_UNDIRECTED = 3;
    public static final int UNDIRECTED_OR_RIGHT = 4;
    public static final int LEFT_OR_RIGHT = 5;
    public static final int LEFT_UNDIRECTED_OR_RIGHT = 6;
    private final int code;
    @NotNull
    private static final int[] codes = new int[]{0, 1, 2, 3, 4, 5, 6};

    public static GraphDirection LEFT() {
        return new GraphDirection(0);
    }

    public static GraphDirection UNDIRECTED() {
        return new GraphDirection(1);
    }

    public static GraphDirection RIGHT() {
        return new GraphDirection(2);
    }

    public static GraphDirection LEFT_OR_UNDIRECTED() {
        return new GraphDirection(3);
    }

    public static GraphDirection UNDIRECTED_OR_RIGHT() {
        return new GraphDirection(4);
    }

    public static GraphDirection LEFT_OR_RIGHT() {
        return new GraphDirection(5);
    }

    public static GraphDirection LEFT_UNDIRECTED_OR_RIGHT() {
        return new GraphDirection(6);
    }

    private GraphDirection(int code) {
        this.code = code;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    @NotNull
    public String name() {
        switch (this.code) {
            case 0: {
                return "LEFT";
            }
            case 1: {
                return "UNDIRECTED";
            }
            case 2: {
                return "RIGHT";
            }
            case 3: {
                return "LEFT_OR_UNDIRECTED";
            }
            case 4: {
                return "UNDIRECTED_OR_RIGHT";
            }
            case 5: {
                return "LEFT_OR_RIGHT";
            }
            case 6: {
                return "LEFT_UNDIRECTED_OR_RIGHT";
            }
        }
        throw new IllegalStateException("Invalid GraphDirection code: " + this.code);
    }

    @NotNull
    public static GraphDirection parse(@NotNull String value) {
        switch (value) {
            case "LEFT": {
                return GraphDirection.LEFT();
            }
            case "UNDIRECTED": {
                return GraphDirection.UNDIRECTED();
            }
            case "RIGHT": {
                return GraphDirection.RIGHT();
            }
            case "LEFT_OR_UNDIRECTED": {
                return GraphDirection.LEFT_OR_UNDIRECTED();
            }
            case "UNDIRECTED_OR_RIGHT": {
                return GraphDirection.UNDIRECTED_OR_RIGHT();
            }
            case "LEFT_OR_RIGHT": {
                return GraphDirection.LEFT_OR_RIGHT();
            }
            case "LEFT_UNDIRECTED_OR_RIGHT": {
                return GraphDirection.LEFT_UNDIRECTED_OR_RIGHT();
            }
        }
        throw new IllegalArgumentException("No enum constant GraphDirection." + value);
    }

    @NotNull
    public static int[] codes() {
        return codes;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphDirection)) {
            return false;
        }
        GraphDirection other = (GraphDirection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.code == other.code;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GraphDirection;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code;
        return result;
    }
}

