/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.graph;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.graph.GraphPattern;
import org.partiql.ast.graph.GraphSelector;

public final class GraphMatch
extends AstNode {
    @NotNull
    private final List<GraphPattern> patterns;
    @Nullable
    private final GraphSelector selector;

    public GraphMatch(@NotNull List<GraphPattern> patterns, @Nullable GraphSelector selector) {
        this.patterns = patterns;
        this.selector = selector;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>(this.patterns);
        if (this.selector != null) {
            kids.add(this.selector);
        }
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitGraphMatch(this, ctx);
    }

    @NotNull
    public List<GraphPattern> getPatterns() {
        return this.patterns;
    }

    @Nullable
    public GraphSelector getSelector() {
        return this.selector;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphMatch)) {
            return false;
        }
        GraphMatch other = (GraphMatch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<GraphPattern> this$patterns = this.getPatterns();
        List<GraphPattern> other$patterns = other.getPatterns();
        if (this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns)) {
            return false;
        }
        GraphSelector this$selector = this.getSelector();
        GraphSelector other$selector = other.getSelector();
        return !(this$selector == null ? other$selector != null : !((Object)this$selector).equals(other$selector));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GraphMatch;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<GraphPattern> $patterns = this.getPatterns();
        result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
        GraphSelector $selector = this.getSelector();
        result = result * 59 + ($selector == null ? 43 : ((Object)$selector).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private List<GraphPattern> patterns;
        @Generated
        private GraphSelector selector;

        @Generated
        Builder() {
        }

        @Generated
        public Builder patterns(@NotNull List<GraphPattern> patterns) {
            if (patterns == null) {
                throw new NullPointerException("patterns is marked non-null but is null");
            }
            this.patterns = patterns;
            return this;
        }

        @Generated
        public Builder selector(@Nullable GraphSelector selector) {
            this.selector = selector;
            return this;
        }

        @Generated
        public GraphMatch build() {
            return new GraphMatch(this.patterns, this.selector);
        }

        @Generated
        public String toString() {
            return "GraphMatch.Builder(patterns=" + this.patterns + ", selector=" + this.selector + ")";
        }
    }
}

