/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.graph;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.expr.Expr;
import org.partiql.ast.graph.GraphDirection;
import org.partiql.ast.graph.GraphLabel;
import org.partiql.ast.graph.GraphPattern;
import org.partiql.ast.graph.GraphQuantifier;

public abstract class GraphPart
extends AstNode {

    public static class Pattern
    extends GraphPart {
        @NotNull
        private final GraphPattern pattern;

        public Pattern(@NotNull GraphPattern pattern) {
            this.pattern = pattern;
        }

        @Override
        @NotNull
        public List<AstNode> getChildren() {
            ArrayList<AstNode> kids = new ArrayList<AstNode>();
            kids.add(this.pattern);
            return kids;
        }

        @Override
        public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
            return visitor.visitGraphPartPattern(this, ctx);
        }

        @NotNull
        public GraphPattern getPattern() {
            return this.pattern;
        }

        @Generated
        public static Builder builder() {
            return new Builder();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pattern)) {
                return false;
            }
            Pattern other = (Pattern)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GraphPattern this$pattern = this.getPattern();
            GraphPattern other$pattern = other.getPattern();
            return !(this$pattern == null ? other$pattern != null : !((Object)this$pattern).equals(other$pattern));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Pattern;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GraphPattern $pattern = this.getPattern();
            result = result * 59 + ($pattern == null ? 43 : ((Object)$pattern).hashCode());
            return result;
        }

        @Generated
        public static class Builder {
            @Generated
            private GraphPattern pattern;

            @Generated
            Builder() {
            }

            @Generated
            public Builder pattern(@NotNull GraphPattern pattern) {
                if (pattern == null) {
                    throw new NullPointerException("pattern is marked non-null but is null");
                }
                this.pattern = pattern;
                return this;
            }

            @Generated
            public Pattern build() {
                return new Pattern(this.pattern);
            }

            @Generated
            public String toString() {
                return "GraphPart.Pattern.Builder(pattern=" + this.pattern + ")";
            }
        }
    }

    public static class Edge
    extends GraphPart {
        @NotNull
        private final GraphDirection direction;
        @Nullable
        private final GraphQuantifier quantifier;
        @Nullable
        private final Expr prefilter;
        @Nullable
        private final String variable;
        @Nullable
        private final GraphLabel label;

        public Edge(@NotNull GraphDirection direction, @Nullable GraphQuantifier quantifier, @Nullable Expr prefilter, @Nullable String variable, @Nullable GraphLabel label) {
            this.direction = direction;
            this.quantifier = quantifier;
            this.prefilter = prefilter;
            this.variable = variable;
            this.label = label;
        }

        @Override
        @NotNull
        public List<AstNode> getChildren() {
            ArrayList<AstNode> kids = new ArrayList<AstNode>();
            if (this.quantifier != null) {
                kids.add(this.quantifier);
            }
            if (this.prefilter != null) {
                kids.add(this.prefilter);
            }
            if (this.label != null) {
                kids.add(this.label);
            }
            return kids;
        }

        @Override
        public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
            return visitor.visitGraphPartEdge(this, ctx);
        }

        @NotNull
        public GraphDirection getDirection() {
            return this.direction;
        }

        @Nullable
        public GraphQuantifier getQuantifier() {
            return this.quantifier;
        }

        @Nullable
        public Expr getPrefilter() {
            return this.prefilter;
        }

        @Nullable
        public String getVariable() {
            return this.variable;
        }

        @Nullable
        public GraphLabel getLabel() {
            return this.label;
        }

        @Generated
        public static Builder builder() {
            return new Builder();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Edge)) {
                return false;
            }
            Edge other = (Edge)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GraphDirection this$direction = this.getDirection();
            GraphDirection other$direction = other.getDirection();
            if (this$direction == null ? other$direction != null : !((Object)this$direction).equals(other$direction)) {
                return false;
            }
            GraphQuantifier this$quantifier = this.getQuantifier();
            GraphQuantifier other$quantifier = other.getQuantifier();
            if (this$quantifier == null ? other$quantifier != null : !((Object)this$quantifier).equals(other$quantifier)) {
                return false;
            }
            Expr this$prefilter = this.getPrefilter();
            Expr other$prefilter = other.getPrefilter();
            if (this$prefilter == null ? other$prefilter != null : !((Object)this$prefilter).equals(other$prefilter)) {
                return false;
            }
            String this$variable = this.getVariable();
            String other$variable = other.getVariable();
            if (this$variable == null ? other$variable != null : !this$variable.equals(other$variable)) {
                return false;
            }
            GraphLabel this$label = this.getLabel();
            GraphLabel other$label = other.getLabel();
            return !(this$label == null ? other$label != null : !((Object)this$label).equals(other$label));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Edge;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GraphDirection $direction = this.getDirection();
            result = result * 59 + ($direction == null ? 43 : ((Object)$direction).hashCode());
            GraphQuantifier $quantifier = this.getQuantifier();
            result = result * 59 + ($quantifier == null ? 43 : ((Object)$quantifier).hashCode());
            Expr $prefilter = this.getPrefilter();
            result = result * 59 + ($prefilter == null ? 43 : ((Object)$prefilter).hashCode());
            String $variable = this.getVariable();
            result = result * 59 + ($variable == null ? 43 : $variable.hashCode());
            GraphLabel $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
            return result;
        }

        @Generated
        public static class Builder {
            @Generated
            private GraphDirection direction;
            @Generated
            private GraphQuantifier quantifier;
            @Generated
            private Expr prefilter;
            @Generated
            private String variable;
            @Generated
            private GraphLabel label;

            @Generated
            Builder() {
            }

            @Generated
            public Builder direction(@NotNull GraphDirection direction) {
                if (direction == null) {
                    throw new NullPointerException("direction is marked non-null but is null");
                }
                this.direction = direction;
                return this;
            }

            @Generated
            public Builder quantifier(@Nullable GraphQuantifier quantifier) {
                this.quantifier = quantifier;
                return this;
            }

            @Generated
            public Builder prefilter(@Nullable Expr prefilter) {
                this.prefilter = prefilter;
                return this;
            }

            @Generated
            public Builder variable(@Nullable String variable) {
                this.variable = variable;
                return this;
            }

            @Generated
            public Builder label(@Nullable GraphLabel label) {
                this.label = label;
                return this;
            }

            @Generated
            public Edge build() {
                return new Edge(this.direction, this.quantifier, this.prefilter, this.variable, this.label);
            }

            @Generated
            public String toString() {
                return "GraphPart.Edge.Builder(direction=" + this.direction + ", quantifier=" + this.quantifier + ", prefilter=" + this.prefilter + ", variable=" + this.variable + ", label=" + this.label + ")";
            }
        }
    }

    public static class Node
    extends GraphPart {
        @Nullable
        private final Expr prefilter;
        @Nullable
        private final String variable;
        @Nullable
        private final GraphLabel label;

        public Node(@Nullable Expr prefilter, @Nullable String variable, @Nullable GraphLabel label) {
            this.prefilter = prefilter;
            this.variable = variable;
            this.label = label;
        }

        @Override
        @NotNull
        public List<AstNode> getChildren() {
            ArrayList<AstNode> kids = new ArrayList<AstNode>();
            if (this.prefilter != null) {
                kids.add(this.prefilter);
            }
            if (this.label != null) {
                kids.add(this.label);
            }
            return kids;
        }

        @Override
        public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
            return visitor.visitGraphPartNode(this, ctx);
        }

        @Nullable
        public Expr getPrefilter() {
            return this.prefilter;
        }

        @Nullable
        public String getVariable() {
            return this.variable;
        }

        @Nullable
        public GraphLabel getLabel() {
            return this.label;
        }

        @Generated
        public static Builder builder() {
            return new Builder();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Expr this$prefilter = this.getPrefilter();
            Expr other$prefilter = other.getPrefilter();
            if (this$prefilter == null ? other$prefilter != null : !((Object)this$prefilter).equals(other$prefilter)) {
                return false;
            }
            String this$variable = this.getVariable();
            String other$variable = other.getVariable();
            if (this$variable == null ? other$variable != null : !this$variable.equals(other$variable)) {
                return false;
            }
            GraphLabel this$label = this.getLabel();
            GraphLabel other$label = other.getLabel();
            return !(this$label == null ? other$label != null : !((Object)this$label).equals(other$label));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Node;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Expr $prefilter = this.getPrefilter();
            result = result * 59 + ($prefilter == null ? 43 : ((Object)$prefilter).hashCode());
            String $variable = this.getVariable();
            result = result * 59 + ($variable == null ? 43 : $variable.hashCode());
            GraphLabel $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
            return result;
        }

        @Generated
        public static class Builder {
            @Generated
            private Expr prefilter;
            @Generated
            private String variable;
            @Generated
            private GraphLabel label;

            @Generated
            Builder() {
            }

            @Generated
            public Builder prefilter(@Nullable Expr prefilter) {
                this.prefilter = prefilter;
                return this;
            }

            @Generated
            public Builder variable(@Nullable String variable) {
                this.variable = variable;
                return this;
            }

            @Generated
            public Builder label(@Nullable GraphLabel label) {
                this.label = label;
                return this;
            }

            @Generated
            public Node build() {
                return new Node(this.prefilter, this.variable, this.label);
            }

            @Generated
            public String toString() {
                return "GraphPart.Node.Builder(prefilter=" + this.prefilter + ", variable=" + this.variable + ", label=" + this.label + ")";
            }
        }
    }
}

