/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.graph;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.expr.Expr;
import org.partiql.ast.graph.GraphPart;
import org.partiql.ast.graph.GraphQuantifier;
import org.partiql.ast.graph.GraphRestrictor;

public final class GraphPattern
extends AstNode {
    @Nullable
    private final GraphRestrictor restrictor;
    @Nullable
    private final Expr prefilter;
    @Nullable
    private final String variable;
    @Nullable
    private final GraphQuantifier quantifier;
    @NotNull
    private final List<GraphPart> parts;

    public GraphPattern(@Nullable GraphRestrictor restrictor, @Nullable Expr prefilter, @Nullable String variable, @Nullable GraphQuantifier quantifier, @NotNull List<GraphPart> parts) {
        this.restrictor = restrictor;
        this.prefilter = prefilter;
        this.variable = variable;
        this.quantifier = quantifier;
        this.parts = parts;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        if (this.prefilter != null) {
            kids.add(this.prefilter);
        }
        if (this.quantifier != null) {
            kids.add(this.quantifier);
        }
        kids.addAll(this.parts);
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitGraphPattern(this, ctx);
    }

    @Nullable
    public GraphRestrictor getRestrictor() {
        return this.restrictor;
    }

    @Nullable
    public Expr getPrefilter() {
        return this.prefilter;
    }

    @Nullable
    public String getVariable() {
        return this.variable;
    }

    @Nullable
    public GraphQuantifier getQuantifier() {
        return this.quantifier;
    }

    @NotNull
    public List<GraphPart> getParts() {
        return this.parts;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphPattern)) {
            return false;
        }
        GraphPattern other = (GraphPattern)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GraphRestrictor this$restrictor = this.getRestrictor();
        GraphRestrictor other$restrictor = other.getRestrictor();
        if (this$restrictor == null ? other$restrictor != null : !((Object)this$restrictor).equals(other$restrictor)) {
            return false;
        }
        Expr this$prefilter = this.getPrefilter();
        Expr other$prefilter = other.getPrefilter();
        if (this$prefilter == null ? other$prefilter != null : !((Object)this$prefilter).equals(other$prefilter)) {
            return false;
        }
        String this$variable = this.getVariable();
        String other$variable = other.getVariable();
        if (this$variable == null ? other$variable != null : !this$variable.equals(other$variable)) {
            return false;
        }
        GraphQuantifier this$quantifier = this.getQuantifier();
        GraphQuantifier other$quantifier = other.getQuantifier();
        if (this$quantifier == null ? other$quantifier != null : !((Object)this$quantifier).equals(other$quantifier)) {
            return false;
        }
        List<GraphPart> this$parts = this.getParts();
        List<GraphPart> other$parts = other.getParts();
        return !(this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GraphPattern;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GraphRestrictor $restrictor = this.getRestrictor();
        result = result * 59 + ($restrictor == null ? 43 : ((Object)$restrictor).hashCode());
        Expr $prefilter = this.getPrefilter();
        result = result * 59 + ($prefilter == null ? 43 : ((Object)$prefilter).hashCode());
        String $variable = this.getVariable();
        result = result * 59 + ($variable == null ? 43 : $variable.hashCode());
        GraphQuantifier $quantifier = this.getQuantifier();
        result = result * 59 + ($quantifier == null ? 43 : ((Object)$quantifier).hashCode());
        List<GraphPart> $parts = this.getParts();
        result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private GraphRestrictor restrictor;
        @Generated
        private Expr prefilter;
        @Generated
        private String variable;
        @Generated
        private GraphQuantifier quantifier;
        @Generated
        private List<GraphPart> parts;

        @Generated
        Builder() {
        }

        @Generated
        public Builder restrictor(@Nullable GraphRestrictor restrictor) {
            this.restrictor = restrictor;
            return this;
        }

        @Generated
        public Builder prefilter(@Nullable Expr prefilter) {
            this.prefilter = prefilter;
            return this;
        }

        @Generated
        public Builder variable(@Nullable String variable) {
            this.variable = variable;
            return this;
        }

        @Generated
        public Builder quantifier(@Nullable GraphQuantifier quantifier) {
            this.quantifier = quantifier;
            return this;
        }

        @Generated
        public Builder parts(@NotNull List<GraphPart> parts) {
            if (parts == null) {
                throw new NullPointerException("parts is marked non-null but is null");
            }
            this.parts = parts;
            return this;
        }

        @Generated
        public GraphPattern build() {
            return new GraphPattern(this.restrictor, this.prefilter, this.variable, this.quantifier, this.parts);
        }

        @Generated
        public String toString() {
            return "GraphPattern.Builder(restrictor=" + this.restrictor + ", prefilter=" + this.prefilter + ", variable=" + this.variable + ", quantifier=" + this.quantifier + ", parts=" + this.parts + ")";
        }
    }
}

