/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.graph;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstEnum;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;

public final class GraphRestrictor
extends AstEnum {
    public static final int TRAIL = 0;
    public static final int ACYCLIC = 1;
    public static final int SIMPLE = 2;
    private final int code;
    @NotNull
    private static final int[] codes = new int[]{0, 1, 2};

    public static GraphRestrictor TRAIL() {
        return new GraphRestrictor(0);
    }

    public static GraphRestrictor ACYCLIC() {
        return new GraphRestrictor(1);
    }

    public static GraphRestrictor SIMPLE() {
        return new GraphRestrictor(2);
    }

    private GraphRestrictor(int code) {
        this.code = code;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    @NotNull
    public String name() {
        switch (this.code) {
            case 0: {
                return "TRAIL";
            }
            case 1: {
                return "ACYCLIC";
            }
            case 2: {
                return "SIMPLE";
            }
        }
        throw new IllegalStateException("Invalid GraphRestrictor code: " + this.code);
    }

    @NotNull
    public static GraphRestrictor parse(@NotNull String value) {
        switch (value) {
            case "TRAIL": {
                return GraphRestrictor.TRAIL();
            }
            case "ACYCLIC": {
                return GraphRestrictor.ACYCLIC();
            }
            case "SIMPLE": {
                return GraphRestrictor.SIMPLE();
            }
        }
        throw new IllegalArgumentException("No enum constant GraphRestrictor." + value);
    }

    @NotNull
    public static int[] codes() {
        return codes;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphRestrictor)) {
            return false;
        }
        GraphRestrictor other = (GraphRestrictor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.code == other.code;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GraphRestrictor;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code;
        return result;
    }
}

