/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.pig;

import com.amazon.ion.IonReader;
import com.amazon.ion.system.IonReaderBuilder;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.pig.cmdline.Command;
import org.partiql.pig.cmdline.CommandLineParser;
import org.partiql.pig.cmdline.TargetLanguage;
import org.partiql.pig.domain.model.TypeDomain;
import org.partiql.pig.domain.model.TypeUniverse;
import org.partiql.pig.domain.parser.TypeDomainParserKt;
import org.partiql.pig.errors.PigException;
import org.partiql.pig.generator.custom.GeneratorKt;
import org.partiql.pig.generator.kotlin.KTypeDomain;
import org.partiql.pig.generator.kotlin.KTypeDomainKt;
import org.partiql.pig.generator.kotlin.KTypeUniverse;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0019\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\b\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"generateCode", "", "command", "Lorg/partiql/pig/cmdline/Command$Generate;", "main", "args", "", "", "([Ljava/lang/String;)V", "progress", "msg", "pig"})
public final class MainKt {
    public static final void progress(@NotNull String msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        String string = "pig: " + msg;
        System.out.println((Object)string);
    }

    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        CommandLineParser cmdParser = new CommandLineParser();
        Command command = cmdParser.parse(args);
        if (command instanceof Command.ShowHelp) {
            PrintStream printStream = System.out;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.out");
            cmdParser.printHelp(printStream);
        } else if (command instanceof Command.InvalidCommandLineArguments) {
            System.err.println(((Command.InvalidCommandLineArguments)command).getMessage());
        } else if (command instanceof Command.Generate) {
            try {
                MainKt.generateCode((Command.Generate)command);
            }
            catch (PigException e) {
                System.err.println("pig: " + e.getError().getLocation() + ": " + e.getError().getContext().getMessage() + '\n' + e.getStackTrace());
                int n = -1;
                System.exit(n);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void generateCode(@NotNull Command.Generate command) {
        Object object;
        Object object2;
        Closeable closeable;
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        MainKt.progress("universe file: " + command.getTypeUniverseFile());
        MainKt.progress("output file  : " + command.getOutputFile());
        MainKt.progress("parsing the universe...");
        Closeable closeable2 = new FileInputStream(command.getTypeUniverseFile());
        Object object3 = null;
        try {
            FileInputStream inputStream = (FileInputStream)closeable2;
            closeable = (Closeable)IonReaderBuilder.standard().build((InputStream)inputStream);
            object2 = null;
            try {
                Object ionReader = (IonReader)closeable;
                IonReader ionReader2 = ionReader;
                Intrinsics.checkExpressionValueIsNotNull((Object)ionReader2, (String)"ionReader");
                ionReader = TypeDomainParserKt.parseTypeUniverse(ionReader2);
            }
            catch (Throwable ionReader) {
                object2 = ionReader;
                throw ionReader;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            object = ionReader;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object3);
        }
        Object typeUniverse = object;
        MainKt.progress("permuting domains...");
        List<TypeDomain> allTypeDomains = ((TypeUniverse)typeUniverse).computeTypeDomains();
        object3 = new PrintWriter(command.getOutputFile());
        object = null;
        try {
            PrintWriter printWriter = (PrintWriter)object3;
            object2 = command.getTarget();
            if (object2 instanceof TargetLanguage.Kotlin) {
                Collection<KTypeDomain> collection;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                MainKt.progress("applying Kotlin pre-processing");
                Iterable iterable = $receiver$iv = (Iterable)allTypeDomains;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    TypeDomain typeDomain = (TypeDomain)item$iv$iv;
                    collection = destination$iv$iv;
                    KTypeDomain kTypeDomain = KTypeDomainKt.toKTypeDomain((TypeDomain)it);
                    collection.add(kTypeDomain);
                }
                collection = (List)destination$iv$iv;
                List list = collection;
                KTypeUniverse kotlinTypeUniverse = new KTypeUniverse(list);
                MainKt.progress("applying the Kotlin template...");
                org.partiql.pig.generator.kotlin.GeneratorKt.applyKotlinTemplate(((TargetLanguage.Kotlin)command.getTarget()).getNamespace(), kotlinTypeUniverse, printWriter);
            } else if (object2 instanceof TargetLanguage.Custom) {
                MainKt.progress("applying " + ((TargetLanguage.Custom)command.getTarget()).getTemplateFile());
                GeneratorKt.applyCustomTemplate(((TargetLanguage.Custom)command.getTarget()).getTemplateFile(), allTypeDomains, printWriter);
            } else if (object2 instanceof TargetLanguage.Html) {
                MainKt.progress("applying the HTML template");
                org.partiql.pig.generator.html.GeneratorKt.applyHtmlTemplate(allTypeDomains, printWriter);
            }
            closeable = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)object);
        }
        MainKt.progress("universe generation complete!");
    }
}

