/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.pig.cmdline;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConversionException;
import joptsimple.ValueConverter;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.pig.cmdline.Command;
import org.partiql.pig.cmdline.CommandLineParser;
import org.partiql.pig.cmdline.CommandLineParser$WhenMappings;
import org.partiql.pig.cmdline.TargetLanguage;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0004\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R2\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00100\u0010 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00120\u0012 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0013\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00100\u0010 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0014\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00100\u0010 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/partiql/pig/cmdline/CommandLineParser;", "", "()V", "formatter", "org/partiql/pig/cmdline/CommandLineParser$formatter$1", "Lorg/partiql/pig/cmdline/CommandLineParser$formatter$1;", "helpOpt", "Ljoptsimple/AbstractOptionSpec;", "Ljava/lang/Void;", "kotlin.jvm.PlatformType", "namespaceOpt", "Ljoptsimple/ArgumentAcceptingOptionSpec;", "", "optParser", "Ljoptsimple/OptionParser;", "outputOpt", "Ljava/io/File;", "targetTypeOpt", "Lorg/partiql/pig/cmdline/CommandLineParser$LanguageTargetType;", "templateOpt", "universeOpt", "parse", "Lorg/partiql/pig/cmdline/Command;", "args", "", "([Ljava/lang/String;)Lorg/partiql/pig/cmdline/Command;", "printHelp", "", "pw", "Ljava/io/PrintStream;", "LanguageTargetType", "languageTargetTypeValueConverter", "pig"})
public final class CommandLineParser {
    private final formatter.1 formatter = new BuiltinHelpFormatter(120, 2){

        @NotNull
        public String format(@Nullable Map<String, ? extends OptionDescriptor> options) {
            return StringsKt.trimMargin$default((String)("PartiQL I.R. Generator\n                |\n                |" + super.format(options) + "\n                |Notes:\n                |\n                |  --target=kotlin requires --namespace=<ns>\n                |  --target=custom requires --template=<path-to-template>\n                | \n                |Examples:\n                |\n                |  pig --target=kotlin --universe=universe.ion --output=example.kt --namespace=org.example.domain\n                |  pig --target=custom --universe=universe.ion --output=example.txt --template=template.ftl\n                |     \n        "), null, (int)1, null);
        }
    };
    private final OptionParser optParser;
    private final AbstractOptionSpec<Void> helpOpt;
    private final ArgumentAcceptingOptionSpec<File> universeOpt;
    private final ArgumentAcceptingOptionSpec<File> outputOpt;
    private final ArgumentAcceptingOptionSpec<LanguageTargetType> targetTypeOpt;
    private final ArgumentAcceptingOptionSpec<String> namespaceOpt;
    private final ArgumentAcceptingOptionSpec<File> templateOpt;

    public final void printHelp(@NotNull PrintStream pw) {
        Intrinsics.checkParameterIsNotNull((Object)pw, (String)"pw");
        this.optParser.printHelpOn((OutputStream)pw);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Command parse(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        try {
            Command command;
            OptionSet optSet = this.optParser.parse(Arrays.copyOf(args, args.length));
            if (optSet.has((OptionSpec)this.helpOpt)) {
                command = Command.ShowHelp.INSTANCE;
                return command;
            } else {
                TargetLanguage targetLanguage;
                Object object = optSet.valueOf((OptionSpec)this.universeOpt);
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                File typeUniverseFile = (File)object;
                Object object2 = optSet.valueOf((OptionSpec)this.targetTypeOpt);
                if (object2 == null) {
                    Intrinsics.throwNpe();
                }
                LanguageTargetType targetType = (LanguageTargetType)((Object)object2);
                Object object3 = optSet.valueOf((OptionSpec)this.outputOpt);
                if (object3 == null) {
                    Intrinsics.throwNpe();
                }
                File outputFile = (File)object3;
                if (targetType.getRequireNamespace()) {
                    if (!optSet.has((OptionSpec)this.namespaceOpt)) {
                        return new Command.InvalidCommandLineArguments("The selected language target requires the --namespace argument");
                    }
                } else if (optSet.has((OptionSpec)this.namespaceOpt)) {
                    return new Command.InvalidCommandLineArguments("The selected language target does not allow the --namespace argument");
                }
                if (targetType.getRequireTemplate()) {
                    if (!optSet.has((OptionSpec)this.templateOpt)) {
                        return new Command.InvalidCommandLineArguments("The selected language target requires the --template argument");
                    }
                } else if (optSet.has((OptionSpec)this.templateOpt)) {
                    return new Command.InvalidCommandLineArguments("The selected language target does not allow the --template argument");
                }
                switch (CommandLineParser$WhenMappings.$EnumSwitchMapping$0[targetType.ordinal()]) {
                    case 1: {
                        targetLanguage = TargetLanguage.Html.INSTANCE;
                        break;
                    }
                    case 2: {
                        Object object4 = optSet.valueOf((OptionSpec)this.namespaceOpt);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"optSet.valueOf(namespaceOpt)");
                        targetLanguage = new TargetLanguage.Kotlin((String)object4);
                        break;
                    }
                    case 3: {
                        Object object5 = optSet.valueOf((OptionSpec)this.templateOpt);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"optSet.valueOf(templateOpt)");
                        targetLanguage = new TargetLanguage.Custom((File)object5);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                TargetLanguage target = targetLanguage;
                command = new Command.Generate(typeUniverseFile, outputFile, target);
            }
            return command;
        }
        catch (OptionException ex) {
            String string = ex.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ex.message!!");
            return new Command.InvalidCommandLineArguments(string);
        }
    }

    public CommandLineParser() {
        OptionParser optionParser;
        OptionParser optionParser2 = new OptionParser();
        CommandLineParser commandLineParser = this;
        OptionParser it = optionParser2;
        it.formatHelpWith((HelpFormatter)this.formatter);
        commandLineParser.optParser = optionParser = optionParser2;
        this.helpOpt = this.optParser.acceptsAll(CollectionsKt.listOf((Object[])new String[]{"help", "h", "?"}), "prints this help").forHelp();
        this.universeOpt = this.optParser.acceptsAll(CollectionsKt.listOf((Object[])new String[]{"universe", "u"}), "Type universe input file").withRequiredArg().ofType(File.class).required();
        this.outputOpt = this.optParser.acceptsAll(CollectionsKt.listOf((Object[])new String[]{"output", "o"}), "Generated output file").withRequiredArg().ofType(File.class).required();
        this.targetTypeOpt = this.optParser.acceptsAll(CollectionsKt.listOf((Object[])new String[]{"target", "t"}), "Target language").withRequiredArg().withValuesConvertedBy((ValueConverter)languageTargetTypeValueConverter.INSTANCE).required();
        this.namespaceOpt = this.optParser.acceptsAll(CollectionsKt.listOf((Object[])new String[]{"namespace", "n"}), "Namespace for generated code").withRequiredArg().ofType(String.class);
        this.templateOpt = this.optParser.acceptsAll(CollectionsKt.listOf((Object[])new String[]{"template", "e"}), "Path to an Apache FreeMarker template").withOptionalArg().ofType(File.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/partiql/pig/cmdline/CommandLineParser$LanguageTargetType;", "", "requireNamespace", "", "requireTemplate", "(Ljava/lang/String;IZZ)V", "getRequireNamespace", "()Z", "getRequireTemplate", "KOTLIN", "CUSTOM", "HTML", "pig"})
    private static final class LanguageTargetType
    extends Enum<LanguageTargetType> {
        public static final /* enum */ LanguageTargetType KOTLIN;
        public static final /* enum */ LanguageTargetType CUSTOM;
        public static final /* enum */ LanguageTargetType HTML;
        private static final /* synthetic */ LanguageTargetType[] $VALUES;
        private final boolean requireNamespace;
        private final boolean requireTemplate;

        static {
            LanguageTargetType[] languageTargetTypeArray = new LanguageTargetType[3];
            LanguageTargetType[] languageTargetTypeArray2 = languageTargetTypeArray;
            languageTargetTypeArray[0] = KOTLIN = new LanguageTargetType("KOTLIN", 0, true, false, 2, null);
            languageTargetTypeArray[1] = CUSTOM = new LanguageTargetType("CUSTOM", 1, false, true, 1, null);
            languageTargetTypeArray[2] = HTML = new LanguageTargetType("HTML", 2, false, false, 3, null);
            $VALUES = languageTargetTypeArray;
        }

        public final boolean getRequireNamespace() {
            return this.requireNamespace;
        }

        public final boolean getRequireTemplate() {
            return this.requireTemplate;
        }

        protected LanguageTargetType(boolean requireNamespace, boolean requireTemplate) {
            this.requireNamespace = requireNamespace;
            this.requireTemplate = requireTemplate;
        }

        /* synthetic */ LanguageTargetType(String string, int n, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = false;
            }
            if ((n2 & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public static LanguageTargetType[] values() {
            return (LanguageTargetType[])$VALUES.clone();
        }

        public static LanguageTargetType valueOf(String string) {
            return Enum.valueOf(LanguageTargetType.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/partiql/pig/cmdline/CommandLineParser$languageTargetTypeValueConverter;", "Ljoptsimple/ValueConverter;", "Lorg/partiql/pig/cmdline/CommandLineParser$LanguageTargetType;", "()V", "lookup", "", "", "convert", "value", "valuePattern", "valueType", "Ljava/lang/Class;", "pig"})
    private static final class languageTargetTypeValueConverter
    implements ValueConverter<LanguageTargetType> {
        private static final Map<String, LanguageTargetType> lookup;
        public static final languageTargetTypeValueConverter INSTANCE;

        @NotNull
        public LanguageTargetType convert(@Nullable String value) {
            if (value == null) {
                throw (Throwable)new ValueConversionException("Value was null");
            }
            LanguageTargetType languageTargetType = lookup.get(value);
            if (languageTargetType == null) {
                throw (Throwable)new ValueConversionException("Invalid language target type: " + value);
            }
            return languageTargetType;
        }

        @NotNull
        public Class<? extends LanguageTargetType> valueType() {
            return LanguageTargetType.class;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public String valuePattern() {
            void var3_3;
            void $receiver$iv$iv;
            LanguageTargetType[] $receiver$iv;
            LanguageTargetType[] languageTargetTypeArray = $receiver$iv = LanguageTargetType.values();
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            void var4_4 = $receiver$iv$iv;
            int n = ((void)var4_4).length;
            for (int i = 0; i < n; ++i) {
                String string;
                void it;
                String string2;
                void item$iv$iv;
                void var8_8 = item$iv$iv = var4_4[i];
                Collection collection = destination$iv$iv;
                String string3 = string2 = it.name();
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                collection.add(string);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)var3_3), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
        }

        private languageTargetTypeValueConverter() {
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $receiver$iv$iv;
            languageTargetTypeValueConverter languageTargetTypeValueConverter2;
            INSTANCE = languageTargetTypeValueConverter2 = new languageTargetTypeValueConverter();
            LanguageTargetType[] $receiver$iv = LanguageTargetType.values();
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$receiver$iv.length), (int)16);
            LanguageTargetType[] languageTargetTypeArray = $receiver$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            void var5_5 = $receiver$iv$iv;
            int n = ((void)var5_5).length;
            for (int i = 0; i < n; ++i) {
                String string;
                void it;
                String string2;
                void element$iv$iv;
                void var9_9 = element$iv$iv = var5_5[i];
                Map map = destination$iv$iv;
                String string3 = string2 = it.name();
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                map.put(string, element$iv$iv);
            }
            lookup = destination$iv$iv;
        }
    }
}

