/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.pig.domain.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.pig.domain.model.DataType;
import org.partiql.pig.domain.model.PermutedSum;
import org.partiql.pig.domain.model.SemanticErrorContext;
import org.partiql.pig.domain.model.SemanticErrorContextKt;
import org.partiql.pig.domain.model.Statement;
import org.partiql.pig.domain.model.TypeDomain;
import org.partiql.pig.errors.ErrorContext;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006\u0012\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lorg/partiql/pig/domain/model/PermutedDomain;", "Lorg/partiql/pig/domain/model/Statement;", "tag", "", "permutesDomain", "excludedTypes", "", "includedTypes", "Lorg/partiql/pig/domain/model/DataType;", "permutedSums", "Lorg/partiql/pig/domain/model/PermutedSum;", "metas", "", "", "Lcom/amazon/ionelement/api/MetaContainer;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "getExcludedTypes", "()Ljava/util/List;", "getIncludedTypes", "getPermutedSums", "getPermutesDomain", "()Ljava/lang/String;", "getTag", "computePermutation", "Lorg/partiql/pig/domain/model/TypeDomain;", "domains", "pig"})
public final class PermutedDomain
extends Statement {
    @NotNull
    private final String tag;
    @NotNull
    private final String permutesDomain;
    @NotNull
    private final List<String> excludedTypes;
    @NotNull
    private final List<DataType> includedTypes;
    @NotNull
    private final List<PermutedSum> permutedSums;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeDomain computePermutation(@NotNull Map<String, TypeDomain> domains) {
        void $receiver$iv$iv;
        DataType it;
        Object element$iv3;
        Object object;
        Object single$iv;
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull(domains, (String)"domains");
        TypeDomain typeDomain = domains.get(this.permutesDomain);
        if (typeDomain == null) {
            Void void_ = SemanticErrorContextKt.semanticError(this.getMetas(), (ErrorContext)new SemanticErrorContext.DomainPermutesNonExistentDomain(this.tag, this.permutesDomain));
            throw null;
        }
        TypeDomain permutingDomain = typeDomain;
        List newTypes = CollectionsKt.toMutableList((Collection)permutingDomain.getTypes());
        Iterable $receiver$iv2 = this.excludedTypes;
        for (Object element$iv2 : $receiver$iv2) {
            Object v2;
            String removedTypeName;
            block14: {
                removedTypeName = (String)element$iv2;
                $receiver$iv = newTypes;
                single$iv = null;
                boolean found$iv = false;
                object = $receiver$iv.iterator();
                while (object.hasNext()) {
                    element$iv3 = object.next();
                    it = (DataType)element$iv3;
                    if (!Intrinsics.areEqual((Object)it.getTag(), (Object)removedTypeName)) continue;
                    if (found$iv) {
                        v2 = null;
                        break block14;
                    }
                    single$iv = element$iv3;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            DataType typeToRemove = v2;
            if (typeToRemove == null) {
                Void void_ = SemanticErrorContextKt.semanticError(this.getMetas(), (ErrorContext)new SemanticErrorContext.CannotRemoveNonExistentType(removedTypeName, this.tag, this.permutesDomain));
                throw null;
            }
            if (typeToRemove.isBuiltin()) {
                Void void_ = SemanticErrorContextKt.semanticError(this.getMetas(), (ErrorContext)new SemanticErrorContext.CannotRemoveBuiltinType(removedTypeName));
                throw null;
            }
            if (newTypes.removeIf((Predicate)new Predicate<DataType>(removedTypeName){
                final /* synthetic */ String $removedTypeName;

                public final boolean test(@NotNull DataType oldType) {
                    Intrinsics.checkParameterIsNotNull((Object)oldType, (String)"oldType");
                    return Intrinsics.areEqual((Object)oldType.getTag(), (Object)this.$removedTypeName);
                }
                {
                    this.$removedTypeName = string;
                }
            })) continue;
            $receiver$iv = "Failed to remove " + removedTypeName + " for some reason";
            throw (Throwable)new IllegalStateException($receiver$iv.toString());
        }
        $receiver$iv2 = this.permutedSums;
        for (Object element$iv2 : $receiver$iv2) {
            Object v5;
            PermutedSum extSum;
            block15: {
                extSum = (PermutedSum)element$iv2;
                $receiver$iv = newTypes;
                single$iv = null;
                boolean found$iv = false;
                object = $receiver$iv.iterator();
                while (object.hasNext()) {
                    element$iv3 = object.next();
                    it = (DataType)element$iv3;
                    if (!Intrinsics.areEqual((Object)it.getTag(), (Object)extSum.getTag())) continue;
                    if (found$iv) {
                        v5 = null;
                        break block15;
                    }
                    single$iv = element$iv3;
                    found$iv = true;
                }
                v5 = !found$iv ? null : single$iv;
            }
            DataType typeToAlter = v5;
            if (typeToAlter == null) {
                Void void_ = SemanticErrorContextKt.semanticError(extSum.getMetas(), (ErrorContext)new SemanticErrorContext.CannotPermuteNonExistentSum(extSum.getTag(), this.tag, this.permutesDomain));
                throw null;
            }
            if (typeToAlter instanceof DataType.Tuple || typeToAlter instanceof DataType.Int || typeToAlter instanceof DataType.Symbol) {
                Void void_ = SemanticErrorContextKt.semanticError(extSum.getMetas(), (ErrorContext)new SemanticErrorContext.CannotPermuteNonSumType(extSum.getTag()));
                throw null;
            }
            if (!(typeToAlter instanceof DataType.Sum)) continue;
            List newVariants = CollectionsKt.toMutableList((Collection)((DataType.Sum)typeToAlter).getVariants());
            Set removedVariantTags = CollectionsKt.toSet((Iterable)extSum.getRemovedVariants());
            Iterable $receiver$iv3 = removedVariantTags;
            for (Object element$iv3 : $receiver$iv3) {
                String removedTagName = (String)element$iv3;
                if (newVariants.removeIf((Predicate)new Predicate<DataType.Tuple>(removedTagName){
                    final /* synthetic */ String $removedTagName;

                    public final boolean test(@NotNull DataType.Tuple it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it.getTag(), (Object)this.$removedTagName);
                    }
                    {
                        this.$removedTagName = string;
                    }
                })) continue;
                Void void_ = SemanticErrorContextKt.semanticError(extSum.getMetas(), (ErrorContext)new SemanticErrorContext.CannotRemoveNonExistentSumVariant(extSum.getTag(), removedTagName));
                throw null;
            }
            newVariants.addAll((Collection)extSum.getAddedVariants());
            DataType.Sum newSumType = new DataType.Sum(extSum.getTag(), newVariants, this.getMetas());
            if (!newTypes.remove(typeToAlter)) {
                object = "Failed to remove altered type '" + typeToAlter.getTag() + "' for some reason";
                throw (Throwable)new IllegalStateException(object.toString());
            }
            newTypes.add(newSumType);
        }
        newTypes.addAll((Collection)this.includedTypes);
        $receiver$iv2 = newTypes;
        String string = this.tag;
        Iterable iterable = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            DataType it2 = (DataType)element$iv$iv;
            if (!(!it2.isBuiltin())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Map<String, Object> map = this.getMetas();
        List list2 = list;
        String string2 = string;
        return new TypeDomain(string2, list2, map);
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    @NotNull
    public final String getPermutesDomain() {
        return this.permutesDomain;
    }

    @NotNull
    public final List<String> getExcludedTypes() {
        return this.excludedTypes;
    }

    @NotNull
    public final List<DataType> getIncludedTypes() {
        return this.includedTypes;
    }

    @NotNull
    public final List<PermutedSum> getPermutedSums() {
        return this.permutedSums;
    }

    public PermutedDomain(@NotNull String tag, @NotNull String permutesDomain, @NotNull List<String> excludedTypes, @NotNull List<? extends DataType> includedTypes, @NotNull List<PermutedSum> permutedSums, @NotNull Map<String, ? extends Object> metas) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)permutesDomain, (String)"permutesDomain");
        Intrinsics.checkParameterIsNotNull(excludedTypes, (String)"excludedTypes");
        Intrinsics.checkParameterIsNotNull(includedTypes, (String)"includedTypes");
        Intrinsics.checkParameterIsNotNull(permutedSums, (String)"permutedSums");
        Intrinsics.checkParameterIsNotNull(metas, (String)"metas");
        super(metas, null);
        this.tag = tag;
        this.permutesDomain = permutesDomain;
        this.excludedTypes = excludedTypes;
        this.includedTypes = includedTypes;
        this.permutedSums = permutedSums;
    }
}

