/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.pig.domain.model;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.pig.domain.model.Arity;
import org.partiql.pig.domain.model.DataType;
import org.partiql.pig.domain.model.NamedElement;
import org.partiql.pig.domain.model.SemanticErrorContext;
import org.partiql.pig.domain.model.SemanticErrorContextKt;
import org.partiql.pig.domain.model.TypeDomain;
import org.partiql.pig.domain.model.TypeDomainSemanticChecker$WhenMappings;
import org.partiql.pig.domain.model.TypeRef;
import org.partiql.pig.errors.ErrorContext;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0006\u0010\u0015\u001a\u00020\nJ\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\nH\u0002J\b\u0010\u001d\u001a\u00020\nH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/partiql/pig/domain/model/TypeDomainSemanticChecker;", "", "typeDomain", "Lorg/partiql/pig/domain/model/TypeDomain;", "(Lorg/partiql/pig/domain/model/TypeDomain;)V", "names", "", "", "Lorg/partiql/pig/domain/model/TypeDomainSemanticChecker$NameType;", "checkElementNames", "", "dataType", "Lorg/partiql/pig/domain/model/DataType$Tuple;", "checkProductArgumentOrder", "p", "checkProductForErrors", "checkProductIonFieldArity", "checkRecordElementTags", "variant", "checkRecordForErrors", "r", "checkSemantics", "checkTupleElementIdentifiers", "checkTupleForErrors", "t", "checkTypeRef", "typeRef", "Lorg/partiql/pig/domain/model/TypeRef;", "collectNames", "errorCheck", "ArgumentState", "NameType", "pig"})
final class TypeDomainSemanticChecker {
    private final Map<String, NameType> names;
    private final TypeDomain typeDomain;

    public final void checkSemantics() {
        this.collectNames();
        this.errorCheck();
    }

    private final void collectNames() {
        Iterable $receiver$iv = this.typeDomain.getTypes();
        for (Object element$iv : $receiver$iv) {
            DataType dataType = (DataType)element$iv;
            if (this.names.putIfAbsent(dataType.getTag(), NameType.TYPE) != null) {
                Void void_ = SemanticErrorContextKt.semanticError(dataType.getMetas(), (ErrorContext)new SemanticErrorContext.NameAlreadyUsed(dataType.getTag(), this.typeDomain.getTag()));
                throw null;
            }
            DataType dataType2 = dataType;
            if (dataType2 instanceof DataType.Tuple) {
                this.checkElementNames((DataType.Tuple)dataType);
                continue;
            }
            if (dataType2 instanceof DataType.Sum) {
                Iterable $receiver$iv2 = ((DataType.Sum)dataType).getVariants();
                for (Object element$iv2 : $receiver$iv2) {
                    DataType.Tuple variant = (DataType.Tuple)element$iv2;
                    if (this.names.putIfAbsent(variant.getTag(), NameType.VARIANT) != null) {
                        Void void_ = SemanticErrorContextKt.semanticError(variant.getMetas(), (ErrorContext)new SemanticErrorContext.NameAlreadyUsed(variant.getTag(), this.typeDomain.getTag()));
                        throw null;
                    }
                    this.checkElementNames(variant);
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)dataType2, (Object)DataType.Ion.INSTANCE) && !Intrinsics.areEqual((Object)dataType2, (Object)DataType.Int.INSTANCE) && !Intrinsics.areEqual((Object)dataType2, (Object)DataType.Symbol.INSTANCE)) continue;
        }
    }

    private final void checkElementNames(DataType.Tuple dataType) {
        switch (TypeDomainSemanticChecker$WhenMappings.$EnumSwitchMapping$0[dataType.getTupleType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.checkRecordElementTags(dataType);
            }
        }
        this.checkTupleElementIdentifiers(dataType);
    }

    private final void checkTupleElementIdentifiers(DataType.Tuple variant) {
        Set elementIdentifiers = new LinkedHashSet();
        Iterable $receiver$iv = variant.getNamedElements();
        for (Object element$iv : $receiver$iv) {
            NamedElement it = (NamedElement)element$iv;
            if (!elementIdentifiers.contains(it.getIdentifier())) {
                elementIdentifiers.add(it.getIdentifier());
                continue;
            }
            Void void_ = SemanticErrorContextKt.semanticError(it.getMetas(), (ErrorContext)new SemanticErrorContext.DuplicateElementIdentifier(it.getIdentifier()));
            throw null;
        }
    }

    private final void checkRecordElementTags(DataType.Tuple variant) {
        Set elementTags = new LinkedHashSet();
        Iterable $receiver$iv = variant.getNamedElements();
        for (Object element$iv : $receiver$iv) {
            NamedElement it = (NamedElement)element$iv;
            if (!elementTags.contains(it.getTag())) {
                elementTags.add(it.getTag());
                continue;
            }
            Void void_ = SemanticErrorContextKt.semanticError(it.getMetas(), (ErrorContext)new SemanticErrorContext.DuplicateRecordElementTag(it.getTag()));
            throw null;
        }
    }

    private final void errorCheck() {
        Iterable $receiver$iv = this.typeDomain.getTypes();
        for (Object element$iv : $receiver$iv) {
            DataType dataType = (DataType)element$iv;
            DataType dataType2 = dataType;
            if (dataType2 instanceof DataType.Tuple) {
                this.checkTupleForErrors((DataType.Tuple)dataType);
                continue;
            }
            if (dataType2 instanceof DataType.Sum) {
                if (CollectionsKt.none((Iterable)((DataType.Sum)dataType).getVariants())) {
                    Void void_ = SemanticErrorContextKt.semanticError(dataType.getMetas(), (ErrorContext)new SemanticErrorContext.EmptySumType(dataType.getTag()));
                    throw null;
                }
                Iterable $receiver$iv2 = ((DataType.Sum)dataType).getVariants();
                for (Object element$iv2 : $receiver$iv2) {
                    DataType.Tuple variant = (DataType.Tuple)element$iv2;
                    this.checkTupleForErrors(variant);
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)dataType2, (Object)DataType.Ion.INSTANCE) && !Intrinsics.areEqual((Object)dataType2, (Object)DataType.Int.INSTANCE) && !Intrinsics.areEqual((Object)dataType2, (Object)DataType.Symbol.INSTANCE)) continue;
        }
    }

    private final void checkTupleForErrors(DataType.Tuple t) {
        switch (TypeDomainSemanticChecker$WhenMappings.$EnumSwitchMapping$1[t.getTupleType().ordinal()]) {
            case 1: {
                this.checkProductForErrors(t);
                break;
            }
            case 2: {
                this.checkRecordForErrors(t);
            }
        }
    }

    private final void checkProductForErrors(DataType.Tuple p) {
        Iterable $receiver$iv = p.getNamedElements();
        for (Object element$iv : $receiver$iv) {
            NamedElement typeRef = (NamedElement)element$iv;
            this.checkTypeRef(typeRef.getTypeReference());
        }
        this.checkProductIonFieldArity(p);
        this.checkProductArgumentOrder(p);
    }

    private final void checkRecordForErrors(DataType.Tuple r) {
        if (CollectionsKt.none((Iterable)r.getNamedElements())) {
            Void void_ = SemanticErrorContextKt.semanticError(r.getMetas(), (ErrorContext)SemanticErrorContext.EmptyRecord.INSTANCE);
            throw null;
        }
        Iterable $receiver$iv = r.getNamedElements();
        for (Object element$iv : $receiver$iv) {
            NamedElement it = (NamedElement)element$iv;
            this.checkTypeRef(it.getTypeReference());
        }
    }

    private final void checkTypeRef(TypeRef typeRef) {
        NameType nameType = this.names.get(typeRef.getTypeName());
        if (nameType == null) {
            Void void_ = SemanticErrorContextKt.semanticError(typeRef.getMetas(), (ErrorContext)new SemanticErrorContext.UndefinedType(typeRef.getTypeName()));
            throw null;
        }
        switch (TypeDomainSemanticChecker$WhenMappings.$EnumSwitchMapping$2[nameType.ordinal()]) {
            case 1: 
            case 2: {
                Void void_ = SemanticErrorContextKt.semanticError(typeRef.getMetas(), (ErrorContext)new SemanticErrorContext.NotATypeName(typeRef.getTypeName()));
                throw null;
            }
        }
    }

    private final void checkProductArgumentOrder(DataType.Tuple p) {
        ArgumentState currentState = ArgumentState.REQUIRED;
        Iterable $receiver$iv = p.getNamedElements();
        block5: for (Object element$iv : $receiver$iv) {
            NamedElement element = (NamedElement)element$iv;
            Arity arity = element.getTypeReference().getArity();
            switch (TypeDomainSemanticChecker$WhenMappings.$EnumSwitchMapping$3[currentState.ordinal()]) {
                case 1: {
                    Arity arity2 = arity;
                    if (Intrinsics.areEqual((Object)arity2, (Object)Arity.Required.INSTANCE)) break;
                    if (arity2 instanceof Arity.Optional) {
                        currentState = ArgumentState.OPTIONAL;
                        break;
                    }
                    if (!(arity2 instanceof Arity.Variadic)) continue block5;
                    currentState = ArgumentState.VARIADIC;
                    break;
                }
                case 2: {
                    Arity arity2 = arity;
                    if (Intrinsics.areEqual((Object)arity2, (Object)Arity.Required.INSTANCE)) {
                        Void void_ = SemanticErrorContextKt.semanticError(element.getMetas(), (ErrorContext)SemanticErrorContext.RequiredElementAfterOptional.INSTANCE);
                        throw null;
                    }
                    if (arity2 instanceof Arity.Optional) break;
                    if (!(arity2 instanceof Arity.Variadic)) continue block5;
                    Void void_ = SemanticErrorContextKt.semanticError(element.getMetas(), (ErrorContext)SemanticErrorContext.ProductCannotHaveBothOptionalAndVariadicElements.INSTANCE);
                    throw null;
                }
                case 3: {
                    Arity arity2 = arity;
                    if (Intrinsics.areEqual((Object)arity2, (Object)Arity.Required.INSTANCE)) {
                        Void void_ = SemanticErrorContextKt.semanticError(element.getMetas(), (ErrorContext)SemanticErrorContext.RequiredElementAfterVariadic.INSTANCE);
                        throw null;
                    }
                    if (arity2 instanceof Arity.Optional) {
                        Void void_ = SemanticErrorContextKt.semanticError(element.getMetas(), (ErrorContext)SemanticErrorContext.OptionalElementAfterVariadic.INSTANCE);
                        throw null;
                    }
                    if (arity2 instanceof Arity.Variadic) {
                        Void void_ = SemanticErrorContextKt.semanticError(element.getMetas(), (ErrorContext)SemanticErrorContext.MoreThanOneVariadicElement.INSTANCE);
                        throw null;
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final void checkProductIonFieldArity(DataType.Tuple p) {
        Iterable $receiver$iv = p.getNamedElements();
        for (Object element$iv : $receiver$iv) {
            NamedElement element = (NamedElement)element$iv;
            DataType dataType = this.typeDomain.resolveTypeRef(element.getTypeReference());
            if (!Intrinsics.areEqual((Object)dataType, (Object)DataType.Ion.INSTANCE) || !Intrinsics.areEqual((Object)element.getTypeReference().getArity(), (Object)Arity.Optional.INSTANCE)) continue;
            Void void_ = SemanticErrorContextKt.semanticError(element.getMetas(), (ErrorContext)SemanticErrorContext.OptionalIonTypeElement.INSTANCE);
            throw null;
        }
    }

    public TypeDomainSemanticChecker(@NotNull TypeDomain typeDomain) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)typeDomain, (String)"typeDomain");
        this.typeDomain = typeDomain;
        TypeDomainSemanticChecker typeDomainSemanticChecker = this;
        typeDomainSemanticChecker.names = map = (Map)new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/partiql/pig/domain/model/TypeDomainSemanticChecker$NameType;", "", "(Ljava/lang/String;I)V", "TYPE", "VARIANT", "NAMED_ELEMENT", "pig"})
    private static final class NameType
    extends Enum<NameType> {
        public static final /* enum */ NameType TYPE;
        public static final /* enum */ NameType VARIANT;
        public static final /* enum */ NameType NAMED_ELEMENT;
        private static final /* synthetic */ NameType[] $VALUES;

        static {
            NameType[] nameTypeArray = new NameType[3];
            NameType[] nameTypeArray2 = nameTypeArray;
            nameTypeArray[0] = TYPE = new NameType();
            nameTypeArray[1] = VARIANT = new NameType();
            nameTypeArray[2] = NAMED_ELEMENT = new NameType();
            $VALUES = nameTypeArray;
        }

        public static NameType[] values() {
            return (NameType[])$VALUES.clone();
        }

        public static NameType valueOf(String string) {
            return Enum.valueOf(NameType.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/partiql/pig/domain/model/TypeDomainSemanticChecker$ArgumentState;", "", "(Ljava/lang/String;I)V", "REQUIRED", "OPTIONAL", "VARIADIC", "pig"})
    private static final class ArgumentState
    extends Enum<ArgumentState> {
        public static final /* enum */ ArgumentState REQUIRED;
        public static final /* enum */ ArgumentState OPTIONAL;
        public static final /* enum */ ArgumentState VARIADIC;
        private static final /* synthetic */ ArgumentState[] $VALUES;

        static {
            ArgumentState[] argumentStateArray = new ArgumentState[3];
            ArgumentState[] argumentStateArray2 = argumentStateArray;
            argumentStateArray[0] = REQUIRED = new ArgumentState();
            argumentStateArray[1] = OPTIONAL = new ArgumentState();
            argumentStateArray[2] = VARIADIC = new ArgumentState();
            $VALUES = argumentStateArray;
        }

        public static ArgumentState[] values() {
            return (ArgumentState[])$VALUES.clone();
        }

        public static ArgumentState valueOf(String string) {
            return Enum.valueOf(ArgumentState.class, string);
        }
    }
}

