/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.pig.domain.model;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.pig.domain.model.PermutedDomain;
import org.partiql.pig.domain.model.SemanticErrorContext;
import org.partiql.pig.domain.model.SemanticErrorContextKt;
import org.partiql.pig.domain.model.Statement;
import org.partiql.pig.domain.model.TypeDomain;
import org.partiql.pig.domain.model.TypeDomainSemanticCheckerKt;
import org.partiql.pig.errors.ErrorContext;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003J\u0019\u0010\u000b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/partiql/pig/domain/model/TypeUniverse;", "", "statements", "", "Lorg/partiql/pig/domain/model/Statement;", "(Ljava/util/List;)V", "getStatements", "()Ljava/util/List;", "component1", "computeTypeDomains", "Lorg/partiql/pig/domain/model/TypeDomain;", "copy", "equals", "", "other", "hashCode", "", "toString", "", "pig"})
public final class TypeUniverse {
    @NotNull
    private final List<Statement> statements;

    @NotNull
    public final List<TypeDomain> computeTypeDomains() {
        if (CollectionsKt.none((Iterable)this.statements)) {
            Void void_ = SemanticErrorContextKt.semanticError(null, (ErrorContext)SemanticErrorContext.EmptyUniverse.INSTANCE);
            throw null;
        }
        Map domains = new LinkedHashMap();
        Iterable $receiver$iv = this.statements;
        for (Object element$iv : $receiver$iv) {
            TypeDomain typeDomain;
            Statement stmt = (Statement)element$iv;
            Statement statement = stmt;
            if (statement instanceof TypeDomain) {
                typeDomain = (TypeDomain)stmt;
            } else if (statement instanceof PermutedDomain) {
                typeDomain = ((PermutedDomain)stmt).computePermutation(domains);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            TypeDomain typeDomain2 = typeDomain;
            TypeDomainSemanticCheckerKt.checkSemantics(typeDomain2);
            if (domains.putIfAbsent(typeDomain2.getTag(), typeDomain2) == null) continue;
            Void void_ = SemanticErrorContextKt.semanticError(typeDomain2.getMetas(), (ErrorContext)new SemanticErrorContext.DuplicateTypeDomainName(typeDomain2.getTag()));
            throw null;
        }
        return CollectionsKt.toList((Iterable)domains.values());
    }

    @NotNull
    public final List<Statement> getStatements() {
        return this.statements;
    }

    public TypeUniverse(@NotNull List<? extends Statement> statements) {
        Intrinsics.checkParameterIsNotNull(statements, (String)"statements");
        this.statements = statements;
    }

    @NotNull
    public final List<Statement> component1() {
        return this.statements;
    }

    @NotNull
    public final TypeUniverse copy(@NotNull List<? extends Statement> statements) {
        Intrinsics.checkParameterIsNotNull(statements, (String)"statements");
        return new TypeUniverse(statements);
    }

    @NotNull
    public static /* synthetic */ TypeUniverse copy$default(TypeUniverse typeUniverse, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = typeUniverse.statements;
        }
        return typeUniverse.copy(list);
    }

    @NotNull
    public String toString() {
        return "TypeUniverse(statements=" + this.statements + ")";
    }

    public int hashCode() {
        List<Statement> list = this.statements;
        return list != null ? ((Object)list).hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TypeUniverse)) break block3;
                TypeUniverse typeUniverse = (TypeUniverse)object;
                if (!Intrinsics.areEqual(this.statements, typeUniverse.statements)) break block3;
            }
            return true;
        }
        return false;
    }
}

