/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.pig.generator.custom;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.pig.domain.model.TypeDomain;
import org.partiql.pig.generator.FreeMarkerUtilsKt;
import org.partiql.pig.generator.custom.CTypeDomain;
import org.partiql.pig.generator.custom.CTypeDomainKt;
import org.partiql.pig.generator.custom.CustomFreeMarkerGlobals;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\n2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u00a8\u0006\u000b"}, d2={"applyCustomTemplate", "", "templateFile", "Ljava/io/File;", "domains", "", "Lorg/partiql/pig/domain/model/TypeDomain;", "output", "Ljava/io/PrintWriter;", "createCustomFreeMarkerGlobals", "Lorg/partiql/pig/generator/custom/CustomFreeMarkerGlobals;", "pig"})
public final class GeneratorKt {
    public static final void applyCustomTemplate(@NotNull File templateFile, @NotNull List<TypeDomain> domains, @NotNull PrintWriter output) {
        Intrinsics.checkParameterIsNotNull((Object)templateFile, (String)"templateFile");
        Intrinsics.checkParameterIsNotNull(domains, (String)"domains");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        CustomFreeMarkerGlobals renderModel = GeneratorKt.createCustomFreeMarkerGlobals(domains);
        Configuration cfg = FreeMarkerUtilsKt.createDefaultFreeMarkerConfiguration();
        cfg.setDirectoryForTemplateLoading(templateFile.getParentFile());
        Template template = cfg.getTemplate(templateFile.getName());
        if (template == null) {
            Intrinsics.throwNpe();
        }
        Template template2 = template;
        template2.process((Object)renderModel, (Writer)output);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CustomFreeMarkerGlobals createCustomFreeMarkerGlobals(@NotNull List<TypeDomain> domains) {
        void var3_3;
        Collection<CTypeDomain> collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(domains, (String)"domains");
        Iterable iterable = $receiver$iv = (Iterable)domains;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeDomain typeDomain = (TypeDomain)item$iv$iv;
            collection = destination$iv$iv;
            CTypeDomain cTypeDomain = CTypeDomainKt.toCTypeDomain((TypeDomain)it);
            collection.add(cTypeDomain);
        }
        collection = (List)var3_3;
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)offsetDateTime, (String)"OffsetDateTime.now()");
        OffsetDateTime offsetDateTime2 = offsetDateTime;
        List list = collection;
        return new CustomFreeMarkerGlobals(list, offsetDateTime2);
    }
}

