/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.ast.passes;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.errors.ProblemDetails;
import org.partiql.errors.ProblemSeverity;
import org.partiql.lang.ast.passes.inference.StaticTypeExtensionsKt;
import org.partiql.types.StaticType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u000b\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019B\u001d\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u000b\u001a\u001b\u001c\u001d\u001e\u001f !\"#$\u00a8\u0006%"}, d2={"Lorg/partiql/lang/ast/passes/SemanticProblemDetails;", "Lorg/partiql/errors/ProblemDetails;", "severity", "Lorg/partiql/errors/ProblemSeverity;", "messageFormatter", "Lkotlin/Function0;", "", "(Lorg/partiql/errors/ProblemSeverity;Lkotlin/jvm/functions/Function0;)V", "message", "getMessage", "()Ljava/lang/String;", "getMessageFormatter", "()Lkotlin/jvm/functions/Function0;", "getSeverity", "()Lorg/partiql/errors/ProblemSeverity;", "CoercionError", "DuplicateAliasesInSelectListItem", "ExpressionAlwaysReturnsMissing", "ExpressionAlwaysReturnsNullOrMissing", "IncompatibleDataTypeForExpr", "IncompatibleDatatypesForOp", "IncorrectNumberOfArgumentsToFunctionCall", "InvalidArgumentTypeForFunction", "MissingAlias", "NoSuchFunction", "NullOrMissingFunctionArgument", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails$IncorrectNumberOfArgumentsToFunctionCall;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails$CoercionError;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails$DuplicateAliasesInSelectListItem;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails$NoSuchFunction;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails$IncompatibleDatatypesForOp;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails$IncompatibleDataTypeForExpr;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails$ExpressionAlwaysReturnsMissing;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails$ExpressionAlwaysReturnsNullOrMissing;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails$InvalidArgumentTypeForFunction;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails$NullOrMissingFunctionArgument;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails$MissingAlias;", "partiql-lang"})
public abstract class SemanticProblemDetails
implements ProblemDetails {
    @NotNull
    private final ProblemSeverity severity;
    @NotNull
    private final Function0<String> messageFormatter;

    private SemanticProblemDetails(ProblemSeverity severity, Function0<String> messageFormatter) {
        this.severity = severity;
        this.messageFormatter = messageFormatter;
    }

    @NotNull
    public ProblemSeverity getSeverity() {
        return this.severity;
    }

    @NotNull
    public final Function0<String> getMessageFormatter() {
        return this.messageFormatter;
    }

    @NotNull
    public String getMessage() {
        return (String)this.messageFormatter.invoke();
    }

    public /* synthetic */ SemanticProblemDetails(ProblemSeverity severity, Function0 messageFormatter, DefaultConstructorMarker $constructor_marker) {
        this(severity, (Function0<String>)messageFormatter);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/partiql/lang/ast/passes/SemanticProblemDetails$IncorrectNumberOfArgumentsToFunctionCall;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails;", "functionName", "", "expectedArity", "Lkotlin/ranges/IntRange;", "actualArity", "", "(Ljava/lang/String;Lkotlin/ranges/IntRange;I)V", "getActualArity", "()I", "getExpectedArity", "()Lkotlin/ranges/IntRange;", "getFunctionName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "partiql-lang"})
    public static final class IncorrectNumberOfArgumentsToFunctionCall
    extends SemanticProblemDetails {
        @NotNull
        private final String functionName;
        @NotNull
        private final IntRange expectedArity;
        private final int actualArity;

        public IncorrectNumberOfArgumentsToFunctionCall(final @NotNull String functionName, final @NotNull IntRange expectedArity, final int actualArity) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)expectedArity, (String)"expectedArity");
            super(ProblemSeverity.ERROR, (Function0)new Function0<String>(){

                @NotNull
                public final String invoke() {
                    return "Incorrect number of arguments for '" + functionName + "'. Expected " + expectedArity + " but was supplied " + actualArity + '.';
                }
            }, null);
            this.functionName = functionName;
            this.expectedArity = expectedArity;
            this.actualArity = actualArity;
        }

        @NotNull
        public final String getFunctionName() {
            return this.functionName;
        }

        @NotNull
        public final IntRange getExpectedArity() {
            return this.expectedArity;
        }

        public final int getActualArity() {
            return this.actualArity;
        }

        @NotNull
        public final String component1() {
            return this.functionName;
        }

        @NotNull
        public final IntRange component2() {
            return this.expectedArity;
        }

        public final int component3() {
            return this.actualArity;
        }

        @NotNull
        public final IncorrectNumberOfArgumentsToFunctionCall copy(@NotNull String functionName, @NotNull IntRange expectedArity, int actualArity) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)expectedArity, (String)"expectedArity");
            return new IncorrectNumberOfArgumentsToFunctionCall(functionName, expectedArity, actualArity);
        }

        public static /* synthetic */ IncorrectNumberOfArgumentsToFunctionCall copy$default(IncorrectNumberOfArgumentsToFunctionCall incorrectNumberOfArgumentsToFunctionCall, String string, IntRange intRange, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = incorrectNumberOfArgumentsToFunctionCall.functionName;
            }
            if ((n2 & 2) != 0) {
                intRange = incorrectNumberOfArgumentsToFunctionCall.expectedArity;
            }
            if ((n2 & 4) != 0) {
                n = incorrectNumberOfArgumentsToFunctionCall.actualArity;
            }
            return incorrectNumberOfArgumentsToFunctionCall.copy(string, intRange, n);
        }

        @NotNull
        public String toString() {
            return "IncorrectNumberOfArgumentsToFunctionCall(functionName=" + this.functionName + ", expectedArity=" + this.expectedArity + ", actualArity=" + this.actualArity + ')';
        }

        public int hashCode() {
            int result = this.functionName.hashCode();
            result = result * 31 + this.expectedArity.hashCode();
            result = result * 31 + Integer.hashCode(this.actualArity);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IncorrectNumberOfArgumentsToFunctionCall)) {
                return false;
            }
            IncorrectNumberOfArgumentsToFunctionCall incorrectNumberOfArgumentsToFunctionCall = (IncorrectNumberOfArgumentsToFunctionCall)other;
            if (!Intrinsics.areEqual((Object)this.functionName, (Object)incorrectNumberOfArgumentsToFunctionCall.functionName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.expectedArity, (Object)incorrectNumberOfArgumentsToFunctionCall.expectedArity)) {
                return false;
            }
            return this.actualArity == incorrectNumberOfArgumentsToFunctionCall.actualArity;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/partiql/lang/ast/passes/SemanticProblemDetails$CoercionError;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails;", "actualType", "Lorg/partiql/types/StaticType;", "(Lorg/partiql/types/StaticType;)V", "getActualType", "()Lorg/partiql/types/StaticType;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "partiql-lang"})
    public static final class CoercionError
    extends SemanticProblemDetails {
        @NotNull
        private final StaticType actualType;

        public CoercionError(final @NotNull StaticType actualType) {
            Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
            super(ProblemSeverity.ERROR, (Function0)new Function0<String>(){

                @NotNull
                public final String invoke() {
                    return "Unable to coerce " + actualType + " into a single value.";
                }
            }, null);
            this.actualType = actualType;
        }

        @NotNull
        public final StaticType getActualType() {
            return this.actualType;
        }

        @NotNull
        public final StaticType component1() {
            return this.actualType;
        }

        @NotNull
        public final CoercionError copy(@NotNull StaticType actualType) {
            Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
            return new CoercionError(actualType);
        }

        public static /* synthetic */ CoercionError copy$default(CoercionError coercionError, StaticType staticType, int n, Object object) {
            if ((n & 1) != 0) {
                staticType = coercionError.actualType;
            }
            return coercionError.copy(staticType);
        }

        @NotNull
        public String toString() {
            return "CoercionError(actualType=" + this.actualType + ')';
        }

        public int hashCode() {
            return this.actualType.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CoercionError)) {
                return false;
            }
            CoercionError coercionError = (CoercionError)other;
            return Intrinsics.areEqual((Object)this.actualType, (Object)coercionError.actualType);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/partiql/lang/ast/passes/SemanticProblemDetails$DuplicateAliasesInSelectListItem;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails;", "()V", "partiql-lang"})
    public static final class DuplicateAliasesInSelectListItem
    extends SemanticProblemDetails {
        @NotNull
        public static final DuplicateAliasesInSelectListItem INSTANCE = new DuplicateAliasesInSelectListItem();

        private DuplicateAliasesInSelectListItem() {
            super(ProblemSeverity.ERROR, 1.INSTANCE, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/partiql/lang/ast/passes/SemanticProblemDetails$NoSuchFunction;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails;", "functionName", "", "(Ljava/lang/String;)V", "getFunctionName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "partiql-lang"})
    public static final class NoSuchFunction
    extends SemanticProblemDetails {
        @NotNull
        private final String functionName;

        public NoSuchFunction(final @NotNull String functionName) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            super(ProblemSeverity.ERROR, (Function0)new Function0<String>(){

                @NotNull
                public final String invoke() {
                    return "No such function '" + functionName + '\'';
                }
            }, null);
            this.functionName = functionName;
        }

        @NotNull
        public final String getFunctionName() {
            return this.functionName;
        }

        @NotNull
        public final String component1() {
            return this.functionName;
        }

        @NotNull
        public final NoSuchFunction copy(@NotNull String functionName) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            return new NoSuchFunction(functionName);
        }

        public static /* synthetic */ NoSuchFunction copy$default(NoSuchFunction noSuchFunction, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = noSuchFunction.functionName;
            }
            return noSuchFunction.copy(string);
        }

        @NotNull
        public String toString() {
            return "NoSuchFunction(functionName=" + this.functionName + ')';
        }

        public int hashCode() {
            return this.functionName.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NoSuchFunction)) {
                return false;
            }
            NoSuchFunction noSuchFunction = (NoSuchFunction)other;
            return Intrinsics.areEqual((Object)this.functionName, (Object)noSuchFunction.functionName);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/partiql/lang/ast/passes/SemanticProblemDetails$IncompatibleDatatypesForOp;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails;", "actualArgumentTypes", "", "Lorg/partiql/types/StaticType;", "nAryOp", "", "(Ljava/util/List;Ljava/lang/String;)V", "getActualArgumentTypes", "()Ljava/util/List;", "getNAryOp", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "partiql-lang"})
    public static final class IncompatibleDatatypesForOp
    extends SemanticProblemDetails {
        @NotNull
        private final List<StaticType> actualArgumentTypes;
        @NotNull
        private final String nAryOp;

        public IncompatibleDatatypesForOp(final @NotNull List<? extends StaticType> actualArgumentTypes, final @NotNull String nAryOp) {
            Intrinsics.checkNotNullParameter(actualArgumentTypes, (String)"actualArgumentTypes");
            Intrinsics.checkNotNullParameter((Object)nAryOp, (String)"nAryOp");
            super(ProblemSeverity.ERROR, (Function0)new Function0<String>(){

                @NotNull
                public final String invoke() {
                    return StaticTypeExtensionsKt.stringWithoutNullMissing(actualArgumentTypes) + " is/are incompatible data types for the '" + nAryOp + "' operator.";
                }
            }, null);
            this.actualArgumentTypes = actualArgumentTypes;
            this.nAryOp = nAryOp;
        }

        @NotNull
        public final List<StaticType> getActualArgumentTypes() {
            return this.actualArgumentTypes;
        }

        @NotNull
        public final String getNAryOp() {
            return this.nAryOp;
        }

        @NotNull
        public final List<StaticType> component1() {
            return this.actualArgumentTypes;
        }

        @NotNull
        public final String component2() {
            return this.nAryOp;
        }

        @NotNull
        public final IncompatibleDatatypesForOp copy(@NotNull List<? extends StaticType> actualArgumentTypes, @NotNull String nAryOp) {
            Intrinsics.checkNotNullParameter(actualArgumentTypes, (String)"actualArgumentTypes");
            Intrinsics.checkNotNullParameter((Object)nAryOp, (String)"nAryOp");
            return new IncompatibleDatatypesForOp(actualArgumentTypes, nAryOp);
        }

        public static /* synthetic */ IncompatibleDatatypesForOp copy$default(IncompatibleDatatypesForOp incompatibleDatatypesForOp, List list, String string, int n, Object object) {
            if ((n & 1) != 0) {
                list = incompatibleDatatypesForOp.actualArgumentTypes;
            }
            if ((n & 2) != 0) {
                string = incompatibleDatatypesForOp.nAryOp;
            }
            return incompatibleDatatypesForOp.copy(list, string);
        }

        @NotNull
        public String toString() {
            return "IncompatibleDatatypesForOp(actualArgumentTypes=" + this.actualArgumentTypes + ", nAryOp=" + this.nAryOp + ')';
        }

        public int hashCode() {
            int result = ((Object)this.actualArgumentTypes).hashCode();
            result = result * 31 + this.nAryOp.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IncompatibleDatatypesForOp)) {
                return false;
            }
            IncompatibleDatatypesForOp incompatibleDatatypesForOp = (IncompatibleDatatypesForOp)other;
            if (!Intrinsics.areEqual(this.actualArgumentTypes, incompatibleDatatypesForOp.actualArgumentTypes)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.nAryOp, (Object)incompatibleDatatypesForOp.nAryOp);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/partiql/lang/ast/passes/SemanticProblemDetails$IncompatibleDataTypeForExpr;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails;", "expectedType", "Lorg/partiql/types/StaticType;", "actualType", "(Lorg/partiql/types/StaticType;Lorg/partiql/types/StaticType;)V", "getActualType", "()Lorg/partiql/types/StaticType;", "getExpectedType", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "partiql-lang"})
    public static final class IncompatibleDataTypeForExpr
    extends SemanticProblemDetails {
        @NotNull
        private final StaticType expectedType;
        @NotNull
        private final StaticType actualType;

        public IncompatibleDataTypeForExpr(final @NotNull StaticType expectedType, final @NotNull StaticType actualType) {
            Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
            Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
            super(ProblemSeverity.ERROR, (Function0)new Function0<String>(){

                @NotNull
                public final String invoke() {
                    return "In this context, " + expectedType + " is expected but expression returns " + actualType;
                }
            }, null);
            this.expectedType = expectedType;
            this.actualType = actualType;
        }

        @NotNull
        public final StaticType getExpectedType() {
            return this.expectedType;
        }

        @NotNull
        public final StaticType getActualType() {
            return this.actualType;
        }

        @NotNull
        public final StaticType component1() {
            return this.expectedType;
        }

        @NotNull
        public final StaticType component2() {
            return this.actualType;
        }

        @NotNull
        public final IncompatibleDataTypeForExpr copy(@NotNull StaticType expectedType, @NotNull StaticType actualType) {
            Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
            Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
            return new IncompatibleDataTypeForExpr(expectedType, actualType);
        }

        public static /* synthetic */ IncompatibleDataTypeForExpr copy$default(IncompatibleDataTypeForExpr incompatibleDataTypeForExpr, StaticType staticType, StaticType staticType2, int n, Object object) {
            if ((n & 1) != 0) {
                staticType = incompatibleDataTypeForExpr.expectedType;
            }
            if ((n & 2) != 0) {
                staticType2 = incompatibleDataTypeForExpr.actualType;
            }
            return incompatibleDataTypeForExpr.copy(staticType, staticType2);
        }

        @NotNull
        public String toString() {
            return "IncompatibleDataTypeForExpr(expectedType=" + this.expectedType + ", actualType=" + this.actualType + ')';
        }

        public int hashCode() {
            int result = this.expectedType.hashCode();
            result = result * 31 + this.actualType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IncompatibleDataTypeForExpr)) {
                return false;
            }
            IncompatibleDataTypeForExpr incompatibleDataTypeForExpr = (IncompatibleDataTypeForExpr)other;
            if (!Intrinsics.areEqual((Object)this.expectedType, (Object)incompatibleDataTypeForExpr.expectedType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.actualType, (Object)incompatibleDataTypeForExpr.actualType);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/partiql/lang/ast/passes/SemanticProblemDetails$ExpressionAlwaysReturnsMissing;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails;", "()V", "partiql-lang"})
    public static final class ExpressionAlwaysReturnsMissing
    extends SemanticProblemDetails {
        @NotNull
        public static final ExpressionAlwaysReturnsMissing INSTANCE = new ExpressionAlwaysReturnsMissing();

        private ExpressionAlwaysReturnsMissing() {
            super(ProblemSeverity.ERROR, 1.INSTANCE, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/partiql/lang/ast/passes/SemanticProblemDetails$ExpressionAlwaysReturnsNullOrMissing;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails;", "()V", "partiql-lang"})
    public static final class ExpressionAlwaysReturnsNullOrMissing
    extends SemanticProblemDetails {
        @NotNull
        public static final ExpressionAlwaysReturnsNullOrMissing INSTANCE = new ExpressionAlwaysReturnsNullOrMissing();

        private ExpressionAlwaysReturnsNullOrMissing() {
            super(ProblemSeverity.WARNING, 1.INSTANCE, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/partiql/lang/ast/passes/SemanticProblemDetails$InvalidArgumentTypeForFunction;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails;", "functionName", "", "expectedType", "Lorg/partiql/types/StaticType;", "actualType", "(Ljava/lang/String;Lorg/partiql/types/StaticType;Lorg/partiql/types/StaticType;)V", "getActualType", "()Lorg/partiql/types/StaticType;", "getExpectedType", "getFunctionName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "partiql-lang"})
    public static final class InvalidArgumentTypeForFunction
    extends SemanticProblemDetails {
        @NotNull
        private final String functionName;
        @NotNull
        private final StaticType expectedType;
        @NotNull
        private final StaticType actualType;

        public InvalidArgumentTypeForFunction(final @NotNull String functionName, final @NotNull StaticType expectedType, final @NotNull StaticType actualType) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
            Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
            super(ProblemSeverity.ERROR, (Function0)new Function0<String>(){

                @NotNull
                public final String invoke() {
                    return "Invalid argument type for " + functionName + ". Expected " + expectedType + " but got " + actualType;
                }
            }, null);
            this.functionName = functionName;
            this.expectedType = expectedType;
            this.actualType = actualType;
        }

        @NotNull
        public final String getFunctionName() {
            return this.functionName;
        }

        @NotNull
        public final StaticType getExpectedType() {
            return this.expectedType;
        }

        @NotNull
        public final StaticType getActualType() {
            return this.actualType;
        }

        @NotNull
        public final String component1() {
            return this.functionName;
        }

        @NotNull
        public final StaticType component2() {
            return this.expectedType;
        }

        @NotNull
        public final StaticType component3() {
            return this.actualType;
        }

        @NotNull
        public final InvalidArgumentTypeForFunction copy(@NotNull String functionName, @NotNull StaticType expectedType, @NotNull StaticType actualType) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
            Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
            return new InvalidArgumentTypeForFunction(functionName, expectedType, actualType);
        }

        public static /* synthetic */ InvalidArgumentTypeForFunction copy$default(InvalidArgumentTypeForFunction invalidArgumentTypeForFunction, String string, StaticType staticType, StaticType staticType2, int n, Object object) {
            if ((n & 1) != 0) {
                string = invalidArgumentTypeForFunction.functionName;
            }
            if ((n & 2) != 0) {
                staticType = invalidArgumentTypeForFunction.expectedType;
            }
            if ((n & 4) != 0) {
                staticType2 = invalidArgumentTypeForFunction.actualType;
            }
            return invalidArgumentTypeForFunction.copy(string, staticType, staticType2);
        }

        @NotNull
        public String toString() {
            return "InvalidArgumentTypeForFunction(functionName=" + this.functionName + ", expectedType=" + this.expectedType + ", actualType=" + this.actualType + ')';
        }

        public int hashCode() {
            int result = this.functionName.hashCode();
            result = result * 31 + this.expectedType.hashCode();
            result = result * 31 + this.actualType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InvalidArgumentTypeForFunction)) {
                return false;
            }
            InvalidArgumentTypeForFunction invalidArgumentTypeForFunction = (InvalidArgumentTypeForFunction)other;
            if (!Intrinsics.areEqual((Object)this.functionName, (Object)invalidArgumentTypeForFunction.functionName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.expectedType, (Object)invalidArgumentTypeForFunction.expectedType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.actualType, (Object)invalidArgumentTypeForFunction.actualType);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/partiql/lang/ast/passes/SemanticProblemDetails$NullOrMissingFunctionArgument;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails;", "functionName", "", "(Ljava/lang/String;)V", "getFunctionName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "partiql-lang"})
    public static final class NullOrMissingFunctionArgument
    extends SemanticProblemDetails {
        @NotNull
        private final String functionName;

        public NullOrMissingFunctionArgument(final @NotNull String functionName) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            super(ProblemSeverity.ERROR, (Function0)new Function0<String>(){

                @NotNull
                public final String invoke() {
                    return "Function " + functionName + " given an argument that will always be null or missing. As a result, this function call will always return null or missing.";
                }
            }, null);
            this.functionName = functionName;
        }

        @NotNull
        public final String getFunctionName() {
            return this.functionName;
        }

        @NotNull
        public final String component1() {
            return this.functionName;
        }

        @NotNull
        public final NullOrMissingFunctionArgument copy(@NotNull String functionName) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            return new NullOrMissingFunctionArgument(functionName);
        }

        public static /* synthetic */ NullOrMissingFunctionArgument copy$default(NullOrMissingFunctionArgument nullOrMissingFunctionArgument, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = nullOrMissingFunctionArgument.functionName;
            }
            return nullOrMissingFunctionArgument.copy(string);
        }

        @NotNull
        public String toString() {
            return "NullOrMissingFunctionArgument(functionName=" + this.functionName + ')';
        }

        public int hashCode() {
            return this.functionName.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NullOrMissingFunctionArgument)) {
                return false;
            }
            NullOrMissingFunctionArgument nullOrMissingFunctionArgument = (NullOrMissingFunctionArgument)other;
            return Intrinsics.areEqual((Object)this.functionName, (Object)nullOrMissingFunctionArgument.functionName);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/partiql/lang/ast/passes/SemanticProblemDetails$MissingAlias;", "Lorg/partiql/lang/ast/passes/SemanticProblemDetails;", "()V", "partiql-lang"})
    public static final class MissingAlias
    extends SemanticProblemDetails {
        @NotNull
        public static final MissingAlias INSTANCE = new MissingAlias();

        private MissingAlias() {
            super(ProblemSeverity.ERROR, 1.INSTANCE, null);
        }
    }
}

