/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.ast.passes.inference;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.errors.Problem;
import org.partiql.lang.ast.StaticTypeMeta;
import org.partiql.lang.domains.PartiqlAst;
import org.partiql.lang.domains.UtilKt;
import org.partiql.lang.errors.ProblemCollector;
import org.partiql.lang.eval.Bindings;
import org.partiql.lang.eval.visitors.StaticTypeInferenceVisitorTransform;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.lang.types.TypedOpParameter;
import org.partiql.types.StaticType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/partiql/lang/ast/passes/inference/StaticTypeInferencer;", "", "globalBindings", "Lorg/partiql/lang/eval/Bindings;", "Lorg/partiql/types/StaticType;", "customFunctionSignatures", "", "Lorg/partiql/lang/types/FunctionSignature;", "customTypedOpParameters", "", "", "Lorg/partiql/lang/types/TypedOpParameter;", "(Lorg/partiql/lang/eval/Bindings;Ljava/util/List;Ljava/util/Map;)V", "inferStaticType", "Lorg/partiql/lang/ast/passes/inference/StaticTypeInferencer$InferenceResult;", "node", "Lorg/partiql/lang/domains/PartiqlAst$Statement;", "InferenceResult", "partiql-lang"})
public final class StaticTypeInferencer {
    @NotNull
    private final Bindings<StaticType> globalBindings;
    @NotNull
    private final List<FunctionSignature> customFunctionSignatures;
    @NotNull
    private final Map<String, TypedOpParameter> customTypedOpParameters;

    public StaticTypeInferencer(@NotNull Bindings<StaticType> globalBindings, @NotNull List<FunctionSignature> customFunctionSignatures, @NotNull Map<String, TypedOpParameter> customTypedOpParameters) {
        Intrinsics.checkNotNullParameter(globalBindings, (String)"globalBindings");
        Intrinsics.checkNotNullParameter(customFunctionSignatures, (String)"customFunctionSignatures");
        Intrinsics.checkNotNullParameter(customTypedOpParameters, (String)"customTypedOpParameters");
        this.globalBindings = globalBindings;
        this.customFunctionSignatures = customFunctionSignatures;
        this.customTypedOpParameters = customTypedOpParameters;
    }

    @NotNull
    public final InferenceResult inferStaticType(@NotNull PartiqlAst.Statement node) {
        StaticTypeMeta staticTypeMeta;
        PartiqlAst.Statement transformedPartiqlAst;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ProblemCollector problemCollector = new ProblemCollector();
        StaticTypeInferenceVisitorTransform inferencer = new StaticTypeInferenceVisitorTransform(this.globalBindings, this.customFunctionSignatures, this.customTypedOpParameters, problemCollector);
        PartiqlAst.Statement statement = transformedPartiqlAst = inferencer.transformStatement(node);
        if (statement instanceof PartiqlAst.Statement.Query) {
            staticTypeMeta = UtilKt.getStaticType(((PartiqlAst.Statement.Query)transformedPartiqlAst).getExpr().getMetas());
            if (staticTypeMeta == null || (staticTypeMeta = staticTypeMeta.getType()) == null) {
                throw new IllegalStateException("Expected query's inferred StaticType to not be null".toString());
            }
        } else {
            if (((statement instanceof PartiqlAst.Statement.Dml ? true : statement instanceof PartiqlAst.Statement.Ddl) ? true : statement instanceof PartiqlAst.Statement.Explain) ? true : statement instanceof PartiqlAst.Statement.Exec) {
                throw new IllegalStateException("Type inference for DML, DDL, EXEC, and EXPLAIN statements is not currently supported".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        StaticTypeMeta inferredStaticType = staticTypeMeta;
        return problemCollector.getHasErrors() ? (InferenceResult)new InferenceResult.Failure((StaticType)inferredStaticType, transformedPartiqlAst, problemCollector.getProblems()) : (InferenceResult)new InferenceResult.Success((StaticType)inferredStaticType, problemCollector.getProblems());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lorg/partiql/lang/ast/passes/inference/StaticTypeInferencer$InferenceResult;", "", "()V", "problems", "", "Lorg/partiql/errors/Problem;", "getProblems", "()Ljava/util/List;", "Failure", "Success", "Lorg/partiql/lang/ast/passes/inference/StaticTypeInferencer$InferenceResult$Success;", "Lorg/partiql/lang/ast/passes/inference/StaticTypeInferencer$InferenceResult$Failure;", "partiql-lang"})
    public static abstract class InferenceResult {
        private InferenceResult() {
        }

        @NotNull
        public abstract List<Problem> getProblems();

        public /* synthetic */ InferenceResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/partiql/lang/ast/passes/inference/StaticTypeInferencer$InferenceResult$Success;", "Lorg/partiql/lang/ast/passes/inference/StaticTypeInferencer$InferenceResult;", "staticType", "Lorg/partiql/types/StaticType;", "problems", "", "Lorg/partiql/errors/Problem;", "(Lorg/partiql/types/StaticType;Ljava/util/List;)V", "getProblems", "()Ljava/util/List;", "getStaticType", "()Lorg/partiql/types/StaticType;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "partiql-lang"})
        public static final class Success
        extends InferenceResult {
            @NotNull
            private final StaticType staticType;
            @NotNull
            private final List<Problem> problems;

            public Success(@NotNull StaticType staticType, @NotNull List<Problem> problems) {
                Intrinsics.checkNotNullParameter((Object)staticType, (String)"staticType");
                Intrinsics.checkNotNullParameter(problems, (String)"problems");
                super(null);
                this.staticType = staticType;
                this.problems = problems;
            }

            @NotNull
            public final StaticType getStaticType() {
                return this.staticType;
            }

            @Override
            @NotNull
            public List<Problem> getProblems() {
                return this.problems;
            }

            @NotNull
            public final StaticType component1() {
                return this.staticType;
            }

            @NotNull
            public final List<Problem> component2() {
                return this.getProblems();
            }

            @NotNull
            public final Success copy(@NotNull StaticType staticType, @NotNull List<Problem> problems) {
                Intrinsics.checkNotNullParameter((Object)staticType, (String)"staticType");
                Intrinsics.checkNotNullParameter(problems, (String)"problems");
                return new Success(staticType, problems);
            }

            public static /* synthetic */ Success copy$default(Success success, StaticType staticType, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    staticType = success.staticType;
                }
                if ((n & 2) != 0) {
                    list = success.getProblems();
                }
                return success.copy(staticType, list);
            }

            @NotNull
            public String toString() {
                return "Success(staticType=" + this.staticType + ", problems=" + this.getProblems() + ')';
            }

            public int hashCode() {
                int result = this.staticType.hashCode();
                result = result * 31 + ((Object)this.getProblems()).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                if (!Intrinsics.areEqual((Object)this.staticType, (Object)success.staticType)) {
                    return false;
                }
                return Intrinsics.areEqual(this.getProblems(), success.getProblems());
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0011J\u000e\u0010\u0012\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u0013J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/partiql/lang/ast/passes/inference/StaticTypeInferencer$InferenceResult$Failure;", "Lorg/partiql/lang/ast/passes/inference/StaticTypeInferencer$InferenceResult;", "staticType", "Lorg/partiql/types/StaticType;", "partiqlAst", "Lorg/partiql/lang/domains/PartiqlAst$Statement;", "problems", "", "Lorg/partiql/errors/Problem;", "(Lorg/partiql/types/StaticType;Lorg/partiql/lang/domains/PartiqlAst$Statement;Ljava/util/List;)V", "getPartiqlAst$partiql_lang", "()Lorg/partiql/lang/domains/PartiqlAst$Statement;", "getProblems", "()Ljava/util/List;", "getStaticType$partiql_lang", "()Lorg/partiql/types/StaticType;", "component1", "component1$partiql_lang", "component2", "component2$partiql_lang", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "partiql-lang"})
        public static final class Failure
        extends InferenceResult {
            @NotNull
            private final StaticType staticType;
            @NotNull
            private final PartiqlAst.Statement partiqlAst;
            @NotNull
            private final List<Problem> problems;

            public Failure(@NotNull StaticType staticType, @NotNull PartiqlAst.Statement partiqlAst, @NotNull List<Problem> problems) {
                Intrinsics.checkNotNullParameter((Object)staticType, (String)"staticType");
                Intrinsics.checkNotNullParameter((Object)partiqlAst, (String)"partiqlAst");
                Intrinsics.checkNotNullParameter(problems, (String)"problems");
                super(null);
                this.staticType = staticType;
                this.partiqlAst = partiqlAst;
                this.problems = problems;
            }

            @NotNull
            public final StaticType getStaticType$partiql_lang() {
                return this.staticType;
            }

            @NotNull
            public final PartiqlAst.Statement getPartiqlAst$partiql_lang() {
                return this.partiqlAst;
            }

            @Override
            @NotNull
            public List<Problem> getProblems() {
                return this.problems;
            }

            @NotNull
            public final StaticType component1$partiql_lang() {
                return this.staticType;
            }

            @NotNull
            public final PartiqlAst.Statement component2$partiql_lang() {
                return this.partiqlAst;
            }

            @NotNull
            public final List<Problem> component3() {
                return this.getProblems();
            }

            @NotNull
            public final Failure copy(@NotNull StaticType staticType, @NotNull PartiqlAst.Statement partiqlAst, @NotNull List<Problem> problems) {
                Intrinsics.checkNotNullParameter((Object)staticType, (String)"staticType");
                Intrinsics.checkNotNullParameter((Object)partiqlAst, (String)"partiqlAst");
                Intrinsics.checkNotNullParameter(problems, (String)"problems");
                return new Failure(staticType, partiqlAst, problems);
            }

            public static /* synthetic */ Failure copy$default(Failure failure, StaticType staticType, PartiqlAst.Statement statement, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    staticType = failure.staticType;
                }
                if ((n & 2) != 0) {
                    statement = failure.partiqlAst;
                }
                if ((n & 4) != 0) {
                    list = failure.getProblems();
                }
                return failure.copy(staticType, statement, list);
            }

            @NotNull
            public String toString() {
                return "Failure(staticType=" + this.staticType + ", partiqlAst=" + this.partiqlAst + ", problems=" + this.getProblems() + ')';
            }

            public int hashCode() {
                int result = this.staticType.hashCode();
                result = result * 31 + this.partiqlAst.hashCode();
                result = result * 31 + ((Object)this.getProblems()).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failure)) {
                    return false;
                }
                Failure failure = (Failure)other;
                if (!Intrinsics.areEqual((Object)this.staticType, (Object)failure.staticType)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.partiqlAst, (Object)failure.partiqlAst)) {
                    return false;
                }
                return Intrinsics.areEqual(this.getProblems(), failure.getProblems());
            }
        }
    }
}

