/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.compiler;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.annotations.ExperimentalPartiQLCompilerPipeline;
import org.partiql.lang.compiler.PartiQLCompilerAsync;
import org.partiql.lang.compiler.PartiQLCompilerAsyncBuilder;
import org.partiql.lang.domains.PartiqlAst;
import org.partiql.lang.domains.PartiqlPhysical;
import org.partiql.lang.errors.PartiQLException;
import org.partiql.lang.eval.PartiQLStatementAsync;
import org.partiql.lang.planner.PartiQLPlanner;
import org.partiql.lang.planner.PartiQLPlannerBuilder;
import org.partiql.lang.syntax.Parser;
import org.partiql.lang.syntax.PartiQLParserBuilder;

@ExperimentalPartiQLCompilerPipeline
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lorg/partiql/lang/compiler/PartiQLCompilerPipelineAsync;", "", "parser", "Lorg/partiql/lang/syntax/Parser;", "planner", "Lorg/partiql/lang/planner/PartiQLPlanner;", "compiler", "Lorg/partiql/lang/compiler/PartiQLCompilerAsync;", "(Lorg/partiql/lang/syntax/Parser;Lorg/partiql/lang/planner/PartiQLPlanner;Lorg/partiql/lang/compiler/PartiQLCompilerAsync;)V", "compile", "Lorg/partiql/lang/eval/PartiQLStatementAsync;", "statement", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lorg/partiql/lang/domains/PartiqlAst$Statement;", "(Lorg/partiql/lang/domains/PartiqlAst$Statement;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lorg/partiql/lang/domains/PartiqlPhysical$Plan;", "details", "Lorg/partiql/lang/planner/PartiQLPlanner$PlanningDetails;", "(Lorg/partiql/lang/domains/PartiqlPhysical$Plan;Lorg/partiql/lang/planner/PartiQLPlanner$PlanningDetails;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Builder", "Companion", "partiql-lang"})
public final class PartiQLCompilerPipelineAsync {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Parser parser;
    @NotNull
    private final PartiQLPlanner planner;
    @NotNull
    private final PartiQLCompilerAsync compiler;

    public PartiQLCompilerPipelineAsync(@NotNull Parser parser, @NotNull PartiQLPlanner planner, @NotNull PartiQLCompilerAsync compiler) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)planner, (String)"planner");
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        this.parser = parser;
        this.planner = planner;
        this.compiler = compiler;
    }

    @Nullable
    public final Object compile(@NotNull String statement, @NotNull Continuation<? super PartiQLStatementAsync> $completion) {
        PartiqlAst.Statement ast = this.parser.parseAstStatement(statement);
        return this.compile(ast, $completion);
    }

    @Nullable
    public final Object compile(@NotNull PartiqlAst.Statement statement, @NotNull Continuation<? super PartiQLStatementAsync> $completion) {
        PartiQLPlanner.Result result = this.planner.plan(statement);
        if (result instanceof PartiQLPlanner.Result.Error) {
            throw new PartiQLException(((PartiQLPlanner.Result.Error)result).getProblems().toString());
        }
        PartiqlPhysical.Plan plan = ((PartiQLPlanner.Result.Success)result).getPlan();
        return this.compile(plan, ((PartiQLPlanner.Result.Success)result).getDetails(), $completion);
    }

    @JvmOverloads
    @Nullable
    public final Object compile(@NotNull PartiqlPhysical.Plan statement, @NotNull PartiQLPlanner.PlanningDetails details, @NotNull Continuation<? super PartiQLStatementAsync> $completion) {
        return this.compiler.compile(statement, details, $completion);
    }

    public static /* synthetic */ Object compile$default(PartiQLCompilerPipelineAsync partiQLCompilerPipelineAsync, PartiqlPhysical.Plan plan, PartiQLPlanner.PlanningDetails planningDetails, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            planningDetails = new PartiQLPlanner.PlanningDetails(null, null, null, null, null, null, 63, null);
        }
        return partiQLCompilerPipelineAsync.compile(plan, planningDetails, (Continuation<? super PartiQLStatementAsync>)continuation);
    }

    @JvmOverloads
    @Nullable
    public final Object compile(@NotNull PartiqlPhysical.Plan statement, @NotNull Continuation<? super PartiQLStatementAsync> $completion) {
        return PartiQLCompilerPipelineAsync.compile$default(this, statement, null, $completion, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final PartiQLCompilerPipelineAsync standard() {
        return Companion.standard();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tJ\b\u0010\n\u001a\u00020\u0004H\u0007\u00a8\u0006\u000b"}, d2={"Lorg/partiql/lang/compiler/PartiQLCompilerPipelineAsync$Companion;", "", "()V", "build", "Lorg/partiql/lang/compiler/PartiQLCompilerPipelineAsync;", "block", "Lkotlin/Function1;", "Lorg/partiql/lang/compiler/PartiQLCompilerPipelineAsync$Builder;", "", "Lkotlin/ExtensionFunctionType;", "standard", "partiql-lang"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PartiQLCompilerPipelineAsync standard() {
            return new PartiQLCompilerPipelineAsync(PartiQLParserBuilder.Companion.standard().build(), PartiQLPlannerBuilder.Companion.standard().build(), PartiQLCompilerAsyncBuilder.Companion.standard().build());
        }

        @NotNull
        public final PartiQLCompilerPipelineAsync build(@NotNull Function1<? super Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder builder = new Builder();
            block.invoke((Object)builder);
            return new PartiQLCompilerPipelineAsync(builder.getParser().build(), builder.getPlanner().build(), builder.getCompiler().build());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/partiql/lang/compiler/PartiQLCompilerPipelineAsync$Builder;", "", "()V", "compiler", "Lorg/partiql/lang/compiler/PartiQLCompilerAsyncBuilder;", "getCompiler", "()Lorg/partiql/lang/compiler/PartiQLCompilerAsyncBuilder;", "setCompiler", "(Lorg/partiql/lang/compiler/PartiQLCompilerAsyncBuilder;)V", "parser", "Lorg/partiql/lang/syntax/PartiQLParserBuilder;", "getParser", "()Lorg/partiql/lang/syntax/PartiQLParserBuilder;", "setParser", "(Lorg/partiql/lang/syntax/PartiQLParserBuilder;)V", "planner", "Lorg/partiql/lang/planner/PartiQLPlannerBuilder;", "getPlanner", "()Lorg/partiql/lang/planner/PartiQLPlannerBuilder;", "setPlanner", "(Lorg/partiql/lang/planner/PartiQLPlannerBuilder;)V", "partiql-lang"})
    public static final class Builder {
        @NotNull
        private PartiQLParserBuilder parser = PartiQLParserBuilder.Companion.standard();
        @NotNull
        private PartiQLPlannerBuilder planner = PartiQLPlannerBuilder.Companion.standard();
        @NotNull
        private PartiQLCompilerAsyncBuilder compiler = PartiQLCompilerAsyncBuilder.Companion.standard();

        @NotNull
        public final PartiQLParserBuilder getParser() {
            return this.parser;
        }

        public final void setParser(@NotNull PartiQLParserBuilder partiQLParserBuilder) {
            Intrinsics.checkNotNullParameter((Object)partiQLParserBuilder, (String)"<set-?>");
            this.parser = partiQLParserBuilder;
        }

        @NotNull
        public final PartiQLPlannerBuilder getPlanner() {
            return this.planner;
        }

        public final void setPlanner(@NotNull PartiQLPlannerBuilder partiQLPlannerBuilder) {
            Intrinsics.checkNotNullParameter((Object)partiQLPlannerBuilder, (String)"<set-?>");
            this.planner = partiQLPlannerBuilder;
        }

        @NotNull
        public final PartiQLCompilerAsyncBuilder getCompiler() {
            return this.compiler;
        }

        public final void setCompiler(@NotNull PartiQLCompilerAsyncBuilder partiQLCompilerAsyncBuilder) {
            Intrinsics.checkNotNullParameter((Object)partiQLCompilerAsyncBuilder, (String)"<set-?>");
            this.compiler = partiQLCompilerAsyncBuilder;
        }
    }
}

