/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.partiql.errors.ErrorCode;
import org.partiql.lang.eval.AnyOfCastTable;
import org.partiql.lang.eval.AnyOfCastTableKt;
import org.partiql.lang.eval.CastError;
import org.partiql.lang.eval.CastNil;
import org.partiql.lang.eval.CastResult;
import org.partiql.lang.eval.CastValue;
import org.partiql.lang.eval.EvaluationException;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.ExprValueType;
import org.partiql.lang.eval.StructOrdering;
import org.partiql.lang.types.StaticTypeUtils;
import org.partiql.types.AnyOfType;
import org.partiql.types.AnyType;
import org.partiql.types.CollectionType;
import org.partiql.types.SingleType;
import org.partiql.types.StaticType;
import org.partiql.types.StructType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BX\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005j\u0002`\u0007\u00121\u0010\b\u001a-\u0012\u0004\u0012\u00020\n\u0012#\u0012!\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\u000f0\t\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J5\u0010\u001b\u001a'\u0012#\u0012!\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\u000f0\u00132\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0011\u001a3\u0012\u0004\u0012\u00020\u0012\u0012)\u0012'\u0012#\u0012!\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\u000f0\u00130\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R#\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00130\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/partiql/lang/eval/AnyOfCastTable;", "", "anyOfType", "Lorg/partiql/types/AnyOfType;", "metas", "", "", "Lcom/amazon/ionelement/api/MetaContainer;", "singleTypeCast", "Lkotlin/Function1;", "Lorg/partiql/types/SingleType;", "Lorg/partiql/lang/eval/ExprValue;", "Lkotlin/ParameterName;", "name", "source", "Lorg/partiql/lang/eval/CastFunc;", "(Lorg/partiql/types/AnyOfType;Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "castFuncTable", "Lorg/partiql/lang/eval/ExprValueType;", "", "getCastFuncTable", "()Ljava/util/Map;", "castTypeTable", "getCastTypeTable", "cast", "firstCompatible", "sourceType", "getCasts", "typeErr", "", "message", "partiql-lang"})
public final class AnyOfCastTable {
    @NotNull
    private final AnyOfType anyOfType;
    @NotNull
    private final Map<String, Object> metas;
    @NotNull
    private final Map<ExprValueType, List<Function1<ExprValue, ExprValue>>> castFuncTable;
    @NotNull
    private final Map<ExprValueType, List<ExprValueType>> castTypeTable;

    /*
     * WARNING - void declaration
     */
    public AnyOfCastTable(@NotNull AnyOfType anyOfType, @NotNull Map<String, ? extends Object> metas, @NotNull Function1<? super SingleType, ? extends Function1<? super ExprValue, ? extends ExprValue>> singleTypeCast) {
        void $this$filterTo$iv$iv;
        Collection destination$iv$iv;
        Iterable $this$filter$iv;
        ExprValueType exprValueType;
        List destTypes;
        ExprValueType srcType;
        Collection collection;
        Map.Entry entry;
        Map.Entry<Object, Object> item$iv$iv;
        Map<ExprValueType, List<ExprValueType>> $this$mapTo$iv$iv;
        Map<ExprValueType, List<ExprValueType>> $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)anyOfType, (String)"anyOfType");
        Intrinsics.checkNotNullParameter(metas, (String)"metas");
        Intrinsics.checkNotNullParameter(singleTypeCast, (String)"singleTypeCast");
        this.anyOfType = anyOfType;
        this.metas = metas;
        Map typeMap = new LinkedHashMap();
        Object $this$forEach$iv = this.anyOfType.getTypes();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            StaticType it = (StaticType)element$iv;
            boolean bl = false;
            StaticType staticType = it;
            if (staticType instanceof AnyType) {
                this.typeErr("Union type cannot have ANY in it");
                throw new KotlinNothingValueException();
            }
            if (staticType instanceof AnyOfType) {
                this.typeErr("Union type cannot have a Union type in it");
                throw new KotlinNothingValueException();
            }
            if (!(staticType instanceof SingleType)) continue;
            ExprValueType runtimeType = StaticTypeUtils.getRuntimeType((SingleType)it);
            if (typeMap.containsKey((Object)runtimeType)) {
                this.typeErr("Duplicate core type in union type not supported (" + (Object)((Object)runtimeType) + ')');
                throw new KotlinNothingValueException();
            }
            typeMap.put(runtimeType, it);
            SingleType singleType = (SingleType)it;
            if (singleType instanceof CollectionType) {
                if (((CollectionType)it).getElementType() instanceof AnyType) continue;
                this.typeErr("Union type must have unconstrained container type (" + ((CollectionType)it).getElementType() + ')');
                throw new KotlinNothingValueException();
            }
            if (!(singleType instanceof StructType)) continue;
            if (!((Collection)((StructType)it).getFields()).isEmpty()) {
                this.typeErr("Union type must have no field constraints for struct (" + ((StructType)it).getFields());
                throw new KotlinNothingValueException();
            }
            if (!((StructType)it).getContentClosed()) continue;
            this.typeErr("Union type must not be closed");
            throw new KotlinNothingValueException();
        }
        $this$forEach$iv = AnyOfCastTableKt.access$getCAST_ANY_OF_PRECEDENCE_TABLE$p();
        AnyOfCastTable anyOfCastTable = this;
        boolean $i$f$map = false;
        iterator2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Map.Entry<Object, Object>> iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            entry = item$iv$iv = iterator3.next();
            collection = destination$iv$iv2;
            boolean bl = false;
            srcType = (ExprValueType)((Object)entry.getKey());
            destTypes = (List)entry.getValue();
            Iterable iterable = destTypes;
            exprValueType = srcType;
            boolean $i$f$filter = false;
            void var19_24 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ExprValueType t = (ExprValueType)((Object)element$iv$iv);
                boolean bl2 = false;
                if (!typeMap.containsKey((Object)t)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection.add(TuplesKt.to((Object)((Object)exprValueType), (Object)((List)destination$iv$iv)));
        }
        anyOfCastTable.castTypeTable = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        $this$map$iv = this.castTypeTable;
        anyOfCastTable = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            entry = item$iv$iv = iterator3.next();
            collection = destination$iv$iv2;
            boolean bl = false;
            srcType = (ExprValueType)((Object)entry.getKey());
            destTypes = (List)entry.getValue();
            $this$filter$iv = destTypes;
            exprValueType = srcType;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator4 = $this$forEach$iv$iv$iv.iterator();
            while (iterator4.hasNext()) {
                SingleType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator4.next();
                boolean bl3 = false;
                ExprValueType t = (ExprValueType)((Object)element$iv$iv);
                boolean bl4 = false;
                if ((SingleType)typeMap.get((Object)t) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$map2 = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                destination$iv$iv.add(singleTypeCast.invoke(item$iv$iv2));
            }
            collection.add(TuplesKt.to((Object)((Object)exprValueType), (Object)((List)destination$iv$iv)));
        }
        anyOfCastTable.castFuncTable = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
    }

    @NotNull
    public final Map<ExprValueType, List<Function1<ExprValue, ExprValue>>> getCastFuncTable() {
        return this.castFuncTable;
    }

    @NotNull
    public final Map<ExprValueType, List<ExprValueType>> getCastTypeTable() {
        return this.castTypeTable;
    }

    private final List<Function1<ExprValue, ExprValue>> getCasts(ExprValueType sourceType) {
        List<Function1<ExprValue, ExprValue>> list = this.castFuncTable.get((Object)sourceType);
        if (list == null) {
            throw new IllegalStateException("Missing type in union cast function table: " + (Object)((Object)sourceType));
        }
        return list;
    }

    private final ExprValueType firstCompatible(ExprValueType sourceType) {
        List<ExprValueType> list = this.castTypeTable.get((Object)sourceType);
        if (list == null) {
            throw new IllegalStateException("Missing type in union cast type table: " + (Object)((Object)sourceType));
        }
        List<ExprValueType> types = list;
        ExprValueType exprValueType = (ExprValueType)((Object)CollectionsKt.firstOrNull(types));
        if (exprValueType == null) {
            new CastNil(sourceType, this.metas).unwrap();
            throw new KotlinNothingValueException();
        }
        return exprValueType;
    }

    @NotNull
    public final ExprValue cast(@NotNull ExprValue source) {
        ExprValue exprValue2;
        block12: {
            block13: {
                block11: {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    if (!ExprValueExtensionsKt.isUnknown(source)) break block11;
                    exprValue2 = source;
                    break block12;
                }
                if (!source.getType().isSequence() && source.getType() != ExprValueType.STRUCT) break block13;
                ExprValueType targetType = this.firstCompatible(source.getType());
                Sequence children2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)source), (Function1)((Function1)new Function1<ExprValue, ExprValue>(this){
                    final /* synthetic */ AnyOfCastTable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final ExprValue invoke(@NotNull ExprValue it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.this$0.cast(it);
                    }
                }));
                switch (WhenMappings.$EnumSwitchMapping$0[targetType.ordinal()]) {
                    case 1: {
                        exprValue2 = ExprValue.Companion.newList((Sequence<? extends ExprValue>)children2);
                        break block12;
                    }
                    case 2: {
                        exprValue2 = ExprValue.Companion.newSexp((Sequence<? extends ExprValue>)children2);
                        break block12;
                    }
                    case 3: {
                        exprValue2 = ExprValue.Companion.newBag((Sequence<? extends ExprValue>)children2);
                        break block12;
                    }
                    case 4: {
                        if (source.getType() != ExprValueType.STRUCT) {
                            throw new IllegalStateException("Cannot cast from non-struct to struct");
                        }
                        exprValue2 = ExprValue.Companion.newStruct((Sequence<? extends ExprValue>)SequencesKt.map((Sequence)SequencesKt.zip((Sequence)children2, (Sequence)CollectionsKt.asSequence((Iterable)source)), (Function1)cast.1.INSTANCE), StructOrdering.UNORDERED);
                        break block12;
                    }
                    default: {
                        throw new IllegalStateException("Invalid collection target type: " + (Object)((Object)targetType));
                    }
                }
            }
            CastResult result = new CastNil(source.getType(), this.metas);
            for (Function1<ExprValue, ExprValue> castFunc2 : this.getCasts(source.getType())) {
                CastResult castResult = result;
                if (castResult instanceof CastNil ? true : castResult instanceof CastError) {
                    try {
                        result = new CastValue((ExprValue)castFunc2.invoke((Object)source));
                    }
                    catch (EvaluationException e) {
                        result = new CastError(e);
                    }
                    continue;
                }
                if (!(castResult instanceof CastValue)) continue;
            }
            exprValue2 = result.unwrap();
        }
        return exprValue2;
    }

    private final Void typeErr(String message) {
        ExceptionsKt.err(message, ErrorCode.SEMANTIC_UNION_TYPE_INVALID, ExceptionsKt.errorContextFrom(this.metas), true);
        throw new KotlinNothingValueException();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExprValueType.values().length];
            nArray[ExprValueType.LIST.ordinal()] = 1;
            nArray[ExprValueType.SEXP.ordinal()] = 2;
            nArray[ExprValueType.BAG.ordinal()] = 3;
            nArray[ExprValueType.STRUCT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

