/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval;

import com.amazon.ion.IntegerSize;
import com.amazon.ion.IonBlob;
import com.amazon.ion.IonBool;
import com.amazon.ion.IonClob;
import com.amazon.ion.IonDecimal;
import com.amazon.ion.IonFloat;
import com.amazon.ion.IonInt;
import com.amazon.ion.IonList;
import com.amazon.ion.IonNull;
import com.amazon.ion.IonString;
import com.amazon.ion.IonStruct;
import com.amazon.ion.IonSymbol;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonTimestamp;
import com.amazon.ion.IonType;
import com.amazon.ion.IonValue;
import com.amazon.ion.Timestamp;
import com.amazon.ion.system.IonSystemBuilder;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.errors.ErrorCode;
import org.partiql.errors.Property;
import org.partiql.errors.PropertyValueMap;
import org.partiql.lang.ast.SourceLocationMeta;
import org.partiql.lang.eval.Addressed;
import org.partiql.lang.eval.Bindings;
import org.partiql.lang.eval.EvaluationException;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueType;
import org.partiql.lang.eval.Named;
import org.partiql.lang.eval.NamedExprValue;
import org.partiql.lang.eval.NaturalExprValueComparators;
import org.partiql.lang.eval.OrderedBindNames;
import org.partiql.lang.eval.OrdinalBindings;
import org.partiql.lang.eval.Scalar;
import org.partiql.lang.eval.StructExprValue;
import org.partiql.lang.eval.TypedOpBehavior;
import org.partiql.lang.eval.time.Time;
import org.partiql.lang.graph.Graph;
import org.partiql.lang.syntax.impl.DateTimePart;
import org.partiql.lang.types.StaticTypeUtils;
import org.partiql.lang.util.ConfigurableExprValueFormatter;
import org.partiql.lang.util.FacetExtensionsKt;
import org.partiql.lang.util.NumberExtensionsKt;
import org.partiql.lang.util.TimeExtensionsKt;
import org.partiql.types.BagType;
import org.partiql.types.BlobType;
import org.partiql.types.BoolType;
import org.partiql.types.ClobType;
import org.partiql.types.DateType;
import org.partiql.types.DecimalType;
import org.partiql.types.FloatType;
import org.partiql.types.IntType;
import org.partiql.types.ListType;
import org.partiql.types.MissingType;
import org.partiql.types.NullType;
import org.partiql.types.NumberConstraint;
import org.partiql.types.SexpType;
import org.partiql.types.SingleType;
import org.partiql.types.StringType;
import org.partiql.types.SymbolType;
import org.partiql.types.TimeType;
import org.partiql.types.TimestampType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u00c8\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001c0\u001bH\u0000\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\u0011\u001a\f\u0010\u001f\u001a\u00020 *\u00020\u0011H\u0000\u001a\n\u0010!\u001a\u00020\u001c*\u00020\u0011\u001a\n\u0010\"\u001a\u00020#*\u00020\u0011\u001a,\u0010$\u001a\u00020\u0011*\u00020\u00112\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,\u001a\u0015\u0010-\u001a\u00020.*\u00020\u00112\u0006\u0010/\u001a\u00020\u0011H\u0086\u0002\u001a\f\u00100\u001a\u000201*\u00020\u0011H\u0000\u001a\n\u00102\u001a\u000203*\u00020\u0011\u001a\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u001105*\b\u0012\u0004\u0012\u00020\u001105\u001a\u0012\u00106\u001a\u00020\u001c*\u00020\u00112\u0006\u0010/\u001a\u00020\u0011\u001a\f\u00107\u001a\u00020.*\u00020\u0011H\u0000\u001a\u0014\u00108\u001a\u00020\u001c*\u00020\u00112\u0006\u0010/\u001a\u00020\u0011H\u0000\u001a\f\u00109\u001a\u00020\u001c*\u00020\u0011H\u0000\u001a\f\u0010:\u001a\u00020\u001c*\u00020\u0011H\u0000\u001a\f\u0010;\u001a\u00020<*\u00020\u0011H\u0000\u001a\u001c\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020.0>*\b\u0012\u0004\u0012\u00020\u001105\u001a\u0012\u0010?\u001a\u00020\u0011*\u00020\u00112\u0006\u0010@\u001a\u00020\u0011\u001a\f\u0010A\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\n\u0010B\u001a\u00020C*\u00020\u0011\u001a\u0018\u0010D\u001a\u00020\u0011*\u00020\u00112\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00010\u0017\u001a\u0010\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00110G*\u00020\u0011\u001a\n\u0010H\u001a\u00020\u0001*\u00020\u0011\u001a\n\u0010I\u001a\u00020\u0001*\u00020\u0011\u001a\n\u0010J\u001a\u00020K*\u00020\u0011\u001a\n\u0010L\u001a\u00020M*\u00020\u0011\u001a\u0014\u0010N\u001a\u00020O*\u00020\u00112\u0006\u0010P\u001a\u00020QH\u0002\u001a\u0012\u0010R\u001a\u00020S*\u00020\u00112\u0006\u0010P\u001a\u00020Q\u001a\n\u0010T\u001a\u00020\u0011*\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u0011*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\"\u001d\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0017*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006U"}, d2={"BAG_ANNOTATION", "", "DATE_ANNOTATION", "DEFAULT_COMPARATOR", "Lorg/partiql/lang/eval/NaturalExprValueComparators;", "getDEFAULT_COMPARATOR", "()Lorg/partiql/lang/eval/NaturalExprValueComparators;", "GRAPH_ANNOTATION", "ION_TEXT_STRING_CAST_TYPES", "", "Lorg/partiql/lang/eval/ExprValueType;", "MISSING_ANNOTATION", "TIME_ANNOTATION", "datePatternRegex", "Lkotlin/text/Regex;", "genericTimeRegex", "address", "Lorg/partiql/lang/eval/ExprValue;", "getAddress", "(Lorg/partiql/lang/eval/ExprValue;)Lorg/partiql/lang/eval/ExprValue;", "name", "getName", "orderedNames", "", "getOrderedNames", "(Lorg/partiql/lang/eval/ExprValue;)Ljava/util/List;", "createUniqueExprValueFilter", "Lkotlin/Function1;", "", "asNamed", "Lorg/partiql/lang/eval/Named;", "bigDecimalValue", "Ljava/math/BigDecimal;", "booleanValue", "bytesValue", "", "cast", "targetType", "Lorg/partiql/types/SingleType;", "typedOpBehavior", "Lorg/partiql/lang/eval/TypedOpBehavior;", "locationMeta", "Lorg/partiql/lang/ast/SourceLocationMeta;", "defaultTimezoneOffset", "Ljava/time/ZoneOffset;", "compareTo", "", "other", "dateTimePartValue", "Lorg/partiql/lang/syntax/impl/DateTimePart;", "dateValue", "Ljava/time/LocalDate;", "distinct", "Lkotlin/sequences/Sequence;", "exprEquals", "intValue", "isDirectlyComparableTo", "isNotUnknown", "isUnknown", "longValue", "", "multiplicities", "Ljava/util/TreeMap;", "namedValue", "nameValue", "normalizeForCastToInt", "numberValue", "", "orderedNamesValue", "names", "rangeOver", "", "stringValue", "stringify", "timeValue", "Lorg/partiql/lang/eval/time/Time;", "timestampValue", "Lcom/amazon/ion/Timestamp;", "toIonStruct", "Lcom/amazon/ion/IonStruct;", "ion", "Lcom/amazon/ion/IonSystem;", "toIonValue", "Lcom/amazon/ion/IonValue;", "unnamedValue", "partiql-lang"})
public final class ExprValueExtensionsKt {
    @NotNull
    public static final String MISSING_ANNOTATION = "$missing";
    @NotNull
    public static final String BAG_ANNOTATION = "$bag";
    @NotNull
    public static final String DATE_ANNOTATION = "$date";
    @NotNull
    public static final String TIME_ANNOTATION = "$time";
    @NotNull
    public static final String GRAPH_ANNOTATION = "$graph";
    @NotNull
    private static final NaturalExprValueComparators DEFAULT_COMPARATOR = NaturalExprValueComparators.NULLS_FIRST_ASC;
    @NotNull
    private static final Set<ExprValueType> ION_TEXT_STRING_CAST_TYPES;
    @NotNull
    private static final Regex datePatternRegex;
    @NotNull
    private static final Regex genericTimeRegex;

    @NotNull
    public static final ExprValue orderedNamesValue(@NotNull ExprValue $this$orderedNamesValue, @NotNull List<String> names) {
        Intrinsics.checkNotNullParameter((Object)$this$orderedNamesValue, (String)"<this>");
        Intrinsics.checkNotNullParameter(names, (String)"names");
        return new ExprValue($this$orderedNamesValue, names){
            private final /* synthetic */ ExprValue $$delegate_0;
            @NotNull
            private final List<String> orderedNames;
            final /* synthetic */ ExprValue $this_orderedNamesValue;
            {
                this.$this_orderedNamesValue = $receiver;
                this.$$delegate_0 = $receiver;
                this.orderedNames = $names;
            }

            @NotNull
            public Bindings<ExprValue> getBindings() {
                return this.$$delegate_0.getBindings();
            }

            @NotNull
            public Graph getGraphValue() {
                return this.$$delegate_0.getGraphValue();
            }

            @NotNull
            public OrdinalBindings getOrdinalBindings() {
                return this.$$delegate_0.getOrdinalBindings();
            }

            @NotNull
            public Scalar getScalar() {
                return this.$$delegate_0.getScalar();
            }

            @NotNull
            public ExprValueType getType() {
                return this.$$delegate_0.getType();
            }

            @NotNull
            public Iterator<ExprValue> iterator() {
                return this.$$delegate_0.iterator();
            }

            @NotNull
            public List<String> getOrderedNames() {
                return this.orderedNames;
            }

            @Nullable
            public <T> T asFacet(@Nullable Class<T> type) {
                Object object = FacetExtensionsKt.downcast(this, type);
                if (object == null) {
                    object = this.$this_orderedNamesValue.asFacet(type);
                }
                return object;
            }

            @NotNull
            public String toString() {
                return ExprValueExtensionsKt.stringify(this);
            }
        };
    }

    @Nullable
    public static final List<String> getOrderedNames(@NotNull ExprValue $this$orderedNames) {
        Intrinsics.checkNotNullParameter((Object)$this$orderedNames, (String)"<this>");
        OrderedBindNames orderedBindNames2 = (OrderedBindNames)$this$orderedNames.asFacet(OrderedBindNames.class);
        return orderedBindNames2 != null ? orderedBindNames2.getOrderedNames() : null;
    }

    @NotNull
    public static final Named asNamed(@NotNull ExprValue $this$asNamed) {
        Intrinsics.checkNotNullParameter((Object)$this$asNamed, (String)"<this>");
        return new Named($this$asNamed){
            final /* synthetic */ ExprValue $this_asNamed;
            {
                this.$this_asNamed = $receiver;
            }

            @NotNull
            public ExprValue getName() {
                return this.$this_asNamed;
            }
        };
    }

    @NotNull
    public static final ExprValue namedValue(@NotNull ExprValue $this$namedValue, @NotNull ExprValue nameValue) {
        Intrinsics.checkNotNullParameter((Object)$this$namedValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)nameValue, (String)"nameValue");
        return new NamedExprValue(nameValue, $this$namedValue);
    }

    @NotNull
    public static final ExprValue unnamedValue(@NotNull ExprValue $this$unnamedValue) {
        Intrinsics.checkNotNullParameter((Object)$this$unnamedValue, (String)"<this>");
        return (Named)$this$unnamedValue.asFacet(Named.class) == null ? $this$unnamedValue : (ExprValue)new ExprValue($this$unnamedValue){
            private final /* synthetic */ ExprValue $$delegate_0;
            final /* synthetic */ ExprValue $this_unnamedValue;
            {
                this.$this_unnamedValue = $receiver;
                this.$$delegate_0 = $receiver;
            }

            @NotNull
            public Bindings<ExprValue> getBindings() {
                return this.$$delegate_0.getBindings();
            }

            @NotNull
            public Graph getGraphValue() {
                return this.$$delegate_0.getGraphValue();
            }

            @NotNull
            public OrdinalBindings getOrdinalBindings() {
                return this.$$delegate_0.getOrdinalBindings();
            }

            @NotNull
            public Scalar getScalar() {
                return this.$$delegate_0.getScalar();
            }

            @NotNull
            public ExprValueType getType() {
                return this.$$delegate_0.getType();
            }

            @NotNull
            public Iterator<ExprValue> iterator() {
                return this.$$delegate_0.iterator();
            }

            @Nullable
            public <T> T asFacet(@Nullable Class<T> type) {
                return (T)(Intrinsics.areEqual(type, Named.class) ? null : this.$this_unnamedValue.asFacet(type));
            }

            @NotNull
            public String toString() {
                return ExprValueExtensionsKt.stringify(this);
            }
        };
    }

    @Nullable
    public static final ExprValue getName(@NotNull ExprValue $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        Named named = (Named)$this$name.asFacet(Named.class);
        return named != null ? named.getName() : null;
    }

    @Nullable
    public static final ExprValue getAddress(@NotNull ExprValue $this$address) {
        Intrinsics.checkNotNullParameter((Object)$this$address, (String)"<this>");
        Addressed addressed = (Addressed)$this$address.asFacet(Addressed.class);
        return addressed != null ? addressed.getAddress() : null;
    }

    public static final boolean booleanValue(@NotNull ExprValue $this$booleanValue) {
        Intrinsics.checkNotNullParameter((Object)$this$booleanValue, (String)"<this>");
        Boolean bl = $this$booleanValue.getScalar().booleanValue();
        if (bl == null) {
            ExceptionsKt.errNoContext("Expected boolean: " + $this$booleanValue, ErrorCode.EVALUATOR_UNEXPECTED_VALUE_TYPE, false);
            throw new KotlinNothingValueException();
        }
        return bl;
    }

    @NotNull
    public static final Number numberValue(@NotNull ExprValue $this$numberValue) {
        Intrinsics.checkNotNullParameter((Object)$this$numberValue, (String)"<this>");
        Number number = $this$numberValue.getScalar().numberValue();
        if (number == null) {
            ExceptionsKt.errNoContext("Expected number: " + $this$numberValue, ErrorCode.EVALUATOR_UNEXPECTED_VALUE_TYPE, false);
            throw new KotlinNothingValueException();
        }
        return number;
    }

    @NotNull
    public static final LocalDate dateValue(@NotNull ExprValue $this$dateValue) {
        Intrinsics.checkNotNullParameter((Object)$this$dateValue, (String)"<this>");
        LocalDate localDate = $this$dateValue.getScalar().dateValue();
        if (localDate == null) {
            ExceptionsKt.errNoContext("Expected date: " + $this$dateValue, ErrorCode.EVALUATOR_UNEXPECTED_VALUE_TYPE, false);
            throw new KotlinNothingValueException();
        }
        return localDate;
    }

    @NotNull
    public static final Time timeValue(@NotNull ExprValue $this$timeValue) {
        Intrinsics.checkNotNullParameter((Object)$this$timeValue, (String)"<this>");
        Time time = $this$timeValue.getScalar().timeValue();
        if (time == null) {
            ExceptionsKt.errNoContext("Expected time: " + $this$timeValue, ErrorCode.EVALUATOR_UNEXPECTED_VALUE_TYPE, false);
            throw new KotlinNothingValueException();
        }
        return time;
    }

    @NotNull
    public static final Timestamp timestampValue(@NotNull ExprValue $this$timestampValue) {
        Intrinsics.checkNotNullParameter((Object)$this$timestampValue, (String)"<this>");
        Timestamp timestamp = $this$timestampValue.getScalar().timestampValue();
        if (timestamp == null) {
            ExceptionsKt.errNoContext("Expected timestamp: " + $this$timestampValue, ErrorCode.EVALUATOR_UNEXPECTED_VALUE_TYPE, false);
            throw new KotlinNothingValueException();
        }
        return timestamp;
    }

    @NotNull
    public static final String stringValue(@NotNull ExprValue $this$stringValue) {
        Intrinsics.checkNotNullParameter((Object)$this$stringValue, (String)"<this>");
        String string = $this$stringValue.getScalar().stringValue();
        if (string == null) {
            ExceptionsKt.errNoContext("Expected string: " + $this$stringValue, ErrorCode.EVALUATOR_UNEXPECTED_VALUE_TYPE, false);
            throw new KotlinNothingValueException();
        }
        return string;
    }

    @NotNull
    public static final byte[] bytesValue(@NotNull ExprValue $this$bytesValue) {
        Intrinsics.checkNotNullParameter((Object)$this$bytesValue, (String)"<this>");
        byte[] byArray = $this$bytesValue.getScalar().bytesValue();
        if (byArray == null) {
            ExceptionsKt.errNoContext("Expected byte array: " + $this$bytesValue, ErrorCode.EVALUATOR_UNEXPECTED_VALUE_TYPE, false);
            throw new KotlinNothingValueException();
        }
        return byArray;
    }

    @NotNull
    public static final DateTimePart dateTimePartValue(@NotNull ExprValue $this$dateTimePartValue) {
        DateTimePart dateTimePart;
        Intrinsics.checkNotNullParameter((Object)$this$dateTimePartValue, (String)"<this>");
        try {
            String string = ExprValueExtensionsKt.stringValue($this$dateTimePartValue).toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase()");
            dateTimePart = DateTimePart.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            String string = "invalid datetime part, valid values: [" + ArraysKt.joinToString$default((Object[])DateTimePart.values(), null, null, null, (int)0, null, null, (int)63, null) + ']';
            ErrorCode errorCode = ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_DATE_PART;
            throw new EvaluationException(string, errorCode, null, e, false, 4, null);
        }
        return dateTimePart;
    }

    public static final int intValue(@NotNull ExprValue $this$intValue) {
        Intrinsics.checkNotNullParameter((Object)$this$intValue, (String)"<this>");
        return ExprValueExtensionsKt.numberValue($this$intValue).intValue();
    }

    public static final long longValue(@NotNull ExprValue $this$longValue) {
        Intrinsics.checkNotNullParameter((Object)$this$longValue, (String)"<this>");
        return ExprValueExtensionsKt.numberValue($this$longValue).longValue();
    }

    @NotNull
    public static final BigDecimal bigDecimalValue(@NotNull ExprValue $this$bigDecimalValue) {
        Intrinsics.checkNotNullParameter((Object)$this$bigDecimalValue, (String)"<this>");
        return new BigDecimal(ExprValueExtensionsKt.numberValue($this$bigDecimalValue).toString());
    }

    @NotNull
    public static final Iterable<ExprValue> rangeOver(@NotNull ExprValue $this$rangeOver) {
        Intrinsics.checkNotNullParameter((Object)$this$rangeOver, (String)"<this>");
        return $this$rangeOver.getType().isRangedFrom() ? (Iterable)$this$rangeOver : (Iterable)CollectionsKt.listOf((Object)ExprValueExtensionsKt.unnamedValue($this$rangeOver));
    }

    @NotNull
    public static final String stringify(@NotNull ExprValue $this$stringify) {
        Intrinsics.checkNotNullParameter((Object)$this$stringify, (String)"<this>");
        return ConfigurableExprValueFormatter.Companion.getStandard().format($this$stringify);
    }

    @NotNull
    public static final NaturalExprValueComparators getDEFAULT_COMPARATOR() {
        return DEFAULT_COMPARATOR;
    }

    public static final boolean exprEquals(@NotNull ExprValue $this$exprEquals, @NotNull ExprValue other) {
        Intrinsics.checkNotNullParameter((Object)$this$exprEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return DEFAULT_COMPARATOR.compare($this$exprEquals, other) == 0;
    }

    public static final int compareTo(@NotNull ExprValue $this$compareTo, @NotNull ExprValue other) {
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if ($this$compareTo.getType().isUnknown() || other.getType().isUnknown()) {
            throw new EvaluationException("Null value cannot be compared: " + $this$compareTo + ", " + other, ErrorCode.EVALUATOR_INVALID_COMPARISION, null, null, false, 12, null);
        }
        if (!ExprValueExtensionsKt.isDirectlyComparableTo($this$compareTo, other)) {
            ExceptionsKt.errNoContext("Cannot compare values: " + $this$compareTo + ", " + other, ErrorCode.EVALUATOR_INVALID_COMPARISION, false);
            throw new KotlinNothingValueException();
        }
        return DEFAULT_COMPARATOR.compare($this$compareTo, other);
    }

    public static final boolean isDirectlyComparableTo(@NotNull ExprValue $this$isDirectlyComparableTo, @NotNull ExprValue other) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectlyComparableTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$isDirectlyComparableTo.getType() == ExprValueType.TIME && other.getType() == ExprValueType.TIME ? ExprValueExtensionsKt.timeValue($this$isDirectlyComparableTo).isDirectlyComparableTo(ExprValueExtensionsKt.timeValue(other)) : $this$isDirectlyComparableTo.getType().isDirectlyComparableTo(other.getType());
    }

    @NotNull
    public static final ExprValue cast(@NotNull ExprValue $this$cast, @NotNull SingleType targetType, @NotNull TypedOpBehavior typedOpBehavior, @Nullable SourceLocationMeta locationMeta, @NotNull ZoneOffset defaultTimezoneOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$cast, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)((Object)typedOpBehavior), (String)"typedOpBehavior");
        Intrinsics.checkNotNullParameter((Object)defaultTimezoneOffset, (String)"defaultTimezoneOffset");
        BigDecimal longMaxDecimal = NumberExtensionsKt.bigDecimalOf$default(Long.MAX_VALUE, null, 2, null);
        BigDecimal longMinDecimal = NumberExtensionsKt.bigDecimalOf$default(Long.MIN_VALUE, null, 2, null);
        if ($this$cast.getType().isUnknown() && targetType instanceof MissingType) {
            return ExprValue.Companion.getMissingValue();
        }
        if ($this$cast.getType().isUnknown() && targetType instanceof NullType) {
            return ExprValue.Companion.getNullValue();
        }
        if ($this$cast.getType().isUnknown()) {
            return $this$cast;
        }
        if ($this$cast.getType() == StaticTypeUtils.getRuntimeType(targetType) && $this$cast.getType() != ExprValueType.TIME) {
            SingleType singleType = targetType;
            return ((singleType instanceof IntType ? true : singleType instanceof FloatType) ? true : singleType instanceof DecimalType) ? ExprValueExtensionsKt.cast$exprValue(ExprValueExtensionsKt.numberValue($this$cast), typedOpBehavior, longMinDecimal, longMaxDecimal, locationMeta, $this$cast, targetType, targetType) : (singleType instanceof StringType ? ExprValueExtensionsKt.cast$exprValue-4(ExprValueExtensionsKt.stringValue($this$cast), typedOpBehavior, locationMeta, $this$cast, targetType, targetType) : $this$cast);
        }
        SingleType singleType = targetType;
        if (singleType instanceof BoolType) {
            if ($this$cast.getType().isNumber()) {
                return NumberExtensionsKt.compareTo(ExprValueExtensionsKt.numberValue($this$cast), 0L) == 0 ? ExprValue.Companion.newBoolean(false) : ExprValue.Companion.newBoolean(true);
            }
            if ($this$cast.getType().isText()) {
                ExprValue exprValue2;
                String string = ExprValueExtensionsKt.stringValue($this$cast).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                String string2 = string;
                if (Intrinsics.areEqual((Object)string2, (Object)"true")) {
                    exprValue2 = ExprValue.Companion.newBoolean(true);
                } else if (Intrinsics.areEqual((Object)string2, (Object)"false")) {
                    exprValue2 = ExprValue.Companion.newBoolean(false);
                } else {
                    ExprValueExtensionsKt.cast$castFailedErr$default(locationMeta, $this$cast, targetType, "can't convert string value to BOOL", false, null, 32, null);
                    throw new KotlinNothingValueException();
                }
                return exprValue2;
            }
        } else if (singleType instanceof IntType) {
            if ($this$cast.getType() == ExprValueType.BOOL) {
                return ExprValueExtensionsKt.booleanValue($this$cast) ? ExprValueExtensionsKt.cast$exprValue(1L, typedOpBehavior, longMinDecimal, longMaxDecimal, locationMeta, $this$cast, targetType, targetType) : ExprValueExtensionsKt.cast$exprValue(0L, typedOpBehavior, longMinDecimal, longMaxDecimal, locationMeta, $this$cast, targetType, targetType);
            }
            if ($this$cast.getType().isNumber()) {
                return ExprValueExtensionsKt.cast$exprValue(ExprValueExtensionsKt.numberValue($this$cast), typedOpBehavior, longMinDecimal, longMaxDecimal, locationMeta, $this$cast, targetType, targetType);
            }
            if ($this$cast.getType().isText()) {
                return ExprValueExtensionsKt.cast$exprValue(ExprValueExtensionsKt.cast$parseToLong(locationMeta, $this$cast, targetType, ExprValueExtensionsKt.stringValue($this$cast)), typedOpBehavior, longMinDecimal, longMaxDecimal, locationMeta, $this$cast, targetType, targetType);
            }
        } else if (singleType instanceof FloatType) {
            if ($this$cast.getType() == ExprValueType.BOOL) {
                return ExprValueExtensionsKt.booleanValue($this$cast) ? ExprValueExtensionsKt.cast$exprValue(1.0, typedOpBehavior, longMinDecimal, longMaxDecimal, locationMeta, $this$cast, targetType, targetType) : ExprValueExtensionsKt.cast$exprValue(0.0, typedOpBehavior, longMinDecimal, longMaxDecimal, locationMeta, $this$cast, targetType, targetType);
            }
            if ($this$cast.getType().isNumber()) {
                return ExprValueExtensionsKt.cast$exprValue(ExprValueExtensionsKt.numberValue($this$cast).doubleValue(), typedOpBehavior, longMinDecimal, longMaxDecimal, locationMeta, $this$cast, targetType, targetType);
            }
            if ($this$cast.getType().isText()) {
                try {
                    return ExprValueExtensionsKt.cast$exprValue(Double.parseDouble(ExprValueExtensionsKt.stringValue($this$cast)), typedOpBehavior, longMinDecimal, longMaxDecimal, locationMeta, $this$cast, targetType, targetType);
                }
                catch (NumberFormatException e) {
                    ExprValueExtensionsKt.cast$castFailedErr(locationMeta, $this$cast, targetType, "can't convert string value to FLOAT", false, e);
                    throw new KotlinNothingValueException();
                }
            }
        } else if (singleType instanceof DecimalType) {
            if ($this$cast.getType() == ExprValueType.BOOL) {
                ExprValue exprValue3;
                if (ExprValueExtensionsKt.booleanValue($this$cast)) {
                    BigDecimal bigDecimal = BigDecimal.ONE;
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ONE");
                    exprValue3 = ExprValueExtensionsKt.cast$exprValue(bigDecimal, typedOpBehavior, longMinDecimal, longMaxDecimal, locationMeta, $this$cast, targetType, targetType);
                } else {
                    BigDecimal bigDecimal = BigDecimal.ZERO;
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
                    exprValue3 = ExprValueExtensionsKt.cast$exprValue(bigDecimal, typedOpBehavior, longMinDecimal, longMaxDecimal, locationMeta, $this$cast, targetType, targetType);
                }
                return exprValue3;
            }
            if ($this$cast.getType().isNumber()) {
                return ExprValueExtensionsKt.cast$exprValue(ExprValueExtensionsKt.numberValue($this$cast), typedOpBehavior, longMinDecimal, longMaxDecimal, locationMeta, $this$cast, targetType, targetType);
            }
            if ($this$cast.getType().isText()) {
                try {
                    return ExprValueExtensionsKt.cast$exprValue(NumberExtensionsKt.bigDecimalOf$default(ExprValueExtensionsKt.stringValue($this$cast), null, 2, null), typedOpBehavior, longMinDecimal, longMaxDecimal, locationMeta, $this$cast, targetType, targetType);
                }
                catch (NumberFormatException e) {
                    ExprValueExtensionsKt.cast$castFailedErr(locationMeta, $this$cast, targetType, "can't convert string value to DECIMAL", false, e);
                    throw new KotlinNothingValueException();
                }
            }
        } else if (singleType instanceof TimestampType) {
            if ($this$cast.getType().isText()) {
                try {
                    Timestamp timestamp = Timestamp.valueOf((CharSequence)ExprValueExtensionsKt.stringValue($this$cast));
                    Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"valueOf(stringValue())");
                    return ExprValue.Companion.newTimestamp(timestamp);
                }
                catch (IllegalArgumentException e) {
                    ExprValueExtensionsKt.cast$castFailedErr(locationMeta, $this$cast, targetType, "can't convert string value to TIMESTAMP", false, e);
                    throw new KotlinNothingValueException();
                }
            }
        } else if (singleType instanceof DateType) {
            if ($this$cast.getType() == ExprValueType.TIMESTAMP) {
                Timestamp ts = ExprValueExtensionsKt.timestampValue($this$cast);
                LocalDate localDate = LocalDate.of(ts.getYear(), ts.getMonth(), ts.getDay());
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"of(ts.year, ts.month, ts.day)");
                return ExprValue.Companion.newDate(localDate);
            }
            if ($this$cast.getType().isText()) {
                try {
                    if (!datePatternRegex.matches((CharSequence)ExprValueExtensionsKt.stringValue($this$cast))) {
                        ExprValueExtensionsKt.cast$castFailedErr$default(locationMeta, $this$cast, targetType, "Can't convert string value to DATE. Expected valid date string and the date format to be YYYY-MM-DD", false, null, 32, null);
                        throw new KotlinNothingValueException();
                    }
                    LocalDate date = LocalDate.parse(ExprValueExtensionsKt.stringValue($this$cast));
                    Intrinsics.checkNotNullExpressionValue((Object)date, (String)"date");
                    return ExprValue.Companion.newDate(date);
                }
                catch (DateTimeParseException e) {
                    ExprValueExtensionsKt.cast$castFailedErr(locationMeta, $this$cast, targetType, "Can't convert string value to DATE. Expected valid date string and the date format to be YYYY-MM-DD", false, e);
                    throw new KotlinNothingValueException();
                }
            }
        } else if (singleType instanceof TimeType) {
            Integer precision = ((TimeType)targetType).getPrecision();
            if ($this$cast.getType() == ExprValueType.TIME) {
                ZoneOffset zoneOffset;
                Time time = ExprValueExtensionsKt.timeValue($this$cast);
                if (((TimeType)targetType).getWithTimeZone()) {
                    zoneOffset = time.getZoneOffset();
                    if (zoneOffset == null) {
                        zoneOffset = defaultTimezoneOffset;
                    }
                } else {
                    zoneOffset = null;
                }
                ZoneOffset timeZoneOffset = zoneOffset;
                Integer n = precision;
                return ExprValue.Companion.newTime(Time.Companion.of(time.getLocalTime(), n != null ? n.intValue() : time.getPrecision(), timeZoneOffset));
            }
            if ($this$cast.getType() == ExprValueType.TIMESTAMP) {
                Integer n;
                Timestamp ts = ExprValueExtensionsKt.timestampValue($this$cast);
                if (((TimeType)targetType).getWithTimeZone()) {
                    Integer n2 = ts.getLocalOffset();
                    if (n2 == null) {
                        ExprValueExtensionsKt.cast$castFailedErr$default(locationMeta, $this$cast, targetType, "Can't convert timestamp value with unknown local offset (i.e. -00:00) to TIME WITH TIME ZONE.", false, null, 32, null);
                        throw new KotlinNothingValueException();
                    }
                    n = (int)n2;
                } else {
                    n = null;
                }
                Integer timeZoneOffset = n;
                int n3 = ts.getHour();
                int n4 = ts.getMinute();
                int n5 = ts.getSecond();
                BigDecimal bigDecimal = ts.getDecimalSecond().remainder(BigDecimal.ONE);
                BigDecimal bigDecimal2 = BigDecimal.valueOf(1000000000);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(this.toLong())");
                Integer n6 = precision;
                return ExprValue.Companion.newTime(Time.Companion.of(n3, n4, n5, bigDecimal.multiply(bigDecimal2).intValue(), n6 != null ? n6.intValue() : ts.getDecimalSecond().scale(), timeZoneOffset));
            }
            if ($this$cast.getType().isText()) {
                try {
                    ZoneOffset zoneOffset;
                    ZoneOffset zoneOffset2;
                    String zoneOffsetString;
                    Matcher matcher = genericTimeRegex.toPattern().matcher(ExprValueExtensionsKt.stringValue($this$cast));
                    if (!matcher.find()) {
                        ExprValueExtensionsKt.cast$castFailedErr$default(locationMeta, $this$cast, targetType, "Can't convert string value to TIME. Expected valid time string and the time to be of the format HH:MM:SS[.ddddd...][+|-HH:MM]", false, null, 32, null);
                        throw new KotlinNothingValueException();
                    }
                    LocalTime localTime = LocalTime.parse(ExprValueExtensionsKt.stringValue($this$cast), DateTimeFormatter.ISO_TIME);
                    String string = zoneOffsetString = matcher.group(2);
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        zoneOffset2 = ZoneOffset.of(it);
                    } else {
                        zoneOffset2 = zoneOffset = null;
                    }
                    if (zoneOffset2 == null) {
                        zoneOffset = defaultTimezoneOffset;
                    }
                    ZoneOffset zoneOffset3 = zoneOffset;
                    Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"localTime");
                    Integer n = precision;
                    return ExprValue.Companion.newTime(Time.Companion.of(localTime, n != null ? n : TimeExtensionsKt.getPrecisionFromTimeString(ExprValueExtensionsKt.stringValue($this$cast)), ((TimeType)targetType).getWithTimeZone() ? zoneOffset3 : null));
                }
                catch (DateTimeParseException e) {
                    ExprValueExtensionsKt.cast$castFailedErr(locationMeta, $this$cast, targetType, "Can't convert string value to TIME. Expected valid time string and the time format to be HH:MM:SS[.ddddd...][+|-HH:MM]", false, e);
                    throw new KotlinNothingValueException();
                }
            }
        } else if (singleType instanceof StringType ? true : singleType instanceof SymbolType) {
            if ($this$cast.getType().isNumber()) {
                return ExprValueExtensionsKt.cast$exprValue-4(ExprValueExtensionsKt.numberValue($this$cast).toString(), typedOpBehavior, locationMeta, $this$cast, targetType, targetType);
            }
            if ($this$cast.getType().isText()) {
                return ExprValueExtensionsKt.cast$exprValue-4(ExprValueExtensionsKt.stringValue($this$cast), typedOpBehavior, locationMeta, $this$cast, targetType, targetType);
            }
            if ($this$cast.getType() == ExprValueType.DATE) {
                String string = ExprValueExtensionsKt.dateValue($this$cast).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dateValue().toString()");
                return ExprValueExtensionsKt.cast$exprValue-4(string, typedOpBehavior, locationMeta, $this$cast, targetType, targetType);
            }
            if ($this$cast.getType() == ExprValueType.TIME) {
                return ExprValueExtensionsKt.cast$exprValue-4(ExprValueExtensionsKt.timeValue($this$cast).toString(), typedOpBehavior, locationMeta, $this$cast, targetType, targetType);
            }
            if ($this$cast.getType() == ExprValueType.BOOL) {
                return ExprValueExtensionsKt.cast$exprValue-4(String.valueOf(ExprValueExtensionsKt.booleanValue($this$cast)), typedOpBehavior, locationMeta, $this$cast, targetType, targetType);
            }
            if ($this$cast.getType() == ExprValueType.TIMESTAMP) {
                String string = ExprValueExtensionsKt.timestampValue($this$cast).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"timestampValue().toString()");
                return ExprValueExtensionsKt.cast$exprValue-4(string, typedOpBehavior, locationMeta, $this$cast, targetType, targetType);
            }
        } else if (singleType instanceof ClobType) {
            if ($this$cast.getType().isLob()) {
                return ExprValue.Companion.newClob(ExprValueExtensionsKt.bytesValue($this$cast));
            }
        } else if (singleType instanceof BlobType) {
            if ($this$cast.getType().isLob()) {
                return ExprValue.Companion.newBlob(ExprValueExtensionsKt.bytesValue($this$cast));
            }
        } else if (singleType instanceof ListType) {
            if ($this$cast.getType().isSequence()) {
                return ExprValue.Companion.newList((Sequence<? extends ExprValue>)CollectionsKt.asSequence((Iterable)$this$cast));
            }
        } else if (singleType instanceof SexpType) {
            if ($this$cast.getType().isSequence()) {
                return ExprValue.Companion.newSexp((Sequence<? extends ExprValue>)CollectionsKt.asSequence((Iterable)$this$cast));
            }
        } else if (singleType instanceof BagType && $this$cast.getType().isSequence()) {
            return ExprValue.Companion.newBag((Sequence<? extends ExprValue>)CollectionsKt.asSequence((Iterable)$this$cast));
        }
        ErrorCode errorCode = locationMeta == null ? ErrorCode.EVALUATOR_INVALID_CAST_NO_LOCATION : ErrorCode.EVALUATOR_INVALID_CAST;
        ExceptionsKt.err("Cannot convert " + (Object)((Object)$this$cast.getType()) + " to " + targetType, errorCode, ExprValueExtensionsKt.cast$castExceptionContext(locationMeta, $this$cast, targetType), false);
        throw new KotlinNothingValueException();
    }

    private static final String normalizeForCastToInt(String $this$normalizeForCastToInt) {
        String string;
        if ($this$normalizeForCastToInt.length() == 0) {
            string = $this$normalizeForCastToInt;
        } else if (ExprValueExtensionsKt.normalizeForCastToInt$possiblyHexOrBase2($this$normalizeForCastToInt)) {
            string = $this$normalizeForCastToInt.charAt(0) == '+' ? StringsKt.drop((String)$this$normalizeForCastToInt, (int)1) : $this$normalizeForCastToInt;
        } else {
            int startIndex;
            int toDrop;
            char c = $this$normalizeForCastToInt.charAt(0);
            Pair pair = c == '-' ? new Pair((Object)true, (Object)1) : (c == '+' ? new Pair((Object)false, (Object)1) : new Pair((Object)false, (Object)0));
            boolean isNegative = (Boolean)pair.component1();
            for (toDrop = startIndex = ((Number)pair.component2()).intValue(); toDrop < $this$normalizeForCastToInt.length() && $this$normalizeForCastToInt.charAt(toDrop) == '0'; ++toDrop) {
            }
            if (toDrop == $this$normalizeForCastToInt.length()) {
                string = "0";
            } else if (toDrop == 0) {
                string = $this$normalizeForCastToInt;
            } else if (toDrop == 1 && isNegative) {
                string = $this$normalizeForCastToInt;
            } else if (toDrop > 1 && isNegative) {
                char c2 = '-';
                String string2 = StringsKt.drop((String)$this$normalizeForCastToInt, (int)toDrop);
                string = c2 + string2;
            } else {
                string = StringsKt.drop((String)$this$normalizeForCastToInt, (int)toDrop);
            }
        }
        return string;
    }

    public static final boolean isUnknown(@NotNull ExprValue $this$isUnknown) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnknown, (String)"<this>");
        return $this$isUnknown.getType().isUnknown();
    }

    public static final boolean isNotUnknown(@NotNull ExprValue $this$isNotUnknown) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotUnknown, (String)"<this>");
        return !$this$isNotUnknown.getType().isUnknown();
    }

    @NotNull
    public static final Function1<ExprValue, Boolean> createUniqueExprValueFilter() {
        TreeSet<ExprValue> seen = new TreeSet<ExprValue>(DEFAULT_COMPARATOR);
        return (Function1)new Function1<ExprValue, Boolean>(seen){
            final /* synthetic */ TreeSet<ExprValue> $seen;
            {
                this.$seen = $seen;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ExprValue exprValue2) {
                Intrinsics.checkNotNullParameter((Object)exprValue2, (String)"exprValue");
                return this.$seen.add(exprValue2);
            }
        };
    }

    @NotNull
    public static final Sequence<ExprValue> distinct(@NotNull Sequence<? extends ExprValue> $this$distinct) {
        Intrinsics.checkNotNullParameter($this$distinct, (String)"<this>");
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super ExprValue>, Continuation<? super Unit>, Object>($this$distinct, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Sequence<ExprValue> $this_distinct;
            {
                this.$this_distinct = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        seen = new TreeSet(ExprValueExtensionsKt.getDEFAULT_COMPARATOR());
                        $this$forEach$iv = this.$this_distinct;
                        $i$f$forEach = false;
                        var6_7 = $this$forEach$iv.iterator();
lbl10:
                        // 4 sources

                        while (var6_7.hasNext()) {
                            element$iv = var6_7.next();
                            it = (ExprValue)element$iv;
                            $i$a$-forEach-ExprValueExtensionsKt$distinct$1$1 = false;
                            if (seen.contains(it)) continue;
                            seen.add(ExprValueExtensionsKt.unnamedValue(it));
                            this.L$0 = $this$sequence;
                            this.L$1 = seen;
                            this.L$2 = var6_7;
                            this.label = 1;
                            v0 = $this$sequence.yield((Object)it, (Continuation)this);
                            if (v0 != var10_2) continue;
                            return var10_2;
                        }
                        break;
                    }
                    case 1: {
                        $i$f$forEach = false;
                        $i$a$-forEach-ExprValueExtensionsKt$distinct$1$1 = false;
                        var6_7 = (Iterator)this.L$2;
                        seen = (TreeSet)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl10
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super ExprValue>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super ExprValue> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public static final TreeMap<ExprValue, Integer> multiplicities(@NotNull Sequence<? extends ExprValue> $this$multiplicities) {
        Intrinsics.checkNotNullParameter($this$multiplicities, (String)"<this>");
        TreeMap<ExprValue, Integer> multiplicities = new TreeMap<ExprValue, Integer>(DEFAULT_COMPARATOR);
        Sequence<? extends ExprValue> $this$forEach$iv = $this$multiplicities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExprValue it = (ExprValue)element$iv;
            boolean bl = false;
            multiplicities.compute(it, ExprValueExtensionsKt::multiplicities$lambda-7$lambda-6);
        }
        return multiplicities;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IonValue toIonValue(@NotNull ExprValue $this$toIonValue, @NotNull IonSystem ion) {
        IonValue ionValue;
        Intrinsics.checkNotNullParameter((Object)$this$toIonValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ion, (String)"ion");
        switch (WhenMappings.$EnumSwitchMapping$3[$this$toIonValue.getType().ordinal()]) {
            case 1: {
                IonValue ionValue2 = ion.newNull((IonType)$this$toIonValue.asFacet(IonType.class));
                ionValue = ionValue2;
                Intrinsics.checkNotNullExpressionValue((Object)ionValue2, (String)"ion.newNull(asFacet(IonType::class.java))");
                break;
            }
            case 2: {
                IonNull ionNull;
                IonNull $this$toIonValue_u24lambda_u2d8 = ionNull = ion.newNull();
                boolean bl = false;
                $this$toIonValue_u24lambda_u2d8.addTypeAnnotation(MISSING_ANNOTATION);
                IonNull ionNull2 = ionNull;
                Intrinsics.checkNotNullExpressionValue((Object)ionNull2, (String)"ion.newNull().apply { ad\u2026ion(MISSING_ANNOTATION) }");
                ionValue = (IonValue)ionNull2;
                break;
            }
            case 3: {
                IonBool ionBool = ion.newBool(ExprValueExtensionsKt.booleanValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionBool, (String)"ion.newBool(booleanValue())");
                ionValue = (IonValue)ionBool;
                break;
            }
            case 4: {
                IonInt ionInt = ion.newInt(ExprValueExtensionsKt.longValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionInt, (String)"ion.newInt(longValue())");
                ionValue = (IonValue)ionInt;
                break;
            }
            case 5: {
                IonFloat ionFloat = ion.newFloat(ExprValueExtensionsKt.numberValue($this$toIonValue).doubleValue());
                Intrinsics.checkNotNullExpressionValue((Object)ionFloat, (String)"ion.newFloat(numberValue().toDouble())");
                ionValue = (IonValue)ionFloat;
                break;
            }
            case 6: {
                IonDecimal ionDecimal = ion.newDecimal(ExprValueExtensionsKt.bigDecimalValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionDecimal, (String)"ion.newDecimal(bigDecimalValue())");
                ionValue = (IonValue)ionDecimal;
                break;
            }
            case 7: {
                IonTimestamp $this$toIonValue_u24lambda_u2d8;
                LocalDate value = ExprValueExtensionsKt.dateValue($this$toIonValue);
                IonTimestamp $this$toIonValue_u24lambda_u2d9 = $this$toIonValue_u24lambda_u2d8 = ion.newTimestamp(Timestamp.forDay((int)value.getYear(), (int)value.getMonthValue(), (int)value.getDayOfMonth()));
                boolean bl = false;
                $this$toIonValue_u24lambda_u2d9.addTypeAnnotation(DATE_ANNOTATION);
                IonTimestamp ionTimestamp = $this$toIonValue_u24lambda_u2d8;
                Intrinsics.checkNotNullExpressionValue((Object)ionTimestamp, (String)"{\n            val value \u2026)\n            }\n        }");
                ionValue = (IonValue)ionTimestamp;
                break;
            }
            case 8: {
                IonTimestamp ionTimestamp = ion.newTimestamp(ExprValueExtensionsKt.timestampValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionTimestamp, (String)"ion.newTimestamp(timestampValue())");
                ionValue = (IonValue)ionTimestamp;
                break;
            }
            case 9: {
                ionValue = (IonValue)ExprValueExtensionsKt.timeValue($this$toIonValue).toIonValue(ion);
                break;
            }
            case 10: {
                IonSymbol ionSymbol = ion.newSymbol(ExprValueExtensionsKt.stringValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionSymbol, (String)"ion.newSymbol(stringValue())");
                ionValue = (IonValue)ionSymbol;
                break;
            }
            case 11: {
                IonString ionString = ion.newString(ExprValueExtensionsKt.stringValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionString, (String)"ion.newString(stringValue())");
                ionValue = (IonValue)ionString;
                break;
            }
            case 12: {
                IonClob ionClob = ion.newClob(ExprValueExtensionsKt.bytesValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionClob, (String)"ion.newClob(bytesValue())");
                ionValue = (IonValue)ionClob;
                break;
            }
            case 13: {
                IonBlob ionBlob = ion.newBlob(ExprValueExtensionsKt.bytesValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionBlob, (String)"ion.newBlob(bytesValue())");
                ionValue = (IonValue)ionBlob;
                break;
            }
            case 14: {
                void $this$mapTo$iv;
                Iterable value = $this$toIonValue;
                Collection destination$iv = (Collection)ion.newEmptyList();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    ExprValue exprValue2 = (ExprValue)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it instanceof StructExprValue ? (IonValue)ExprValueExtensionsKt.toIonStruct((ExprValue)it, ion) : ExprValueExtensionsKt.toIonValue((ExprValue)it, ion).clone());
                }
                Collection collection = destination$iv;
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"mapTo(ion.newEmptyList()\u2026ue(ion).clone()\n        }");
                ionValue = (IonValue)collection;
                break;
            }
            case 15: {
                Iterable $this$mapTo$iv = $this$toIonValue;
                Collection destination$iv = (Collection)ion.newEmptySexp();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    ExprValue it = (ExprValue)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it instanceof StructExprValue ? (IonValue)ExprValueExtensionsKt.toIonStruct(it, ion) : ExprValueExtensionsKt.toIonValue(it, ion).clone());
                }
                Collection collection = destination$iv;
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"mapTo(ion.newEmptySexp()\u2026ue(ion).clone()\n        }");
                ionValue = (IonValue)collection;
                break;
            }
            case 16: {
                Iterable $this$mapTo$iv = $this$toIonValue;
                Object destination$iv = ion.newEmptyList();
                IonList $this$toIonValue_u24lambda_u2d12 = destination$iv;
                boolean bl = false;
                $this$toIonValue_u24lambda_u2d12.addTypeAnnotation(BAG_ANNOTATION);
                destination$iv = (Collection)destination$iv;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    ExprValue it = (ExprValue)item$iv;
                    Object object = destination$iv;
                    boolean bl2 = false;
                    object.add(it instanceof StructExprValue ? (IonValue)ExprValueExtensionsKt.toIonStruct(it, ion) : ExprValueExtensionsKt.toIonValue(it, ion).clone());
                }
                Object object = destination$iv;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapTo(\n            ion.n\u2026ue(ion).clone()\n        }");
                ionValue = (IonValue)object;
                break;
            }
            case 17: {
                ionValue = (IonValue)ExprValueExtensionsKt.toIonStruct($this$toIonValue, ion);
                break;
            }
            case 18: {
                String string = "Ion representation for graph values, maybe?";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ionValue;
    }

    private static final IonStruct toIonStruct(ExprValue $this$toIonStruct, IonSystem ion) {
        IonStruct ionStruct;
        IonStruct $this$toIonStruct_u24lambda_u2d15 = ionStruct = ion.newEmptyStruct();
        boolean bl = false;
        Iterable $this$forEach$iv = $this$toIonStruct;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExprValue it = (ExprValue)element$iv;
            boolean bl2 = false;
            ExprValue nameVal = ExprValueExtensionsKt.getName(it);
            if (nameVal == null || !nameVal.getType().isText() || it.getType() == ExprValueType.MISSING) continue;
            String name = ExprValueExtensionsKt.stringValue(nameVal);
            $this$toIonStruct_u24lambda_u2d15.add(name, ExprValueExtensionsKt.toIonValue(it, ion).clone());
        }
        IonStruct ionStruct2 = ionStruct;
        Intrinsics.checkNotNullExpressionValue((Object)ionStruct2, (String)"ion.newEmptyStruct().app\u2026        }\n        }\n    }");
        return ionStruct2;
    }

    private static final PropertyValueMap cast$castExceptionContext(SourceLocationMeta $locationMeta, ExprValue $this_cast, SingleType $targetType) {
        PropertyValueMap errorContext;
        block0: {
            PropertyValueMap propertyValueMap;
            PropertyValueMap it = propertyValueMap = new PropertyValueMap(null, 1, null);
            boolean bl = false;
            it.set(Property.CAST_FROM, $this_cast.getType().toString());
            it.set(Property.CAST_TO, StaticTypeUtils.getRuntimeType($targetType).toString());
            errorContext = propertyValueMap;
            SourceLocationMeta sourceLocationMeta = $locationMeta;
            if (sourceLocationMeta == null) break block0;
            it = sourceLocationMeta;
            boolean bl2 = false;
            ExceptionsKt.fillErrorContext(errorContext, (SourceLocationMeta)it);
        }
        return errorContext;
    }

    private static final Void cast$castFailedErr(SourceLocationMeta $locationMeta, ExprValue $this_cast, SingleType $targetType, String message, boolean internal, Throwable cause) {
        PropertyValueMap errorContext = ExprValueExtensionsKt.cast$castExceptionContext($locationMeta, $this_cast, $targetType);
        ErrorCode errorCode = $locationMeta == null ? ErrorCode.EVALUATOR_CAST_FAILED_NO_LOCATION : ErrorCode.EVALUATOR_CAST_FAILED;
        throw new EvaluationException(message, errorCode, errorContext, cause, internal);
    }

    static /* synthetic */ Void cast$castFailedErr$default(SourceLocationMeta sourceLocationMeta, ExprValue exprValue2, SingleType singleType, String string, boolean bl, Throwable throwable, int n, Object object) {
        if ((n & 0x20) != 0) {
            throwable = null;
        }
        return ExprValueExtensionsKt.cast$castFailedErr(sourceLocationMeta, exprValue2, singleType, string, bl, throwable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final ExprValue cast$exprValue(Number $this$cast_u24exprValue, TypedOpBehavior $typedOpBehavior, BigDecimal longMinDecimal, BigDecimal longMaxDecimal, SourceLocationMeta $locationMeta, ExprValue $this_cast, SingleType $targetType, SingleType type) {
        ExprValue exprValue2;
        SingleType singleType;
        block18: {
            LongRange rangeForType;
            block20: {
                block19: {
                    LongRange longRange;
                    singleType = type;
                    if (!(singleType instanceof IntType)) break block18;
                    if (NumberExtensionsKt.isNaN($this$cast_u24exprValue) || NumberExtensionsKt.isNegInf($this$cast_u24exprValue) || NumberExtensionsKt.isPosInf($this$cast_u24exprValue)) {
                        ExprValueExtensionsKt.cast$castFailedErr$default($locationMeta, $this_cast, $targetType, "Can't convert Infinity or NaN to INT.", false, null, 32, null);
                        throw new KotlinNothingValueException();
                    }
                    if (WhenMappings.$EnumSwitchMapping$1[$typedOpBehavior.ordinal()] != 1) throw new NoWhenBranchMatchedException();
                    switch (WhenMappings.$EnumSwitchMapping$0[((IntType)type).getRangeConstraint().ordinal()]) {
                        case 1: {
                            longRange = new LongRange(-32768L, 32767L);
                            break;
                        }
                        case 2: {
                            longRange = new LongRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
                            break;
                        }
                        case 3: 
                        case 4: {
                            longRange = new LongRange(Long.MIN_VALUE, Long.MAX_VALUE);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    rangeForType = longRange;
                    BigDecimal bigDecimal = longMinDecimal;
                    BigDecimal bigDecimal2 = BigDecimal.ONE;
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"ONE");
                    BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"this.subtract(other)");
                    if (NumberExtensionsKt.compareTo($this$cast_u24exprValue, bigDecimal3) <= 0) break block19;
                    bigDecimal = longMaxDecimal;
                    BigDecimal bigDecimal4 = BigDecimal.ONE;
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"ONE");
                    BigDecimal bigDecimal5 = bigDecimal.add(bigDecimal4);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"this.add(other)");
                    if (NumberExtensionsKt.compareTo($this$cast_u24exprValue, bigDecimal5) < 0) break block20;
                }
                ExceptionsKt.errIntOverflow$default(8, null, 2, null);
                throw new KotlinNothingValueException();
            }
            if (WhenMappings.$EnumSwitchMapping$1[$typedOpBehavior.ordinal()] != 1) throw new NoWhenBranchMatchedException();
            Number number = $this$cast_u24exprValue;
            Number it = number instanceof BigDecimal ? (Number)((BigDecimal)$this$cast_u24exprValue).setScale(0, RoundingMode.HALF_EVEN) : (Number)(number instanceof Float ? (Number)Float.valueOf((float)Math.rint($this$cast_u24exprValue.floatValue())) : (Number)(number instanceof Double ? (Number)Math.rint($this$cast_u24exprValue.doubleValue()) : (Number)$this$cast_u24exprValue));
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (NumberExtensionsKt.compareTo(it, rangeForType.getFirst()) < 0 || NumberExtensionsKt.compareTo(it, rangeForType.getLast()) > 0) {
                ExceptionsKt.errIntOverflow$default(8, null, 2, null);
                throw new KotlinNothingValueException();
            }
            long result = it.longValue();
            exprValue2 = ExprValue.Companion.newInt(result);
            return exprValue2;
        }
        if (singleType instanceof FloatType) {
            exprValue2 = ExprValue.Companion.newFloat($this$cast_u24exprValue.doubleValue());
            return exprValue2;
        } else if (singleType instanceof DecimalType) {
            if (NumberExtensionsKt.isNaN($this$cast_u24exprValue) || NumberExtensionsKt.isNegInf($this$cast_u24exprValue) || NumberExtensionsKt.isPosInf($this$cast_u24exprValue)) {
                ExprValueExtensionsKt.cast$castFailedErr$default($locationMeta, $this_cast, $targetType, "Can't convert Infinity or NaN to DECIMAL.", false, null, 32, null);
                throw new KotlinNothingValueException();
            }
            if (WhenMappings.$EnumSwitchMapping$1[$typedOpBehavior.ordinal()] != 1) throw new NoWhenBranchMatchedException();
            DecimalType.PrecisionScaleConstraint constraint = ((DecimalType)type).getPrecisionScaleConstraint();
            if (Intrinsics.areEqual((Object)constraint, (Object)DecimalType.PrecisionScaleConstraint.Unconstrained.INSTANCE)) {
                exprValue2 = ExprValue.Companion.newDecimal(NumberExtensionsKt.coerce($this$cast_u24exprValue, BigDecimal.class));
                return exprValue2;
            } else {
                if (!(constraint instanceof DecimalType.PrecisionScaleConstraint.Constrained)) throw new NoWhenBranchMatchedException();
                BigDecimal decimal = NumberExtensionsKt.coerce($this$cast_u24exprValue, BigDecimal.class);
                BigDecimal result = decimal.round(new MathContext(((DecimalType.PrecisionScaleConstraint.Constrained)constraint).getPrecision())).setScale(((DecimalType.PrecisionScaleConstraint.Constrained)constraint).getScale(), RoundingMode.HALF_UP);
                if (result.precision() > ((DecimalType.PrecisionScaleConstraint.Constrained)constraint).getPrecision()) {
                    ExprValueExtensionsKt.cast$castFailedErr$default($locationMeta, $this_cast, $targetType, "target type DECIMAL(" + ((DecimalType.PrecisionScaleConstraint.Constrained)constraint).getPrecision() + ", " + ((DecimalType.PrecisionScaleConstraint.Constrained)constraint).getScale() + ") too small for value " + decimal + '.', false, null, 32, null);
                    throw new KotlinNothingValueException();
                }
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
                exprValue2 = ExprValue.Companion.newDecimal(result);
            }
            return exprValue2;
        } else {
            ExprValueExtensionsKt.cast$castFailedErr$default($locationMeta, $this_cast, $targetType, "Invalid type for numeric conversion: " + type + " (this code should be unreachable)", true, null, 32, null);
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final ExprValue cast$exprValue-4(String $this$cast_u24exprValue_u2d4, TypedOpBehavior $typedOpBehavior, SourceLocationMeta $locationMeta, ExprValue $this_cast, SingleType $targetType, SingleType type) {
        ExprValue exprValue2;
        SingleType singleType = type;
        if (singleType instanceof StringType) {
            String string;
            String string2;
            int lengthConstraint;
            if (WhenMappings.$EnumSwitchMapping$1[$typedOpBehavior.ordinal()] != 1) throw new NoWhenBranchMatchedException();
            StringType.StringLengthConstraint constraint = ((StringType)type).getLengthConstraint();
            if (Intrinsics.areEqual((Object)constraint, (Object)StringType.StringLengthConstraint.Unconstrained.INSTANCE)) {
                exprValue2 = ExprValue.Companion.newString($this$cast_u24exprValue_u2d4);
                return exprValue2;
            }
            if (!(constraint instanceof StringType.StringLengthConstraint.Constrained)) throw new NoWhenBranchMatchedException();
            int actualCodepointCount = $this$cast_u24exprValue_u2d4.codePointCount(0, $this$cast_u24exprValue_u2d4.length());
            if (actualCodepointCount <= (lengthConstraint = ((StringType.StringLengthConstraint.Constrained)constraint).getLength().getValue())) {
                string2 = $this$cast_u24exprValue_u2d4;
            } else {
                String string3 = $this$cast_u24exprValue_u2d4.substring(0, $this$cast_u24exprValue_u2d4.offsetByCodePoints(0, lengthConstraint));
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            String truncatedString = string2;
            ExprValue.Companion companion = ExprValue.Companion;
            NumberConstraint numberConstraint = ((StringType.StringLengthConstraint.Constrained)constraint).getLength();
            if (numberConstraint instanceof NumberConstraint.Equals) {
                CharSequence charSequence;
                ExprValue.Companion companion2;
                block10: {
                    void $this$trimEnd$iv;
                    String string4 = truncatedString;
                    companion2 = companion;
                    boolean $i$f$trimEnd = false;
                    CharSequence $this$trimEnd$iv$iv = (CharSequence)$this$trimEnd$iv;
                    boolean $i$f$trimEnd2 = false;
                    int n = $this$trimEnd$iv$iv.length() + -1;
                    if (0 <= n) {
                        do {
                            int index$iv$iv = n--;
                            char c = $this$trimEnd$iv$iv.charAt(index$iv$iv);
                            boolean bl = false;
                            if (c == ' ') continue;
                            charSequence = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv + 1);
                            break block10;
                        } while (0 <= n);
                    }
                    charSequence = "";
                }
                string = ((Object)charSequence).toString();
                companion = companion2;
            } else {
                if (!(numberConstraint instanceof NumberConstraint.UpTo)) throw new NoWhenBranchMatchedException();
                string = truncatedString;
            }
            exprValue2 = companion.newString(string);
            return exprValue2;
        }
        if (singleType instanceof SymbolType) {
            exprValue2 = ExprValue.Companion.newSymbol($this$cast_u24exprValue_u2d4);
            return exprValue2;
        } else {
            ExprValueExtensionsKt.cast$castFailedErr$default($locationMeta, $this_cast, $targetType, "Invalid type for textual conversion: " + type + " (this code should be unreachable)", true, null, 32, null);
            throw new KotlinNothingValueException();
        }
    }

    private static final long cast$parseToLong(SourceLocationMeta $locationMeta, ExprValue $this_cast, SingleType $targetType, String s) {
        IonInt ionInt;
        IonSystem ion = IonSystemBuilder.standard().build();
        try {
            String normalized = ExprValueExtensionsKt.normalizeForCastToInt(s);
            IonValue ionValue = ion.singleValue(normalized);
            if (ionValue == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.amazon.ion.IonInt");
            }
            ionInt = (IonInt)ionValue;
        }
        catch (Exception e) {
            ExprValueExtensionsKt.cast$castFailedErr($locationMeta, $this_cast, $targetType, "can't convert string value to INT", false, e);
            throw new KotlinNothingValueException();
        }
        IonInt value = ionInt;
        IntegerSize integerSize = value.getIntegerSize();
        if ((integerSize == null ? -1 : WhenMappings.$EnumSwitchMapping$2[integerSize.ordinal()]) == 1) {
            ExceptionsKt.errIntOverflow(8, ExceptionsKt.errorContextFrom($locationMeta));
            throw new KotlinNothingValueException();
        }
        return value.longValue();
    }

    private static final boolean normalizeForCastToInt$isSign(char $this$normalizeForCastToInt_u24isSign) {
        return $this$normalizeForCastToInt_u24isSign == '-' || $this$normalizeForCastToInt_u24isSign == '+';
    }

    private static final boolean normalizeForCastToInt$isHexOrBase2Marker(char $this$normalizeForCastToInt_u24isHexOrBase2Marker) {
        char c = Character.toLowerCase($this$normalizeForCastToInt_u24isHexOrBase2Marker);
        return c == 'x' || c == 'b';
    }

    private static final boolean normalizeForCastToInt$possiblyHexOrBase2(String $this$normalizeForCastToInt_u24possiblyHexOrBase2) {
        return $this$normalizeForCastToInt_u24possiblyHexOrBase2.length() >= 2 && ExprValueExtensionsKt.normalizeForCastToInt$isHexOrBase2Marker($this$normalizeForCastToInt_u24possiblyHexOrBase2.charAt(1)) || $this$normalizeForCastToInt_u24possiblyHexOrBase2.length() >= 3 && ExprValueExtensionsKt.normalizeForCastToInt$isSign($this$normalizeForCastToInt_u24possiblyHexOrBase2.charAt(0)) && ExprValueExtensionsKt.normalizeForCastToInt$isHexOrBase2Marker($this$normalizeForCastToInt_u24possiblyHexOrBase2.charAt(2));
    }

    private static final Integer multiplicities$lambda-7$lambda-6(ExprValue exprValue2, Integer v) {
        Intrinsics.checkNotNullParameter((Object)exprValue2, (String)"<anonymous parameter 0>");
        Integer n = v;
        if (n == null) {
            n = 0;
        }
        return n + 1;
    }

    static {
        ExprValueType[] exprValueTypeArray = new ExprValueType[]{ExprValueType.BOOL, ExprValueType.TIMESTAMP};
        ION_TEXT_STRING_CAST_TYPES = SetsKt.setOf((Object[])exprValueTypeArray);
        datePatternRegex = new Regex("\\d\\d\\d\\d-\\d\\d-\\d\\d");
        genericTimeRegex = new Regex("\\d\\d:\\d\\d:\\d\\d(\\.\\d*)?([+|-]\\d\\d:\\d\\d)?");
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[IntType.IntRangeConstraint.values().length];
            nArray[IntType.IntRangeConstraint.SHORT.ordinal()] = 1;
            nArray[IntType.IntRangeConstraint.INT4.ordinal()] = 2;
            nArray[IntType.IntRangeConstraint.LONG.ordinal()] = 3;
            nArray[IntType.IntRangeConstraint.UNCONSTRAINED.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TypedOpBehavior.values().length];
            nArray[TypedOpBehavior.HONOR_PARAMETERS.ordinal()] = 1;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[IntegerSize.values().length];
            nArray[IntegerSize.BIG_INTEGER.ordinal()] = 1;
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[ExprValueType.values().length];
            nArray[ExprValueType.NULL.ordinal()] = 1;
            nArray[ExprValueType.MISSING.ordinal()] = 2;
            nArray[ExprValueType.BOOL.ordinal()] = 3;
            nArray[ExprValueType.INT.ordinal()] = 4;
            nArray[ExprValueType.FLOAT.ordinal()] = 5;
            nArray[ExprValueType.DECIMAL.ordinal()] = 6;
            nArray[ExprValueType.DATE.ordinal()] = 7;
            nArray[ExprValueType.TIMESTAMP.ordinal()] = 8;
            nArray[ExprValueType.TIME.ordinal()] = 9;
            nArray[ExprValueType.SYMBOL.ordinal()] = 10;
            nArray[ExprValueType.STRING.ordinal()] = 11;
            nArray[ExprValueType.CLOB.ordinal()] = 12;
            nArray[ExprValueType.BLOB.ordinal()] = 13;
            nArray[ExprValueType.LIST.ordinal()] = 14;
            nArray[ExprValueType.SEXP.ordinal()] = 15;
            nArray[ExprValueType.BAG.ordinal()] = 16;
            nArray[ExprValueType.STRUCT.ordinal()] = 17;
            nArray[ExprValueType.GRAPH.ordinal()] = 18;
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

