/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.lang.eval.Bindings;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.ExprValueType;
import org.partiql.lang.eval.Named;
import org.partiql.lang.eval.OrdinalBindings;
import org.partiql.lang.eval.Scalar;
import org.partiql.lang.graph.Graph;
import org.partiql.lang.util.FacetExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J%\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\u0004\b\u0000\u0010\u001e2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u0002H\u001e\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\"H\u0096\u0003J\b\u0010#\u001a\u00020$H\u0016R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0003\u001a\u00020\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000f\u00a8\u0006%"}, d2={"Lorg/partiql/lang/eval/NamedExprValue;", "Lorg/partiql/lang/eval/ExprValue;", "Lorg/partiql/lang/eval/Named;", "name", "value", "(Lorg/partiql/lang/eval/ExprValue;Lorg/partiql/lang/eval/ExprValue;)V", "bindings", "Lorg/partiql/lang/eval/Bindings;", "getBindings", "()Lorg/partiql/lang/eval/Bindings;", "graphValue", "Lorg/partiql/lang/graph/Graph;", "getGraphValue", "()Lorg/partiql/lang/graph/Graph;", "getName", "()Lorg/partiql/lang/eval/ExprValue;", "ordinalBindings", "Lorg/partiql/lang/eval/OrdinalBindings;", "getOrdinalBindings", "()Lorg/partiql/lang/eval/OrdinalBindings;", "scalar", "Lorg/partiql/lang/eval/Scalar;", "getScalar", "()Lorg/partiql/lang/eval/Scalar;", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValue", "asFacet", "T", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "iterator", "", "toString", "", "partiql-lang"})
public final class NamedExprValue
implements ExprValue,
Named {
    @NotNull
    private final ExprValue name;
    @NotNull
    private final ExprValue value;

    public NamedExprValue(@NotNull ExprValue name, @NotNull ExprValue value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.name = name;
        this.value = value;
    }

    @Override
    @NotNull
    public ExprValue getName() {
        return this.name;
    }

    @NotNull
    public final ExprValue getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public Bindings<ExprValue> getBindings() {
        return this.value.getBindings();
    }

    @Override
    @NotNull
    public Graph getGraphValue() {
        return this.value.getGraphValue();
    }

    @Override
    @NotNull
    public OrdinalBindings getOrdinalBindings() {
        return this.value.getOrdinalBindings();
    }

    @Override
    @NotNull
    public Scalar getScalar() {
        return this.value.getScalar();
    }

    @Override
    @NotNull
    public ExprValueType getType() {
        return this.value.getType();
    }

    @Override
    @NotNull
    public Iterator<ExprValue> iterator() {
        return this.value.iterator();
    }

    @Nullable
    public <T> T asFacet(@Nullable Class<T> type) {
        Object object = FacetExtensionsKt.downcast(this, type);
        if (object == null) {
            object = this.value.asFacet(type);
        }
        return object;
    }

    @NotNull
    public String toString() {
        return ExprValueExtensionsKt.stringify(this);
    }
}

