/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.errors.ErrorCode;
import org.partiql.lang.eval.BindingCase;
import org.partiql.lang.eval.BindingName;
import org.partiql.lang.eval.EvaluationException;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.builtins.DynamicLookupExprFunction;
import org.partiql.lang.eval.physical.UndefinedVariableUtilKt;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.types.SingleType;
import org.partiql.types.StaticType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J \u0010\r\u001a\u0004\u0018\u00010\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/partiql/lang/eval/builtins/DynamicLookupExprFunction;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "signature", "Lorg/partiql/lang/types/FunctionSignature;", "getSignature", "()Lorg/partiql/lang/types/FunctionSignature;", "callWithRequired", "Lorg/partiql/lang/eval/ExprValue;", "session", "Lorg/partiql/lang/eval/EvaluationSession;", "required", "", "searchLocals", "possibleLocations", "bindingName", "Lorg/partiql/lang/eval/BindingName;", "partiql-lang"})
public final class DynamicLookupExprFunction
implements ExprFunction {
    @NotNull
    private final FunctionSignature signature;

    public DynamicLookupExprFunction() {
        Object[] objectArray = new SingleType[]{(SingleType)StaticType.SYMBOL, (SingleType)StaticType.SYMBOL, (SingleType)StaticType.SYMBOL, (SingleType)StaticType.LIST};
        this.signature = new FunctionSignature("$__dynamic_lookup__", CollectionsKt.listOf((Object[])objectArray), (StaticType)StaticType.ANY, null, 8, null);
    }

    @Override
    @NotNull
    public FunctionSignature getSignature() {
        return this.signature;
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        ExprValue found;
        ExprValue exprValue2;
        boolean bl;
        BindingCase bindingCase;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        List variadic = CollectionsKt.toList((Iterable)required.get(3));
        String variableName = ExprValueExtensionsKt.stringValue(required.get(0));
        String caseSensitivityParameterValue = ExprValueExtensionsKt.stringValue(required.get(1));
        if (Intrinsics.areEqual((Object)caseSensitivityParameterValue, (Object)"case_sensitive")) {
            bindingCase = BindingCase.SENSITIVE;
        } else if (Intrinsics.areEqual((Object)caseSensitivityParameterValue, (Object)"case_insensitive")) {
            bindingCase = BindingCase.INSENSITIVE;
        } else {
            throw new EvaluationException("Invalid case sensitivity: " + caseSensitivityParameterValue, ErrorCode.INTERNAL_ERROR, null, null, true, 12, null);
        }
        BindingCase caseSensitivity = bindingCase;
        BindingName bindingName = new BindingName(variableName, caseSensitivity);
        String lookupStrategyParameterValue = ExprValueExtensionsKt.stringValue(required.get(2));
        if (Intrinsics.areEqual((Object)lookupStrategyParameterValue, (Object)"locals_then_globals")) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)lookupStrategyParameterValue, (Object)"globals_then_locals")) {
            bl = true;
        } else {
            throw new EvaluationException("Invalid lookup strategy: " + lookupStrategyParameterValue, ErrorCode.INTERNAL_ERROR, null, null, true, 12, null);
        }
        boolean globalsFirst = bl;
        if (globalsFirst) {
            exprValue2 = session.getGlobals().get(bindingName);
            if (exprValue2 == null) {
                exprValue2 = this.searchLocals(variadic, bindingName);
            }
        } else {
            exprValue2 = this.searchLocals(variadic, bindingName);
            if (exprValue2 == null) {
                exprValue2 = session.getGlobals().get(bindingName);
            }
        }
        if ((found = exprValue2) == null) {
            UndefinedVariableUtilKt.throwUndefinedVariableException(bindingName, null);
            throw new KotlinNothingValueException();
        }
        return found;
    }

    private final ExprValue searchLocals(List<? extends ExprValue> possibleLocations, BindingName bindingName) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)possibleLocations), (Function1)((Function1)new Function1<ExprValue, ExprValue>(bindingName){
                final /* synthetic */ BindingName $bindingName;
                {
                    this.$bindingName = $bindingName;
                    super(1);
                }

                @Nullable
                public final ExprValue invoke(@NotNull ExprValue it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return searchLocals.WhenMappings.$EnumSwitchMapping$0[it.getType().ordinal()] == 1 ? it.getBindings().get(this.$bindingName) : null;
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ExprValue it = (ExprValue)element$iv;
                boolean bl = false;
                if (!(it != null)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing each alternative in required parameter as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithOptional().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        return ExprFunction.DefaultImpls.callWithOptional(this, session, required, opt);
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing the LIST ExprValue in required parameter to represent variadic parameters as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithVariadic().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }
}

