/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import com.amazon.ion.IonType;
import com.amazon.ionelement.api.IonMeta;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.errors.ErrorCode;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.types.StaticType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionCurrentUser;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "FUNCTION_NAME", "", "signature", "Lorg/partiql/lang/types/FunctionSignature;", "getSignature", "()Lorg/partiql/lang/types/FunctionSignature;", "callWithRequired", "Lorg/partiql/lang/eval/ExprValue;", "session", "Lorg/partiql/lang/eval/EvaluationSession;", "required", "", "partiql-lang"})
public final class ExprFunctionCurrentUser
implements ExprFunction {
    @NotNull
    public static final ExprFunctionCurrentUser INSTANCE = new ExprFunctionCurrentUser();
    @NotNull
    public static final String FUNCTION_NAME = "$__current_user";
    @NotNull
    private static final FunctionSignature signature;

    private ExprFunctionCurrentUser() {
    }

    @Override
    @NotNull
    public FunctionSignature getSignature() {
        return signature;
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        ExprValue exprValue2;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Object user = session.getContext().get("CURRENT_USER");
        if (user instanceof String) {
            exprValue2 = ExprValue.Companion.newString((String)user);
        } else if (user == null) {
            exprValue2 = ExprValue.Companion.newNull(IonType.STRING);
        } else {
            ExceptionsKt.err("CURRENT_USER must be either a STRING or NULL.", ErrorCode.EVALUATOR_UNEXPECTED_VALUE, ExceptionsKt.errorContextFrom(IonMeta.emptyMetaContainer()), false);
            throw new KotlinNothingValueException();
        }
        return exprValue2;
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing each alternative in required parameter as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithOptional().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        return ExprFunction.DefaultImpls.callWithOptional(this, session, required, opt);
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing the LIST ExprValue in required parameter to represent variadic parameters as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithVariadic().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }

    static {
        StaticType[] staticTypeArray = new StaticType[]{(StaticType)StaticType.STRING, (StaticType)StaticType.NULL};
        signature = new FunctionSignature(FUNCTION_NAME, CollectionsKt.emptyList(), StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (StaticType[])staticTypeArray, null, (int)2, null), null, 8, null);
    }
}

