/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.errors.ErrorCode;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.builtins.internal.TimestampExtensionsKt;
import org.partiql.lang.syntax.impl.DateTimePart;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.types.SingleType;
import org.partiql.types.StaticType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionDateDiff;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "signature", "Lorg/partiql/lang/types/FunctionSignature;", "getSignature", "()Lorg/partiql/lang/types/FunctionSignature;", "callWithRequired", "Lorg/partiql/lang/eval/ExprValue;", "session", "Lorg/partiql/lang/eval/EvaluationSession;", "required", "", "partiql-lang"})
public final class ExprFunctionDateDiff
implements ExprFunction {
    @NotNull
    public static final ExprFunctionDateDiff INSTANCE = new ExprFunctionDateDiff();
    @NotNull
    private static final FunctionSignature signature;

    private ExprFunctionDateDiff() {
    }

    @Override
    @NotNull
    public FunctionSignature getSignature() {
        return signature;
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        String arg0 = ExprValueExtensionsKt.stringValue(required.get(0));
        DateTimePart part = DateTimePart.Companion.safeValueOf(arg0);
        OffsetDateTime l = TimestampExtensionsKt.toOffsetDateTime(ExprValueExtensionsKt.timestampValue(required.get(1)));
        OffsetDateTime r = TimestampExtensionsKt.toOffsetDateTime(ExprValueExtensionsKt.timestampValue(required.get(2)));
        DateTimePart dateTimePart = part;
        switch (dateTimePart == null ? -1 : WhenMappings.$EnumSwitchMapping$0[dateTimePart.ordinal()]) {
            case 1: {
                number = Period.between(l.toLocalDate(), r.toLocalDate()).getYears();
                break;
            }
            case 2: {
                number = Period.between(l.toLocalDate(), r.toLocalDate()).toTotalMonths();
                break;
            }
            case 3: {
                number = Duration.between(l, r).toDays();
                break;
            }
            case 4: {
                number = Duration.between(l, r).toHours();
                break;
            }
            case 5: {
                number = Duration.between(l, r).toMinutes();
                break;
            }
            case 6: {
                number = Duration.between(l, r).toMillis() / (long)1000;
                break;
            }
            default: {
                ExceptionsKt.errNoContext("invalid datetime part for date_diff: " + arg0, ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_DATE_PART, false);
                throw new KotlinNothingValueException();
            }
        }
        Number result = number;
        return ExprValue.Companion.newInt(((Number)result).longValue());
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing each alternative in required parameter as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithOptional().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        return ExprFunction.DefaultImpls.callWithOptional(this, session, required, opt);
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing the LIST ExprValue in required parameter to represent variadic parameters as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithVariadic().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }

    static {
        Object[] objectArray = new SingleType[]{(SingleType)StaticType.SYMBOL, (SingleType)StaticType.TIMESTAMP, (SingleType)StaticType.TIMESTAMP};
        signature = new FunctionSignature("date_diff", CollectionsKt.listOf((Object[])objectArray), (StaticType)StaticType.INT, null, 8, null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DateTimePart.values().length];
            nArray[DateTimePart.YEAR.ordinal()] = 1;
            nArray[DateTimePart.MONTH.ordinal()] = 2;
            nArray[DateTimePart.DAY.ordinal()] = 3;
            nArray[DateTimePart.HOUR.ordinal()] = 4;
            nArray[DateTimePart.MINUTE.ordinal()] = 5;
            nArray[DateTimePart.SECOND.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

