/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.math.BigDecimal;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.errors.ErrorCode;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.builtins.internal.ExprFunctionUnaryNumeric;
import org.partiql.lang.util.NumberExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionExp;", "Lorg/partiql/lang/eval/builtins/internal/ExprFunctionUnaryNumeric;", "()V", "call", "", "x", "partiql-lang"})
public final class ExprFunctionExp
extends ExprFunctionUnaryNumeric {
    @NotNull
    public static final ExprFunctionExp INSTANCE = new ExprFunctionExp();

    private ExprFunctionExp() {
        super("exp");
    }

    @Override
    @NotNull
    public Number call(@NotNull Number x) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Number number2 = x;
        if (number2 instanceof Long) {
            number = Math.exp(x.doubleValue());
        } else if (number2 instanceof Double) {
            number = Math.exp(x.doubleValue());
        } else if (number2 instanceof Float) {
            number = Float.valueOf((float)Math.exp(x.floatValue()));
        } else if (number2 instanceof BigDecimal) {
            number = NumberExtensionsKt.exp$default((BigDecimal)x, null, 1, null);
        } else {
            ExceptionsKt.errNoContext("Unknown number type", ErrorCode.INTERNAL_ERROR, true);
            throw new KotlinNothingValueException();
        }
        return number;
    }
}

