/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.math.BigDecimal;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.errors.ErrorCode;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.ExprValueType;
import org.partiql.lang.eval.builtins.internal.TimestampExtensionsKt;
import org.partiql.lang.syntax.impl.DateTimePart;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.types.StaticType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionExtract;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "DATETIME", "Lorg/partiql/types/StaticType;", "signature", "Lorg/partiql/lang/types/FunctionSignature;", "getSignature", "()Lorg/partiql/lang/types/FunctionSignature;", "callWithRequired", "Lorg/partiql/lang/eval/ExprValue;", "session", "Lorg/partiql/lang/eval/EvaluationSession;", "required", "", "eval", "args", "partiql-lang"})
public final class ExprFunctionExtract
implements ExprFunction {
    @NotNull
    public static final ExprFunctionExtract INSTANCE = new ExprFunctionExtract();
    @NotNull
    private static final StaticType DATETIME;
    @NotNull
    private static final FunctionSignature signature;

    private ExprFunctionExtract() {
    }

    @Override
    @NotNull
    public FunctionSignature getSignature() {
        return signature;
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        return ExprValueExtensionsKt.isUnknown(required.get(1)) ? ExprValue.Companion.getNullValue() : this.eval(required);
    }

    private final ExprValue eval(List<? extends ExprValue> args) {
        BigDecimal bigDecimal;
        DateTimePart dateTimePart = ExprValueExtensionsKt.dateTimePartValue(args.get(0));
        switch (WhenMappings.$EnumSwitchMapping$0[args.get(1).getType().ordinal()]) {
            case 1: {
                bigDecimal = TimestampExtensionsKt.extractedValue(ExprValueExtensionsKt.timestampValue(args.get(1)), dateTimePart);
                break;
            }
            case 2: {
                bigDecimal = TimestampExtensionsKt.extractedValue(ExprValueExtensionsKt.dateValue(args.get(1)), dateTimePart);
                break;
            }
            case 3: {
                bigDecimal = TimestampExtensionsKt.extractedValue(ExprValueExtensionsKt.timeValue(args.get(1)), dateTimePart);
                break;
            }
            default: {
                ExceptionsKt.errNoContext("Expected date, time or timestamp: " + args.get(1), ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_FUNC_CALL, false);
                throw new KotlinNothingValueException();
            }
        }
        BigDecimal extractedValue = bigDecimal;
        return ExprValue.Companion.newDecimal(extractedValue);
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing each alternative in required parameter as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithOptional().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        return ExprFunction.DefaultImpls.callWithOptional(this, session, required, opt);
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing the LIST ExprValue in required parameter to represent variadic parameters as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithVariadic().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }

    static {
        Object[] objectArray = new StaticType[]{(StaticType)StaticType.TIMESTAMP, (StaticType)StaticType.TIME, (StaticType)StaticType.DATE};
        DATETIME = StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (StaticType[])objectArray, null, (int)2, null);
        objectArray = new StaticType[]{(StaticType)StaticType.SYMBOL, DATETIME};
        signature = new FunctionSignature("extract", CollectionsKt.listOf((Object[])objectArray), (StaticType)StaticType.DECIMAL, null, 8, null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExprValueType.values().length];
            nArray[ExprValueType.TIMESTAMP.ordinal()] = 1;
            nArray[ExprValueType.DATE.ordinal()] = 2;
            nArray[ExprValueType.TIME.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

