/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.math.BigDecimal;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.errors.ErrorCode;
import org.partiql.lang.eval.EvaluationException;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.time.Time;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0004\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionMakeTime;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "makeTime", "Lorg/partiql/lang/eval/ExprValue;", "hour", "", "minute", "second", "Ljava/math/BigDecimal;", "tzMinutes", "(IILjava/math/BigDecimal;Ljava/lang/Integer;)Lorg/partiql/lang/eval/ExprValue;", "partiql-lang"})
public abstract class ExprFunctionMakeTime
implements ExprFunction {
    @NotNull
    protected final ExprValue makeTime(int hour, int minute, @NotNull BigDecimal second, @Nullable Integer tzMinutes) {
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        try {
            int n = second.intValue();
            BigDecimal bigDecimal = second.remainder(BigDecimal.ONE);
            BigDecimal bigDecimal2 = BigDecimal.valueOf(1000000000);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(this.toLong())");
            return ExprValue.Companion.newTime(Time.Companion.of(hour, minute, n, bigDecimal.multiply(bigDecimal2).intValue(), second.scale(), tzMinutes));
        }
        catch (EvaluationException e) {
            ExceptionsKt.err(e.getMessage(), ErrorCode.EVALUATOR_TIME_FIELD_OUT_OF_RANGE, e.getErrorContext(), false);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        return ExprFunction.DefaultImpls.callWithRequired(this, session, required);
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing each alternative in required parameter as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithOptional().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        return ExprFunction.DefaultImpls.callWithOptional(this, session, required, opt);
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing the LIST ExprValue in required parameter to represent variadic parameters as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithVariadic().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }
}

