/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.errors.ErrorCode;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.builtins.internal.CodePointExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0004\u00a8\u0006\t"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionOverlay;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "overlay", "Lorg/partiql/lang/eval/ExprValue;", "arg0", "arg1", "arg2", "arg3", "partiql-lang"})
public abstract class ExprFunctionOverlay
implements ExprFunction {
    @NotNull
    protected final ExprValue overlay(@NotNull ExprValue arg0, @NotNull ExprValue arg1, @NotNull ExprValue arg2, @Nullable ExprValue arg3) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter((Object)arg1, (String)"arg1");
        Intrinsics.checkNotNullParameter((Object)arg2, (String)"arg2");
        int position = ExprValueExtensionsKt.intValue(arg2);
        if (position < 1) {
            ExceptionsKt.errNoContext("invalid position '" + position + "', must be at least 1", ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_TRIM, false);
            throw new KotlinNothingValueException();
        }
        String source = ExprValueExtensionsKt.stringValue(arg0);
        String overlay = ExprValueExtensionsKt.stringValue(arg1);
        ExprValue exprValue2 = arg3;
        int length = exprValue2 != null ? ExprValueExtensionsKt.intValue(exprValue2) : overlay.length();
        String result = CodePointExtensionsKt.codepointOverlay(source, overlay, position, length);
        return ExprValue.Companion.newString(result);
    }

    public static /* synthetic */ ExprValue overlay$default(ExprFunctionOverlay exprFunctionOverlay, ExprValue exprValue2, ExprValue exprValue3, ExprValue exprValue4, ExprValue exprValue5, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: overlay");
        }
        if ((n & 8) != 0) {
            exprValue5 = null;
        }
        return exprFunctionOverlay.overlay(exprValue2, exprValue3, exprValue4, exprValue5);
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        return ExprFunction.DefaultImpls.callWithRequired(this, session, required);
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing each alternative in required parameter as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithOptional().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        return ExprFunction.DefaultImpls.callWithOptional(this, session, required, opt);
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing the LIST ExprValue in required parameter to represent variadic parameters as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithVariadic().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }
}

