/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.math.BigDecimal;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.errors.ErrorCode;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.builtins.internal.ExprFunctionBinaryNumeric;
import org.partiql.lang.util.NumberExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionPow;", "Lorg/partiql/lang/eval/builtins/internal/ExprFunctionBinaryNumeric;", "()V", "call", "", "x", "y", "partiql-lang"})
public final class ExprFunctionPow
extends ExprFunctionBinaryNumeric {
    @NotNull
    public static final ExprFunctionPow INSTANCE = new ExprFunctionPow();

    private ExprFunctionPow() {
        super("pow");
    }

    @Override
    @NotNull
    public Number call(@NotNull Number x, @NotNull Number y) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Pair<Number, Number> pair = NumberExtensionsKt.isPosInf(x) || NumberExtensionsKt.isNegInf(x) || NumberExtensionsKt.isNaN(x) ? TuplesKt.to((Object)x, (Object)y.doubleValue()) : (NumberExtensionsKt.isPosInf(y) || NumberExtensionsKt.isNegInf(y) || NumberExtensionsKt.isNaN(y) ? TuplesKt.to((Object)x.doubleValue(), (Object)y) : NumberExtensionsKt.coerceNumbers(x, y));
        Number first = (Number)pair.component1();
        Number second = (Number)pair.component2();
        Number number2 = first;
        if (number2 instanceof Long) {
            number = Math.pow(first.doubleValue(), second.doubleValue());
        } else if (number2 instanceof Double) {
            if (first.doubleValue() < 0.0 && !((Double)second % 1.0 == 0.0)) {
                ExceptionsKt.errNoContext("a negative number raised to a non-integer power yields a complex result", ErrorCode.EVALUATOR_ARITHMETIC_EXCEPTION, false);
                throw new KotlinNothingValueException();
            }
            number = Math.pow(first.doubleValue(), (Double)second);
        } else if (number2 instanceof BigDecimal) {
            BigDecimal bigDecimal;
            try {
                bigDecimal = NumberExtensionsKt.power$default((BigDecimal)first, (BigDecimal)second, null, 2, null);
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (string == null) {
                    string = "Arithmetic Error";
                }
                ExceptionsKt.errNoContext(string, ErrorCode.EVALUATOR_ARITHMETIC_EXCEPTION, false);
                throw new KotlinNothingValueException();
            }
            number = bigDecimal;
        } else {
            throw new IllegalStateException();
        }
        return number;
    }
}

