/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0004\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionSubstring;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "substring", "Lorg/partiql/lang/eval/ExprValue;", "target", "", "startPosition", "", "quantity", "(Ljava/lang/String;ILjava/lang/Integer;)Lorg/partiql/lang/eval/ExprValue;", "partiql-lang"})
public abstract class ExprFunctionSubstring
implements ExprFunction {
    @NotNull
    protected final ExprValue substring(@NotNull String target, int startPosition, @Nullable Integer quantity) {
        int adjustedStartPosition;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int codePointCount = target.codePointCount(0, target.length());
        if (startPosition > codePointCount) {
            return ExprValue.Companion.newString("");
        }
        int endPosition = quantity == null ? codePointCount : Integer.min(codePointCount, startPosition + quantity - 1);
        if (endPosition < (adjustedStartPosition = Integer.max(0, startPosition - 1))) {
            return ExprValue.Companion.newString("");
        }
        int byteIndexStart = target.offsetByCodePoints(0, adjustedStartPosition);
        int byteIndexEnd = target.offsetByCodePoints(0, endPosition);
        String string = target.substring(byteIndexStart, byteIndexEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return ExprValue.Companion.newString(string);
    }

    public static /* synthetic */ ExprValue substring$default(ExprFunctionSubstring exprFunctionSubstring, String string, int n, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: substring");
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return exprFunctionSubstring.substring(string, n, n2);
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        return ExprFunction.DefaultImpls.callWithRequired(this, session, required);
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing each alternative in required parameter as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithOptional().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        return ExprFunction.DefaultImpls.callWithOptional(this, session, required, opt);
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing the LIST ExprValue in required parameter to represent variadic parameters as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithVariadic().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }
}

