/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import com.amazon.ion.Timestamp;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.errors.ErrorCode;
import org.partiql.errors.Property;
import org.partiql.errors.PropertyValueMap;
import org.partiql.lang.eval.EvaluationException;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.builtins.timestamp.TimestampTemporalAccessor;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.types.SingleType;
import org.partiql.types.StaticType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionToString;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "signature", "Lorg/partiql/lang/types/FunctionSignature;", "getSignature", "()Lorg/partiql/lang/types/FunctionSignature;", "callWithRequired", "Lorg/partiql/lang/eval/ExprValue;", "session", "Lorg/partiql/lang/eval/EvaluationSession;", "required", "", "errInvalidFormatPattern", "", "pattern", "", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "partiql-lang"})
public final class ExprFunctionToString
implements ExprFunction {
    @NotNull
    public static final ExprFunctionToString INSTANCE = new ExprFunctionToString();
    @NotNull
    private static final FunctionSignature signature;

    private ExprFunctionToString() {
    }

    @Override
    @NotNull
    public FunctionSignature getSignature() {
        return signature;
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        DateTimeFormatter dateTimeFormatter;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        String pattern = ExprValueExtensionsKt.stringValue(required.get(1));
        try {
            DateTimeFormatter dateTimeFormatter2 = DateTimeFormatter.ofPattern(pattern);
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter2, (String)"{\n            DateTimeFo\u2026attern(pattern)\n        }");
            dateTimeFormatter = dateTimeFormatter2;
        }
        catch (IllegalArgumentException ex) {
            this.errInvalidFormatPattern(pattern, ex);
            throw new KotlinNothingValueException();
        }
        DateTimeFormatter formatter = dateTimeFormatter;
        Timestamp timestamp = ExprValueExtensionsKt.timestampValue(required.get(0));
        TimestampTemporalAccessor temporalAccessor = new TimestampTemporalAccessor(timestamp);
        try {
            String string = formatter.format(temporalAccessor);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatter.format(temporalAccessor)");
            return ExprValue.Companion.newString(string);
        }
        catch (UnsupportedTemporalTypeException ex) {
            this.errInvalidFormatPattern(pattern, ex);
            throw new KotlinNothingValueException();
        }
        catch (DateTimeException ex) {
            this.errInvalidFormatPattern(pattern, ex);
            throw new KotlinNothingValueException();
        }
    }

    private final Void errInvalidFormatPattern(String pattern, Exception cause) {
        PropertyValueMap pvmap = new PropertyValueMap(null, 1, null);
        pvmap.set(Property.TIMESTAMP_FORMAT_PATTERN, pattern);
        throw new EvaluationException("Invalid DateTime format pattern", ErrorCode.EVALUATOR_INVALID_TIMESTAMP_FORMAT_PATTERN, pvmap, cause, false);
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing each alternative in required parameter as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithOptional().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        return ExprFunction.DefaultImpls.callWithOptional(this, session, required, opt);
    }

    @Override
    @Deprecated(message="Please define overloaded functions by providing the LIST ExprValue in required parameter to represent variadic parameters as its own ExprFunction; each function is invoked by callWithRequired() rather than callWithVariadic().", level=DeprecationLevel.ERROR)
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }

    static {
        Object[] objectArray = new SingleType[]{(SingleType)StaticType.TIMESTAMP, (SingleType)StaticType.STRING};
        signature = new FunctionSignature("to_string", CollectionsKt.listOf((Object[])objectArray), (StaticType)StaticType.STRING, null, 8, null);
    }
}

