/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins.internal;

import com.amazon.ion.Timestamp;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.errors.ErrorCode;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.time.Time;
import org.partiql.lang.syntax.impl.DateTimePart;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00102\u0006\u0010\f\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0003H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u000bH\u0000\u001a\f\u0010\u0016\u001a\u00020\u0015*\u00020\u000bH\u0000\u001a\u0014\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018*\u00020\u000bH\u0000\" \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"dateTimePartToPrecision", "", "Lorg/partiql/lang/syntax/impl/DateTimePart;", "Lcom/amazon/ion/Timestamp$Precision;", "getDateTimePartToPrecision", "()Ljava/util/Map;", "precisionOrder", "", "getPrecisionOrder", "()Ljava/util/List;", "adjustPrecisionTo", "Lcom/amazon/ion/Timestamp;", "dateTimePart", "extractedValue", "Ljava/math/BigDecimal;", "Ljava/time/LocalDate;", "Lorg/partiql/lang/eval/time/Time;", "hasSufficientPrecisionFor", "", "requiredPrecision", "hourOffset", "", "minuteOffset", "toOffsetDateTime", "Ljava/time/OffsetDateTime;", "kotlin.jvm.PlatformType", "partiql-lang"})
public final class TimestampExtensionsKt {
    @NotNull
    private static final List<Timestamp.Precision> precisionOrder;
    @NotNull
    private static final Map<DateTimePart, Timestamp.Precision> dateTimePartToPrecision;

    @NotNull
    public static final List<Timestamp.Precision> getPrecisionOrder() {
        return precisionOrder;
    }

    @NotNull
    public static final Map<DateTimePart, Timestamp.Precision> getDateTimePartToPrecision() {
        return dateTimePartToPrecision;
    }

    public static final boolean hasSufficientPrecisionFor(@NotNull Timestamp $this$hasSufficientPrecisionFor, @NotNull Timestamp.Precision requiredPrecision) {
        Intrinsics.checkNotNullParameter((Object)$this$hasSufficientPrecisionFor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)requiredPrecision, (String)"requiredPrecision");
        int requiredPrecisionPos = precisionOrder.indexOf(requiredPrecision);
        int precisionPos = precisionOrder.indexOf($this$hasSufficientPrecisionFor.getPrecision());
        return precisionPos >= requiredPrecisionPos;
    }

    @NotNull
    public static final Timestamp adjustPrecisionTo(@NotNull Timestamp $this$adjustPrecisionTo, @NotNull DateTimePart dateTimePart) {
        Timestamp timestamp;
        Intrinsics.checkNotNullParameter((Object)$this$adjustPrecisionTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)dateTimePart), (String)"dateTimePart");
        Timestamp.Precision precision = dateTimePartToPrecision.get((Object)dateTimePart);
        Intrinsics.checkNotNull((Object)precision);
        Timestamp.Precision requiredPrecision = precision;
        if (TimestampExtensionsKt.hasSufficientPrecisionFor($this$adjustPrecisionTo, requiredPrecision)) {
            return $this$adjustPrecisionTo;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[requiredPrecision.ordinal()]) {
            case 1: {
                Timestamp timestamp2 = Timestamp.forYear((int)$this$adjustPrecisionTo.getYear());
                timestamp = timestamp2;
                Intrinsics.checkNotNullExpressionValue((Object)timestamp2, (String)"forYear(this.year)");
                break;
            }
            case 2: {
                Timestamp timestamp3 = Timestamp.forMonth((int)$this$adjustPrecisionTo.getYear(), (int)$this$adjustPrecisionTo.getMonth());
                timestamp = timestamp3;
                Intrinsics.checkNotNullExpressionValue((Object)timestamp3, (String)"forMonth(this.year, this.month)");
                break;
            }
            case 3: {
                Timestamp timestamp4 = Timestamp.forDay((int)$this$adjustPrecisionTo.getYear(), (int)$this$adjustPrecisionTo.getMonth(), (int)$this$adjustPrecisionTo.getDay());
                timestamp = timestamp4;
                Intrinsics.checkNotNullExpressionValue((Object)timestamp4, (String)"forDay(this.year, this.month, this.day)");
                break;
            }
            case 4: {
                Timestamp timestamp5 = Timestamp.forSecond((int)$this$adjustPrecisionTo.getYear(), (int)$this$adjustPrecisionTo.getMonth(), (int)$this$adjustPrecisionTo.getDay(), (int)$this$adjustPrecisionTo.getHour(), (int)$this$adjustPrecisionTo.getMinute(), (int)$this$adjustPrecisionTo.getSecond(), (Integer)$this$adjustPrecisionTo.getLocalOffset());
                timestamp = timestamp5;
                Intrinsics.checkNotNullExpressionValue((Object)timestamp5, (String)"forSecond(\n            t\u2026his.localOffset\n        )");
                break;
            }
            case 5: {
                Timestamp timestamp6 = Timestamp.forMinute((int)$this$adjustPrecisionTo.getYear(), (int)$this$adjustPrecisionTo.getMonth(), (int)$this$adjustPrecisionTo.getDay(), (int)$this$adjustPrecisionTo.getHour(), (int)$this$adjustPrecisionTo.getMinute(), (Integer)$this$adjustPrecisionTo.getLocalOffset());
                timestamp = timestamp6;
                Intrinsics.checkNotNullExpressionValue((Object)timestamp6, (String)"forMinute(\n            t\u2026his.localOffset\n        )");
                break;
            }
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("invalid datetime part for date_add: ");
                String string = dateTimePart.toString().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                ExceptionsKt.errNoContext(stringBuilder.append(string).toString(), ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_DATE_PART, false);
                throw new KotlinNothingValueException();
            }
        }
        return timestamp;
    }

    public static final OffsetDateTime toOffsetDateTime(@NotNull Timestamp $this$toOffsetDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$toOffsetDateTime, (String)"<this>");
        Integer n = $this$toOffsetDateTime.getLocalOffset();
        return OffsetDateTime.of($this$toOffsetDateTime.getYear(), $this$toOffsetDateTime.getMonth(), $this$toOffsetDateTime.getDay(), $this$toOffsetDateTime.getHour(), $this$toOffsetDateTime.getMinute(), $this$toOffsetDateTime.getSecond(), 0, ZoneOffset.ofTotalSeconds((n != null ? n : 0) * 60));
    }

    public static final int hourOffset(@NotNull Timestamp $this$hourOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$hourOffset, (String)"<this>");
        Integer n = $this$hourOffset.getLocalOffset();
        return (n != null ? n : 0) / 60;
    }

    public static final int minuteOffset(@NotNull Timestamp $this$minuteOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$minuteOffset, (String)"<this>");
        Integer n = $this$minuteOffset.getLocalOffset();
        return (n != null ? n : 0) % 60;
    }

    @NotNull
    public static final BigDecimal extractedValue(@NotNull Timestamp $this$extractedValue, @NotNull DateTimePart dateTimePart) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$extractedValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)dateTimePart), (String)"dateTimePart");
        switch (WhenMappings.$EnumSwitchMapping$1[dateTimePart.ordinal()]) {
            case 1: {
                n = $this$extractedValue.getYear();
                break;
            }
            case 2: {
                n = $this$extractedValue.getMonth();
                break;
            }
            case 3: {
                n = $this$extractedValue.getDay();
                break;
            }
            case 4: {
                n = $this$extractedValue.getHour();
                break;
            }
            case 5: {
                n = $this$extractedValue.getMinute();
                break;
            }
            case 6: {
                n = $this$extractedValue.getSecond();
                break;
            }
            case 7: {
                n = TimestampExtensionsKt.hourOffset($this$extractedValue);
                break;
            }
            case 8: {
                n = TimestampExtensionsKt.minuteOffset($this$extractedValue);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(n);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
        return bigDecimal;
    }

    @NotNull
    public static final BigDecimal extractedValue(@NotNull LocalDate $this$extractedValue, @NotNull DateTimePart dateTimePart) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$extractedValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)dateTimePart), (String)"dateTimePart");
        switch (WhenMappings.$EnumSwitchMapping$1[dateTimePart.ordinal()]) {
            case 1: {
                n = $this$extractedValue.getYear();
                break;
            }
            case 2: {
                n = $this$extractedValue.getMonthValue();
                break;
            }
            case 3: {
                n = $this$extractedValue.getDayOfMonth();
                break;
            }
            case 7: 
            case 8: {
                StringBuilder stringBuilder = new StringBuilder().append("Timestamp unit ");
                String string = dateTimePart.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                ExceptionsKt.errNoContext(stringBuilder.append(string).append(" not supported for DATE type").toString(), ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_FUNC_CALL, false);
                throw new KotlinNothingValueException();
            }
            case 4: 
            case 5: 
            case 6: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(n);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
        return bigDecimal;
    }

    @NotNull
    public static final BigDecimal extractedValue(@NotNull Time $this$extractedValue, @NotNull DateTimePart dateTimePart) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)$this$extractedValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)dateTimePart), (String)"dateTimePart");
        switch (WhenMappings.$EnumSwitchMapping$1[dateTimePart.ordinal()]) {
            case 4: {
                BigDecimal bigDecimal = BigDecimal.valueOf($this$extractedValue.getLocalTime().getHour());
                number = bigDecimal;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
                break;
            }
            case 5: {
                BigDecimal bigDecimal = BigDecimal.valueOf($this$extractedValue.getLocalTime().getMinute());
                number = bigDecimal;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
                break;
            }
            case 6: {
                number = $this$extractedValue.getSecondsWithFractionalPart();
                break;
            }
            case 7: {
                number = $this$extractedValue.getTimezoneHour();
                if (number != null) {
                    BigDecimal bigDecimal = BigDecimal.valueOf(((Integer)number).intValue());
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
                    number = bigDecimal;
                    if (bigDecimal != null) break;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Time unit ");
                String string = dateTimePart.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                ExceptionsKt.errNoContext(stringBuilder.append(string).append(" not supported for TIME type without TIME ZONE").toString(), ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_FUNC_CALL, false);
                throw new KotlinNothingValueException();
            }
            case 8: {
                number = $this$extractedValue.getTimezoneMinute();
                if (number != null) {
                    BigDecimal bigDecimal = BigDecimal.valueOf(((Integer)number).intValue());
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
                    number = bigDecimal;
                    if (bigDecimal != null) break;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Time unit ");
                String string = dateTimePart.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                ExceptionsKt.errNoContext(stringBuilder.append(string).append(" not supported for TIME type without TIME ZONE").toString(), ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_FUNC_CALL, false);
                throw new KotlinNothingValueException();
            }
            case 1: 
            case 2: 
            case 3: {
                StringBuilder stringBuilder = new StringBuilder().append("Time unit ");
                String string = dateTimePart.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                ExceptionsKt.errNoContext(stringBuilder.append(string).append(" not supported for TIME type.").toString(), ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_FUNC_CALL, false);
                throw new KotlinNothingValueException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return number;
    }

    static {
        Object[] objectArray = new Timestamp.Precision[]{Timestamp.Precision.YEAR, Timestamp.Precision.MONTH, Timestamp.Precision.DAY, Timestamp.Precision.MINUTE, Timestamp.Precision.SECOND};
        precisionOrder = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)((Object)DateTimePart.YEAR), (Object)Timestamp.Precision.YEAR), TuplesKt.to((Object)((Object)DateTimePart.MONTH), (Object)Timestamp.Precision.MONTH), TuplesKt.to((Object)((Object)DateTimePart.DAY), (Object)Timestamp.Precision.DAY), TuplesKt.to((Object)((Object)DateTimePart.HOUR), (Object)Timestamp.Precision.MINUTE), TuplesKt.to((Object)((Object)DateTimePart.MINUTE), (Object)Timestamp.Precision.MINUTE), TuplesKt.to((Object)((Object)DateTimePart.SECOND), (Object)Timestamp.Precision.SECOND)};
        dateTimePartToPrecision = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Timestamp.Precision.values().length];
            nArray[Timestamp.Precision.YEAR.ordinal()] = 1;
            nArray[Timestamp.Precision.MONTH.ordinal()] = 2;
            nArray[Timestamp.Precision.DAY.ordinal()] = 3;
            nArray[Timestamp.Precision.SECOND.ordinal()] = 4;
            nArray[Timestamp.Precision.MINUTE.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DateTimePart.values().length];
            nArray[DateTimePart.YEAR.ordinal()] = 1;
            nArray[DateTimePart.MONTH.ordinal()] = 2;
            nArray[DateTimePart.DAY.ordinal()] = 3;
            nArray[DateTimePart.HOUR.ordinal()] = 4;
            nArray[DateTimePart.MINUTE.ordinal()] = 5;
            nArray[DateTimePart.SECOND.ordinal()] = 6;
            nArray[DateTimePart.TIMEZONE_HOUR.ordinal()] = 7;
            nArray[DateTimePart.TIMEZONE_MINUTE.ordinal()] = 8;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

