/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins.internal;

import com.amazon.ion.Timestamp;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.errors.ErrorCode;
import org.partiql.errors.Property;
import org.partiql.lang.eval.EvaluationException;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.builtins.timestamp.FormatPattern;
import org.partiql.lang.eval.builtins.timestamp.TimestampField;
import org.partiql.lang.util.PropertyMapHelpersKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/partiql/lang/eval/builtins/internal/TimestampParser;", "", "()V", "Companion", "partiql-lang"})
public final class TimestampParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int TWO_DIGIT_PIVOT_YEAR = 70;

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0013\u0010\f\u001a\u0004\u0018\u00010\u0004*\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f\u00b2\u0006\n\u0010\u0010\u001a\u00020\rX\u008a\u0084\u0002\u00b2\u0006\n\u0010\u0011\u001a\u00020\u0004X\u008a\u0084\u0002"}, d2={"Lorg/partiql/lang/eval/builtins/internal/TimestampParser$Companion;", "", "()V", "TWO_DIGIT_PIVOT_YEAR", "", "getTWO_DIGIT_PIVOT_YEAR", "()I", "parseTimestamp", "Lcom/amazon/ion/Timestamp;", "timestampString", "", "formatPattern", "getLocalOffset", "Ljava/time/temporal/TemporalAccessor;", "(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/Integer;", "partiql-lang", "accessor", "year"})
    public static final class Companion {
        private Companion() {
        }

        public final int getTWO_DIGIT_PIVOT_YEAR() {
            return TWO_DIGIT_PIVOT_YEAR;
        }

        private final Integer getLocalOffset(TemporalAccessor $this$getLocalOffset) {
            Integer n;
            if (!$this$getLocalOffset.isSupported(ChronoField.OFFSET_SECONDS)) {
                n = null;
            } else {
                int offsetSeconds = $this$getLocalOffset.get(ChronoField.OFFSET_SECONDS);
                if (offsetSeconds % 60 != 0) {
                    throw new EvaluationException("The parsed timestamp has a UTC offset that not a multiple of 1 minute. This timestamp cannot be parsed accurately because the maximum resolution for an Ion timestamp offset is 1 minute.", ErrorCode.EVALUATOR_PRECISION_LOSS_WHEN_PARSING_TIMESTAMP, null, null, false, 12, null);
                }
                n = offsetSeconds / 60;
            }
            return n;
        }

        @NotNull
        public final Timestamp parseTimestamp(@NotNull String timestampString, @NotNull String formatPattern) {
            Timestamp timestamp;
            Intrinsics.checkNotNullParameter((Object)timestampString, (String)"timestampString");
            Intrinsics.checkNotNullParameter((Object)formatPattern, (String)"formatPattern");
            FormatPattern pattern = FormatPattern.Companion.fromString(formatPattern);
            pattern.validateForTimestampParsing();
            Lazy accessor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TemporalAccessor>(pattern, timestampString){
                final /* synthetic */ FormatPattern $pattern;
                final /* synthetic */ String $timestampString;
                {
                    this.$pattern = $pattern;
                    this.$timestampString = $timestampString;
                    super(0);
                }

                public final TemporalAccessor invoke() {
                    TemporalAccessor temporalAccessor;
                    try {
                        temporalAccessor = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(this.$pattern.getFormatPatternString()).toFormatter().parse(this.$timestampString);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new EvaluationException(ex, ErrorCode.EVALUATOR_INVALID_TIMESTAMP_FORMAT_PATTERN, null, false, 4, null);
                    }
                    return temporalAccessor;
                }
            }));
            Lazy year$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(pattern, (Lazy<? extends TemporalAccessor>)accessor$delegate){
                final /* synthetic */ FormatPattern $pattern;
                final /* synthetic */ Lazy<TemporalAccessor> $accessor$delegate;
                {
                    this.$pattern = $pattern;
                    this.$accessor$delegate = $accessor$delegate;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    int year2 = org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.access$parseTimestamp$lambda-0(this.$accessor$delegate).get(ChronoField.YEAR);
                    return !this.$pattern.getHas2DigitYear() || year2 < TimestampParser.Companion.getTWO_DIGIT_PIVOT_YEAR() + 2000 ? year2 : year2 - 100;
                }
            }));
            try {
                Timestamp timestamp2;
                TimestampField timestampField = pattern.getLeastSignificantField();
                switch (timestampField == null ? -1 : WhenMappings.$EnumSwitchMapping$0[timestampField.ordinal()]) {
                    case 1: {
                        BigDecimal nanoSeconds = BigDecimal.valueOf(org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).getLong(ChronoField.NANO_OF_SECOND));
                        BigDecimal secondsFraction = nanoSeconds.scaleByPowerOfTen(-9).stripTrailingZeros();
                        BigDecimal bigDecimal = BigDecimal.valueOf(org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).getLong(ChronoField.SECOND_OF_MINUTE)).add(secondsFraction);
                        if (bigDecimal == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.math.BigDecimal");
                        }
                        timestamp2 = Timestamp.forSecond((int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-1((Lazy<Integer>)year$delegate), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.MONTH_OF_YEAR), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.DAY_OF_MONTH), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.HOUR_OF_DAY), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.MINUTE_OF_HOUR), (BigDecimal)bigDecimal, (Integer)this.getLocalOffset(org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate)));
                        break;
                    }
                    case 2: {
                        timestamp2 = Timestamp.forSecond((int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-1((Lazy<Integer>)year$delegate), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.MONTH_OF_YEAR), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.DAY_OF_MONTH), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.HOUR_OF_DAY), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.MINUTE_OF_HOUR), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.SECOND_OF_MINUTE), (Integer)this.getLocalOffset(org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate)));
                        break;
                    }
                    case 3: {
                        timestamp2 = Timestamp.forMinute((int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-1((Lazy<Integer>)year$delegate), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.MONTH_OF_YEAR), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.DAY_OF_MONTH), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.HOUR_OF_DAY), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.MINUTE_OF_HOUR), (Integer)this.getLocalOffset(org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate)));
                        break;
                    }
                    case 4: {
                        timestamp2 = Timestamp.forMinute((int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-1((Lazy<Integer>)year$delegate), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.MONTH_OF_YEAR), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.DAY_OF_MONTH), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.HOUR_OF_DAY), (int)0, (Integer)this.getLocalOffset(org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate)));
                        break;
                    }
                    case 5: {
                        timestamp2 = Timestamp.forDay((int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-1((Lazy<Integer>)year$delegate), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.MONTH_OF_YEAR), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.DAY_OF_MONTH));
                        break;
                    }
                    case 6: {
                        timestamp2 = Timestamp.forMonth((int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-1((Lazy<Integer>)year$delegate), (int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)accessor$delegate).get(ChronoField.MONTH_OF_YEAR));
                        break;
                    }
                    case 7: {
                        timestamp2 = Timestamp.forYear((int)org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-1((Lazy<Integer>)year$delegate));
                        break;
                    }
                    case -1: 
                    case 8: 
                    case 9: {
                        ExceptionsKt.errNoContext("This code should be unreachable because AM_PM or OFFSET or nullshould never the value of formatPattern.leastSignificantField by at this point", ErrorCode.EVALUATOR_INVALID_TIMESTAMP_FORMAT_PATTERN, true);
                        throw new KotlinNothingValueException();
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                timestamp = timestamp2;
                Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"{\n                when (\u2026          }\n            }");
            }
            catch (IllegalArgumentException ex) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Property.TIMESTAMP_FORMAT_PATTERN, (Object)formatPattern)};
                throw new EvaluationException(ex, ErrorCode.EVALUATOR_CUSTOM_TIMESTAMP_PARSE_FAILURE, PropertyMapHelpersKt.propertyValueMapOf(pairArray), false);
            }
            catch (DateTimeException ex) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Property.TIMESTAMP_FORMAT_PATTERN, (Object)formatPattern)};
                throw new EvaluationException(ex, ErrorCode.EVALUATOR_CUSTOM_TIMESTAMP_PARSE_FAILURE, PropertyMapHelpersKt.propertyValueMapOf(pairArray), false);
            }
            return timestamp;
        }

        private static final TemporalAccessor parseTimestamp$lambda-0(Lazy<? extends TemporalAccessor> $accessor$delegate) {
            Lazy<? extends TemporalAccessor> lazy = $accessor$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parseTimestamp$lambda-0(...)");
            return (TemporalAccessor)object;
        }

        private static final int parseTimestamp$lambda-1(Lazy<Integer> $year$delegate) {
            Lazy<Integer> lazy = $year$delegate;
            return ((Number)lazy.getValue()).intValue();
        }

        public static final /* synthetic */ TemporalAccessor access$parseTimestamp$lambda-0(Lazy $accessor$delegate) {
            return org.partiql.lang.eval.builtins.internal.TimestampParser$Companion.parseTimestamp$lambda-0((Lazy<? extends TemporalAccessor>)$accessor$delegate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TimestampField.values().length];
                nArray[TimestampField.FRACTION_OF_SECOND.ordinal()] = 1;
                nArray[TimestampField.SECOND_OF_MINUTE.ordinal()] = 2;
                nArray[TimestampField.MINUTE_OF_HOUR.ordinal()] = 3;
                nArray[TimestampField.HOUR_OF_DAY.ordinal()] = 4;
                nArray[TimestampField.DAY_OF_MONTH.ordinal()] = 5;
                nArray[TimestampField.MONTH_OF_YEAR.ordinal()] = 6;
                nArray[TimestampField.YEAR.ordinal()] = 7;
                nArray[TimestampField.AM_PM.ordinal()] = 8;
                nArray[TimestampField.OFFSET.ordinal()] = 9;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

