/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.eval.ArityMismatchException;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValueType;
import org.partiql.lang.eval.FunctionNotFoundException;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.lang.types.StaticTypeUtils;
import org.partiql.types.StaticType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u0000\u00a2\u0006\u0002\b\u000fJ+\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u0000\u00a2\u0006\u0002\b\u0014J'\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u00a2\u0006\u0002\b\u0018R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/partiql/lang/eval/impl/FunctionManager;", "", "functions", "", "Lorg/partiql/lang/eval/ExprFunction;", "(Ljava/util/List;)V", "functionMap", "", "", "checkArgumentTypesEnableNullMissing", "", "signature", "Lorg/partiql/lang/types/FunctionSignature;", "args", "Lorg/partiql/types/StaticType;", "checkArgumentTypesEnableNullMissing$partiql_lang", "get", "name", "arity", "", "get$partiql_lang", "getMinMaxArities", "Lkotlin/Pair;", "funcs", "getMinMaxArities$partiql_lang", "partiql-lang"})
public final class FunctionManager {
    @NotNull
    private final List<ExprFunction> functions;
    @NotNull
    private final Map<String, List<ExprFunction>> functionMap;

    /*
     * WARNING - void declaration
     */
    public FunctionManager(@NotNull List<? extends ExprFunction> functions) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        this.functions = functions;
        Iterable iterable = this.functions;
        FunctionManager functionManager = this;
        boolean $i$f$groupBy = false;
        void var4_5 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ExprFunction it = (ExprFunction)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getSignature().getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        functionManager.functionMap = destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExprFunction get$partiql_lang(@NotNull String name, int arity, @NotNull List<? extends StaticType> args) throws FunctionNotFoundException, ArityMismatchException {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        List<ExprFunction> list = this.functionMap.get(name);
        if (list == null) {
            throw new FunctionNotFoundException("Name check fails");
        }
        List<ExprFunction> funcs = list;
        Iterable $this$filter$iv = funcs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ExprFunction it = (ExprFunction)element$iv$iv;
            boolean bl = false;
            if (!it.getSignature().getArity().contains(arity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List funcsMatchingArity = (List)destination$iv$iv;
        if (funcsMatchingArity.isEmpty()) {
            throw new ArityMismatchException("Arity check fails", this.getMinMaxArities$partiql_lang(funcs));
        }
        List errorList = new ArrayList();
        for (ExprFunction func : funcsMatchingArity) {
            try {
                this.checkArgumentTypesEnableNullMissing$partiql_lang(func.getSignature(), args);
                return func;
            }
            catch (Exception e) {
                errorList.add(e);
            }
        }
        throw (Throwable)CollectionsKt.first((List)errorList);
    }

    public final void checkArgumentTypesEnableNullMissing$partiql_lang(@NotNull FunctionSignature signature, @NotNull List<? extends StaticType> args) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Iterable $this$forEachIndexed$iv = CollectionsKt.zip((Iterable)signature.getRequiredParameters(), (Iterable)args);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv;
            int idx = n;
            boolean bl = false;
            StaticType expected = (StaticType)pair.component1();
            StaticType actual = (StaticType)pair.component2();
            FunctionManager.checkArgumentTypesEnableNullMissing$checkArgumentType(signature, expected, actual, idx + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Integer, Integer> getMinMaxArities$partiql_lang(@NotNull List<? extends ExprFunction> funcs) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(funcs, (String)"funcs");
        Iterable $this$map$iv = funcs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ExprFunction exprFunction = (ExprFunction)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSignature().getArity().getFirst());
        }
        Integer n = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
        int minArity = n != null ? n : Integer.MAX_VALUE;
        Iterable $this$map$iv2 = funcs;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExprFunction bl = (ExprFunction)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getSignature().getArity().getLast());
        }
        Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
        int maxArity = n2 != null ? n2 : Integer.MIN_VALUE;
        return new Pair((Object)minArity, (Object)maxArity);
    }

    private static final void checkArgumentTypesEnableNullMissing$checkArgumentType(FunctionSignature $signature, StaticType formalStaticType, StaticType actualStaticType, int position) {
        Set<ExprValueType> formalExprValueTypeDomain = StaticTypeUtils.getTypeDomain(formalStaticType);
        if (!(Intrinsics.areEqual((Object)actualStaticType, (Object)StaticType.NULL) || Intrinsics.areEqual((Object)actualStaticType, (Object)StaticType.MISSING) || StaticTypeUtils.isSubTypeOf(actualStaticType, formalStaticType))) {
            ExceptionsKt.errInvalidArgumentType($signature, position, CollectionsKt.toList((Iterable)formalExprValueTypeDomain), actualStaticType);
            throw new KotlinNothingValueException();
        }
    }
}

