/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.io;

import com.amazon.ion.IonDecimal;
import com.amazon.ion.IonException;
import com.amazon.ion.IonFloat;
import com.amazon.ion.IonInt;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonTimestamp;
import com.amazon.ion.IonType;
import com.amazon.ion.IonValue;
import com.amazon.ion.system.IonSystemBuilder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.eval.BindingCase;
import org.partiql.lang.eval.BindingName;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.StandardNamesKt;
import org.partiql.lang.eval.StructOrdering;
import org.partiql.lang.util.IonValueExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\f\u0010\u0018\u001a\u00020\u0015*\u00020\u0019H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/partiql/lang/eval/io/DelimitedValues;", "", "()V", "exprValue", "Lorg/partiql/lang/eval/ExprValue;", "input", "Ljava/io/Reader;", "csvFormat", "Lorg/apache/commons/csv/CSVFormat;", "conversionMode", "Lorg/partiql/lang/eval/io/DelimitedValues$ConversionMode;", "writeTo", "", "ion", "Lcom/amazon/ion/IonSystem;", "output", "Ljava/io/Writer;", "value", "delimiter", "", "newline", "", "writeHeader", "", "csvStringValue", "Lcom/amazon/ion/IonValue;", "ConversionMode", "partiql-lang"})
public final class DelimitedValues {
    @NotNull
    public static final DelimitedValues INSTANCE = new DelimitedValues();

    private DelimitedValues() {
    }

    @JvmStatic
    @NotNull
    public static final ExprValue exprValue(@NotNull Reader input, @NotNull CSVFormat csvFormat, @NotNull ConversionMode conversionMode) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)csvFormat, (String)"csvFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)conversionMode), (String)"conversionMode");
        BufferedReader reader = new BufferedReader(input);
        CSVParser csvParser = new CSVParser((Reader)reader, csvFormat);
        List list = csvParser.getHeaderNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"csvParser.headerNames");
        List columns = list;
        Sequence seq2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)csvParser)), (Function1)((Function1)new Function1<CSVRecord, ExprValue>((List<String>)columns, conversionMode){
            final /* synthetic */ List<String> $columns;
            final /* synthetic */ ConversionMode $conversionMode;
            {
                this.$columns = $columns;
                this.$conversionMode = $conversionMode;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ExprValue invoke(CSVRecord csvRecord) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Intrinsics.checkNotNullExpressionValue((Object)csvRecord, (String)"csvRecord");
                Iterable iterable = (Iterable)csvRecord;
                List<String> list = this.$columns;
                ConversionMode conversionMode = this.$conversionMode;
                ExprValue.Companion companion = ExprValue.Companion;
                boolean $i$f$mapIndexed = false;
                void var6_7 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void value;
                    void i;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string = (String)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String name = i < list.size() ? list.get((int)i) : StandardNamesKt.syntheticColumnName((int)i);
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    collection.add(ExprValueExtensionsKt.namedValue(conversionMode.convert((String)value), ExprValue.Companion.newString(name)));
                }
                return companion.newStruct((List)destination$iv$iv, StructOrdering.ORDERED);
            }
        }));
        return ExprValue.Companion.newBag((Sequence<? extends ExprValue>)seq2);
    }

    private final String csvStringValue(IonValue $this$csvStringValue) {
        String string;
        IonType ionType = $this$csvStringValue.getType();
        switch (ionType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[ionType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = $this$csvStringValue.toString();
                break;
            }
            case 7: 
            case 8: {
                string = IonValueExtensionsKt.stringValue($this$csvStringValue);
                if (string != null) break;
                string = $this$csvStringValue.toString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Delimited data column must not be " + $this$csvStringValue.getType() + " type");
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void writeTo(@NotNull IonSystem ion, @NotNull Writer output, @NotNull ExprValue value, char delimiter, @NotNull String newline, boolean writeHeader) {
        Intrinsics.checkNotNullParameter((Object)ion, (String)"ion");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)newline, (String)"newline");
        Closeable closeable = (Closeable)new CSVPrinter((Appendable)output, CSVFormat.DEFAULT.withDelimiter(delimiter).withRecordSeparator(newline));
        Throwable throwable = null;
        try {
            CSVPrinter csvPrinter = (CSVPrinter)closeable;
            boolean bl = false;
            List<String> names = null;
            for (ExprValue row : value) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List<String> colNames;
                if (ExprValueExtensionsKt.getOrderedNames(row) == null) {
                    throw new IllegalArgumentException("Delimited data must be ordered tuple: " + row);
                }
                if (names == null) {
                    names = colNames;
                    if (writeHeader) {
                        csvPrinter.printRecord((Iterable)names);
                    }
                } else if (!Intrinsics.areEqual(names, colNames)) {
                    throw new IllegalArgumentException("Inconsistent row names: " + colNames + " != " + names);
                }
                Iterable iterable = names;
                CSVPrinter cSVPrinter = csvPrinter;
                boolean $i$f$map = false;
                void var17_19 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    ExprValue exprValue2 = row.getBindings().get(new BindingName((String)it, BindingCase.SENSITIVE));
                    if (exprValue2 == null || (exprValue2 = ExprValueExtensionsKt.toIonValue(exprValue2, ion)) == null) {
                        exprValue2 = (IonValue)ion.newNull();
                    }
                    ExprValue col = exprValue2;
                    Intrinsics.checkNotNullExpressionValue((Object)col, (String)"col");
                    collection.add(INSTANCE.csvStringValue((IonValue)col));
                }
                cSVPrinter.printRecord((Iterable)((List)destination$iv$iv));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/partiql/lang/eval/io/DelimitedValues$ConversionMode;", "", "(Ljava/lang/String;I)V", "convert", "Lorg/partiql/lang/eval/ExprValue;", "raw", "", "AUTO", "NONE", "partiql-lang"})
    public static final abstract class ConversionMode
    extends Enum<ConversionMode> {
        public static final /* enum */ ConversionMode AUTO = new AUTO("AUTO", 0);
        public static final /* enum */ ConversionMode NONE = new NONE("NONE", 1);
        private static final /* synthetic */ ConversionMode[] $VALUES;

        private ConversionMode() {
        }

        @NotNull
        public abstract ExprValue convert(@NotNull String var1);

        public static ConversionMode[] values() {
            return (ConversionMode[])$VALUES.clone();
        }

        public static ConversionMode valueOf(String value) {
            return Enum.valueOf(ConversionMode.class, value);
        }

        public /* synthetic */ ConversionMode(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = conversionModeArray = new ConversionMode[]{ConversionMode.AUTO, ConversionMode.NONE};
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/partiql/lang/eval/io/DelimitedValues$ConversionMode$AUTO;", "Lorg/partiql/lang/eval/io/DelimitedValues$ConversionMode;", "convert", "Lorg/partiql/lang/eval/ExprValue;", "raw", "", "partiql-lang"})
        static final class AUTO
        extends ConversionMode {
            /*
             * WARNING - void declaration
             */
            AUTO() {
                void var1_1;
            }

            @Override
            @NotNull
            public ExprValue convert(@NotNull String raw) {
                ExprValue exprValue2;
                Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
                try {
                    ExprValue exprValue3;
                    IonSystem ion = IonSystemBuilder.standard().build();
                    IonValue converted = ion.singleValue(raw);
                    if (((converted instanceof IonInt ? true : converted instanceof IonFloat) ? true : converted instanceof IonDecimal) ? true : converted instanceof IonTimestamp) {
                        Intrinsics.checkNotNullExpressionValue((Object)converted, (String)"converted");
                        exprValue3 = ExprValue.Companion.of(converted);
                    } else {
                        exprValue3 = ExprValue.Companion.newString(raw);
                    }
                    exprValue2 = exprValue3;
                }
                catch (IonException e) {
                    exprValue2 = ExprValue.Companion.newString(raw);
                }
                return exprValue2;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/partiql/lang/eval/io/DelimitedValues$ConversionMode$NONE;", "Lorg/partiql/lang/eval/io/DelimitedValues$ConversionMode;", "convert", "Lorg/partiql/lang/eval/ExprValue;", "raw", "", "partiql-lang"})
        static final class NONE
        extends ConversionMode {
            /*
             * WARNING - void declaration
             */
            NONE() {
                void var1_1;
            }

            @Override
            @NotNull
            public ExprValue convert(@NotNull String raw) {
                Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
                return ExprValue.Companion.newString(raw);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IonType.values().length];
            nArray[IonType.NULL.ordinal()] = 1;
            nArray[IonType.BOOL.ordinal()] = 2;
            nArray[IonType.INT.ordinal()] = 3;
            nArray[IonType.FLOAT.ordinal()] = 4;
            nArray[IonType.DECIMAL.ordinal()] = 5;
            nArray[IonType.TIMESTAMP.ordinal()] = 6;
            nArray[IonType.SYMBOL.ordinal()] = 7;
            nArray[IonType.STRING.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

