/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.physical.operators;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.physical.operators.Accumulator;
import org.partiql.lang.eval.physical.operators.AccumulatorKt;
import org.partiql.lang.util.NumberExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0016R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/partiql/lang/eval/physical/operators/AccumulatorSum;", "Lorg/partiql/lang/eval/physical/operators/Accumulator;", "filter", "Lkotlin/Function1;", "Lorg/partiql/lang/eval/ExprValue;", "", "(Lkotlin/jvm/functions/Function1;)V", "getFilter$partiql_lang", "()Lkotlin/jvm/functions/Function1;", "sum", "", "getSum", "()Ljava/lang/Number;", "setSum", "(Ljava/lang/Number;)V", "compute", "nextValue", "", "value", "partiql-lang"})
public final class AccumulatorSum
extends Accumulator {
    @NotNull
    private final Function1<ExprValue, Boolean> filter;
    @Nullable
    private Number sum;

    public AccumulatorSum(@NotNull Function1<? super ExprValue, Boolean> filter2) {
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        super(filter2, null);
        this.filter = filter2;
    }

    @Override
    @NotNull
    public Function1<ExprValue, Boolean> getFilter$partiql_lang() {
        return this.filter;
    }

    @Nullable
    public final Number getSum() {
        return this.sum;
    }

    public final void setSum(@Nullable Number number) {
        this.sum = number;
    }

    @Override
    public void nextValue(@NotNull ExprValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        AccumulatorKt.checkIsNumberType("SUM", value);
        if (this.sum == null) {
            this.sum = 0L;
        }
        Number number = ExprValueExtensionsKt.numberValue(value);
        Number number2 = this.sum;
        Intrinsics.checkNotNull((Object)number2);
        this.sum = NumberExtensionsKt.plus(number, number2);
    }

    @Override
    @NotNull
    public ExprValue compute() {
        Object object = this.sum;
        if (object == null || (object = NumberExtensionsKt.exprValue((Number)object)) == null) {
            object = ExprValue.Companion.getNullValue();
        }
        return object;
    }
}

