/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.physical.operators;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.errors.ErrorCode;
import org.partiql.errors.Property;
import org.partiql.errors.PropertyValueMap;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.ExprValueType;
import org.partiql.lang.eval.physical.EvaluatorState;
import org.partiql.lang.eval.physical.operators.RelationExpression;
import org.partiql.lang.eval.physical.operators.ValueExpression;
import org.partiql.lang.eval.relation.RelationIterator;
import org.partiql.lang.eval.relation.RelationKt;
import org.partiql.lang.eval.relation.RelationScope;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/partiql/lang/eval/physical/operators/LimitOperator;", "Lorg/partiql/lang/eval/physical/operators/RelationExpression;", "input", "limit", "Lorg/partiql/lang/eval/physical/operators/ValueExpression;", "(Lorg/partiql/lang/eval/physical/operators/RelationExpression;Lorg/partiql/lang/eval/physical/operators/ValueExpression;)V", "evalLimitRowCount", "", "rowCountExpr", "env", "Lorg/partiql/lang/eval/physical/EvaluatorState;", "evaluate", "Lorg/partiql/lang/eval/relation/RelationIterator;", "state", "partiql-lang"})
public final class LimitOperator
implements RelationExpression {
    @NotNull
    private final RelationExpression input;
    @NotNull
    private final ValueExpression limit;

    public LimitOperator(@NotNull RelationExpression input, @NotNull ValueExpression limit) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)limit, (String)"limit");
        this.input = input;
        this.limit = limit;
    }

    @Override
    @NotNull
    public RelationIterator evaluate(@NotNull EvaluatorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        long limit = this.evalLimitRowCount(this.limit, state);
        RelationIterator rows2 = this.input.evaluate(state);
        return RelationKt.relation(rows2.getRelType(), (Function2<? super RelationScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<RelationScope, Continuation<? super Unit>, Object>(limit, rows2, null){
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ long $limit;
            final /* synthetic */ RelationIterator $rows;
            {
                this.$limit = $limit;
                this.$rows = $rows;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block0 : switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$relation = (RelationScope)this.L$0;
                        rowCount = 0L;
lbl7:
                        // 2 sources

                        while (true) {
                            var5_5 = rowCount;
                            rowCount = var5_5 + 1L;
                            if (var5_5 >= this.$limit || !this.$rows.nextRow()) break block0;
                            this.L$0 = $this$relation;
                            this.J$0 = rowCount;
                            this.label = 1;
                            v0 = $this$relation.yield((Continuation<? super Unit>)((Continuation)this));
                            if (v0 != var7_2) continue;
                            return var7_2;
                        }
                    }
                    case 1: {
                        rowCount = this.J$0;
                        $this$relation = (RelationScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** continue;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<RelationScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull RelationScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final long evalLimitRowCount(ValueExpression rowCountExpr, EvaluatorState env) {
        long limitValue;
        ExprValue limitExprValue = rowCountExpr.invoke(env);
        if (limitExprValue.getType() != ExprValueType.INT) {
            void it;
            PropertyValueMap propertyValueMap;
            PropertyValueMap propertyValueMap2 = propertyValueMap = ExceptionsKt.errorContextFrom(rowCountExpr.getSourceLocation());
            ErrorCode errorCode = ErrorCode.EVALUATOR_NON_INT_LIMIT_VALUE;
            String string = "LIMIT value was not an integer";
            boolean bl = false;
            it.set(Property.ACTUAL_TYPE, limitExprValue.getType().toString());
            Unit unit = Unit.INSTANCE;
            ExceptionsKt.err(string, errorCode, propertyValueMap, false);
            throw new KotlinNothingValueException();
        }
        Number originalLimitValue = ExprValueExtensionsKt.numberValue(limitExprValue);
        if (!Intrinsics.areEqual((Object)originalLimitValue, (Object)(limitValue = originalLimitValue.longValue()))) {
            ExceptionsKt.err("Integer exceeds Long.MAX_VALUE provided as LIMIT value", ErrorCode.INTERNAL_ERROR, ExceptionsKt.errorContextFrom(rowCountExpr.getSourceLocation()), true);
            throw new KotlinNothingValueException();
        }
        if (limitValue < 0L) {
            ExceptionsKt.err("negative LIMIT", ErrorCode.EVALUATOR_NEGATIVE_LIMIT, ExceptionsKt.errorContextFrom(rowCountExpr.getSourceLocation()), false);
            throw new KotlinNothingValueException();
        }
        return limitValue;
    }
}

