/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.time;

import com.amazon.ion.IonStruct;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.errors.ErrorCode;
import org.partiql.lang.eval.EvaluationException;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.util.PropertyMapHelpersKt;
import org.partiql.lang.util.TimeExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 -2\u00020\u0001:\u0001-B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\b\u0010#\u001a\u00020$H\u0002J\t\u0010%\u001a\u00020\u0005H\u00d6\u0001J\u000e\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0000J\u000e\u0010'\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0000J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006."}, d2={"Lorg/partiql/lang/eval/time/Time;", "", "localTime", "Ljava/time/LocalTime;", "precision", "", "zoneOffset", "Ljava/time/ZoneOffset;", "(Ljava/time/LocalTime;ILjava/time/ZoneOffset;)V", "getLocalTime", "()Ljava/time/LocalTime;", "offsetTime", "Ljava/time/OffsetTime;", "getOffsetTime", "()Ljava/time/OffsetTime;", "getPrecision", "()I", "secondsWithFractionalPart", "Ljava/math/BigDecimal;", "getSecondsWithFractionalPart", "()Ljava/math/BigDecimal;", "timezoneHour", "getTimezoneHour", "()Ljava/lang/Integer;", "timezoneMinute", "getTimezoneMinute", "getZoneOffset", "()Ljava/time/ZoneOffset;", "component1", "component2", "component3", "copy", "equals", "", "other", "formatterPattern", "", "hashCode", "isDirectlyComparableTo", "naturalOrderCompareTo", "toIonValue", "Lcom/amazon/ion/IonStruct;", "ion", "Lcom/amazon/ion/IonSystem;", "toString", "Companion", "partiql-lang"})
public final class Time {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalTime localTime;
    private final int precision;
    @Nullable
    private final ZoneOffset zoneOffset;
    private static final int LESS = -1;
    private static final int MORE = 1;

    private Time(LocalTime localTime, int precision, ZoneOffset zoneOffset) {
        this.localTime = localTime;
        this.precision = precision;
        this.zoneOffset = zoneOffset;
        if (this.precision < 0 || this.precision > 9) {
            ExceptionsKt.err("Specified precision for TIME should be a non-negative integer between 0 and 9 inclusive", ErrorCode.EVALUATOR_INVALID_PRECISION_FOR_TIME, PropertyMapHelpersKt.propertyValueMapOf(new Pair[0]), false);
            throw new KotlinNothingValueException();
        }
    }

    /* synthetic */ Time(LocalTime localTime, int n, ZoneOffset zoneOffset, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            zoneOffset = null;
        }
        this(localTime, n, zoneOffset);
    }

    @NotNull
    public final LocalTime getLocalTime() {
        return this.localTime;
    }

    public final int getPrecision() {
        return this.precision;
    }

    @Nullable
    public final ZoneOffset getZoneOffset() {
        return this.zoneOffset;
    }

    @Nullable
    public final OffsetTime getOffsetTime() {
        OffsetTime offsetTime;
        ZoneOffset zoneOffset = this.zoneOffset;
        if (zoneOffset != null) {
            ZoneOffset it = zoneOffset;
            boolean bl = false;
            offsetTime = OffsetTime.of(this.localTime, it);
        } else {
            offsetTime = null;
        }
        return offsetTime;
    }

    @Nullable
    public final Integer getTimezoneHour() {
        ZoneOffset zoneOffset = this.zoneOffset;
        return zoneOffset != null ? Integer.valueOf(zoneOffset.getTotalSeconds() / 3600) : null;
    }

    @Nullable
    public final Integer getTimezoneMinute() {
        ZoneOffset zoneOffset = this.zoneOffset;
        return zoneOffset != null ? Integer.valueOf(zoneOffset.getTotalSeconds() / 60 % 60) : null;
    }

    @NotNull
    public final BigDecimal getSecondsWithFractionalPart() {
        BigDecimal bigDecimal = BigDecimal.valueOf(this.localTime.getSecond());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
        BigDecimal bigDecimal2 = bigDecimal;
        BigDecimal bigDecimal3 = BigDecimal.valueOf(this.localTime.getNano());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"valueOf(this.toLong())");
        BigDecimal bigDecimal4 = BigDecimal.valueOf(1000000000);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"valueOf(this.toLong())");
        BigDecimal bigDecimal5 = bigDecimal3.divide(bigDecimal4);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"localTime.nano.toBigDeci\u2026ER_SECOND.toBigDecimal())");
        BigDecimal bigDecimal6 = bigDecimal2.add(bigDecimal5);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"this.add(other)");
        BigDecimal bigDecimal7 = bigDecimal6.setScale(this.precision, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal7, (String)"localTime.second.toBigDe\u2026, RoundingMode.HALF_EVEN)");
        return bigDecimal7;
    }

    @NotNull
    public final IonStruct toIonValue(@NotNull IonSystem ion) {
        IonStruct ionStruct;
        Intrinsics.checkNotNullParameter((Object)ion, (String)"ion");
        IonStruct $this$toIonValue_u24lambda_u2d1 = ionStruct = ion.newEmptyStruct();
        boolean bl = false;
        $this$toIonValue_u24lambda_u2d1.add("hour", (IonValue)ion.newInt(this.localTime.getHour()));
        $this$toIonValue_u24lambda_u2d1.add("minute", (IonValue)ion.newInt(this.localTime.getMinute()));
        $this$toIonValue_u24lambda_u2d1.add("second", (IonValue)ion.newDecimal(this.getSecondsWithFractionalPart()));
        $this$toIonValue_u24lambda_u2d1.add("timezone_hour", (IonValue)ion.newInt((Number)this.getTimezoneHour()));
        $this$toIonValue_u24lambda_u2d1.add("timezone_minute", (IonValue)ion.newInt((Number)this.getTimezoneMinute()));
        $this$toIonValue_u24lambda_u2d1.addTypeAnnotation("$time");
        IonStruct ionStruct2 = ionStruct;
        Intrinsics.checkNotNullExpressionValue((Object)ionStruct2, (String)"ion.newEmptyStruct().app\u2026IME_ANNOTATION)\n        }");
        return ionStruct2;
    }

    private final String formatterPattern() {
        return "HH:mm:ss" + (this.precision > 0 ? '.' + StringsKt.repeat((CharSequence)"S", (int)Math.min(9, this.precision)) : "");
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.localTime.format(DateTimeFormatter.ofPattern(this.formatterPattern())));
        Object object = this.zoneOffset;
        if (object == null || (object = TimeExtensionsKt.getOffsetHHmm((ZoneOffset)object)) == null) {
            object = "";
        }
        return stringBuilder.append((String)object).toString();
    }

    public final boolean isDirectlyComparableTo(@NotNull Time other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.zoneOffset == null && other.zoneOffset == null || this.zoneOffset != null && other.zoneOffset != null;
    }

    public final int naturalOrderCompareTo(@NotNull Time other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.zoneOffset != null && other.zoneOffset != null) {
            OffsetTime offsetTime = this.getOffsetTime();
            Intrinsics.checkNotNull((Object)offsetTime);
            n = offsetTime.compareTo(other.getOffsetTime());
        } else {
            n = this.zoneOffset == null && other.zoneOffset == null ? this.localTime.compareTo(other.localTime) : (this.zoneOffset == null && other.zoneOffset != null ? -1 : 1);
        }
        return n;
    }

    @NotNull
    public final LocalTime component1() {
        return this.localTime;
    }

    public final int component2() {
        return this.precision;
    }

    @Nullable
    public final ZoneOffset component3() {
        return this.zoneOffset;
    }

    @NotNull
    public final Time copy(@NotNull LocalTime localTime, int precision, @Nullable ZoneOffset zoneOffset) {
        Intrinsics.checkNotNullParameter((Object)localTime, (String)"localTime");
        return new Time(localTime, precision, zoneOffset);
    }

    public static /* synthetic */ Time copy$default(Time time, LocalTime localTime, int n, ZoneOffset zoneOffset, int n2, Object object) {
        if ((n2 & 1) != 0) {
            localTime = time.localTime;
        }
        if ((n2 & 2) != 0) {
            n = time.precision;
        }
        if ((n2 & 4) != 0) {
            zoneOffset = time.zoneOffset;
        }
        return time.copy(localTime, n, zoneOffset);
    }

    public int hashCode() {
        int result = this.localTime.hashCode();
        result = result * 31 + Integer.hashCode(this.precision);
        result = result * 31 + (this.zoneOffset == null ? 0 : this.zoneOffset.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Time)) {
            return false;
        }
        Time time = (Time)other;
        if (!Intrinsics.areEqual((Object)this.localTime, (Object)time.localTime)) {
            return false;
        }
        if (this.precision != time.precision) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.zoneOffset, (Object)time.zoneOffset);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Time of(int hour, int minute, int second, int nano, int precision, @Nullable Integer tz_minutes) {
        return Companion.of(hour, minute, second, nano, precision, tz_minutes);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Time of(@NotNull LocalTime localTime, int precision, @Nullable ZoneOffset zoneOffset) {
        return Companion.of(localTime, precision, zoneOffset);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Time of(int hour, int minute, int second, int nano, int precision) {
        return Companion.of(hour, minute, second, nano, precision);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Time of(@NotNull LocalTime localTime, int precision) {
        return Companion.of(localTime, precision);
    }

    public /* synthetic */ Time(LocalTime localTime, int precision, ZoneOffset zoneOffset, DefaultConstructorMarker $constructor_marker) {
        this(localTime, precision, zoneOffset);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007JA\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/partiql/lang/eval/time/Time$Companion;", "", "()V", "LESS", "", "MORE", "of", "Lorg/partiql/lang/eval/time/Time;", "localTime", "Ljava/time/LocalTime;", "precision", "zoneOffset", "Ljava/time/ZoneOffset;", "hour", "minute", "second", "nano", "tz_minutes", "(IIIIILjava/lang/Integer;)Lorg/partiql/lang/eval/time/Time;", "partiql-lang"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Time of(int hour, int minute, int second, int nano, int precision, @Nullable Integer tz_minutes) {
            ZoneOffset zoneOffset;
            int n;
            try {
                ChronoField.HOUR_OF_DAY.checkValidValue(hour);
                ChronoField.MINUTE_OF_HOUR.checkValidValue(minute);
                ChronoField.SECOND_OF_MINUTE.checkValidValue(second);
                ChronoField.NANO_OF_SECOND.checkValidValue(nano);
                Integer n2 = tz_minutes;
                if (n2 != null) {
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    ChronoField.OFFSET_SECONDS.checkValidIntValue(it * 60);
                }
            }
            catch (DateTimeException dte) {
                throw new EvaluationException(dte, ErrorCode.EVALUATOR_TIME_FIELD_OUT_OF_RANGE, PropertyMapHelpersKt.propertyValueMapOf(new Pair[0]), false);
            }
            if (precision == 9) {
                n = nano;
            } else {
                BigDecimal bigDecimal = BigDecimal.valueOf(nano);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
                BigDecimal bigDecimal2 = BigDecimal.valueOf(1000000000);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(this.toLong())");
                BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2).setScale(precision, RoundingMode.HALF_EVEN);
                BigDecimal bigDecimal4 = BigDecimal.valueOf(1000000000);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"valueOf(this.toLong())");
                n = bigDecimal3.multiply(bigDecimal4).intValue();
            }
            int nanoWithPrecision = n;
            int newNano = nanoWithPrecision % 1000000000;
            int newSecond = second + nanoWithPrecision / 1000000000;
            int newMinute = minute + newSecond / 60;
            int newHour = hour + newMinute / 60;
            LocalTime localTime = LocalTime.of(newHour % 24, newMinute % 60, newSecond % 60, newNano);
            Integer n3 = tz_minutes;
            if (n3 != null) {
                int it = ((Number)n3).intValue();
                boolean bl = false;
                zoneOffset = ZoneOffset.ofTotalSeconds(it * 60);
            } else {
                zoneOffset = null;
            }
            ZoneOffset zoneOffset2 = zoneOffset;
            Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"localTime");
            return new Time(localTime, precision, zoneOffset2, null);
        }

        public static /* synthetic */ Time of$default(Companion companion, int n, int n2, int n3, int n4, int n5, Integer n6, int n7, Object object) {
            if ((n7 & 0x20) != 0) {
                n6 = null;
            }
            return companion.of(n, n2, n3, n4, n5, n6);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Time of(@NotNull LocalTime localTime, int precision, @Nullable ZoneOffset zoneOffset) {
            Intrinsics.checkNotNullParameter((Object)localTime, (String)"localTime");
            ZoneOffset zoneOffset2 = zoneOffset;
            return Companion.of(localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano(), precision, zoneOffset2 != null ? Integer.valueOf(zoneOffset2.getTotalSeconds() / 60) : null);
        }

        public static /* synthetic */ Time of$default(Companion companion, LocalTime localTime, int n, ZoneOffset zoneOffset, int n2, Object object) {
            if ((n2 & 4) != 0) {
                zoneOffset = null;
            }
            return companion.of(localTime, n, zoneOffset);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Time of(int hour, int minute, int second, int nano, int precision) {
            return org.partiql.lang.eval.time.Time$Companion.of$default(this, hour, minute, second, nano, precision, null, 32, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Time of(@NotNull LocalTime localTime, int precision) {
            Intrinsics.checkNotNullParameter((Object)localTime, (String)"localTime");
            return org.partiql.lang.eval.time.Time$Companion.of$default(this, localTime, precision, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

